#include "DialogWindowPage.h"

#include "Dialog.h"

#define Inherited DialogWindowPageData

DialogWindowPage::DialogWindowPage
(
    Dialog* dialog,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    itsCaption->setText( dialog->GetCaption() );

    switch( dialog->itsLayout->GetLayoutType() )
    {
	case WidgetLayout::None:
	{
	    isLayoutNone->setChecked( TRUE );
	    break;
	}
	case WidgetLayout::Box:
	{
	    isLayoutBox->setChecked( TRUE );
	    break;
	}
    }

    WFlags flags = dialog->GetWindowFlags();

    isNormalBorder->setChecked( flags & WStyle_NormalBorder );
    isDialogBorder->setChecked( flags & WStyle_DialogBorder );
    isNoBorder->setChecked( flags & WStyle_NoBorder );
    isStyleTitle->setChecked( flags & WStyle_Title );
    isStyleSysMenu->setChecked( flags & WStyle_SysMenu );
    isStyleMin->setChecked( flags & WStyle_Minimize );
    isStyleMax->setChecked( flags & WStyle_Maximize );
    isStyleToolWnd->setChecked( flags & WStyle_Tool );	
}


DialogWindowPage::~DialogWindowPage()
{
}


void DialogWindowPage::Apply( Dialog* dialog )
{
    dialog->SetCaption( itsCaption->text() );

    WidgetLayout::LayoutType type = WidgetLayout::None;
    if( isLayoutBox->isChecked() )
    {
	type = WidgetLayout::Box;
    }
    
    dialog->itsLayout->SetLayoutType( type );

    WFlags flags = 0;
    
    if( isNormalBorder->isChecked() )
    {
	flags |= WStyle_NormalBorder;
    }

    if( isDialogBorder->isChecked() )
    {
	flags |= WStyle_DialogBorder;
    }
    
    if( isNoBorder->isChecked() )
    {
	flags |= WStyle_NoBorder;
    }
    
    if( isStyleTitle->isChecked() )
    {
	flags |= WStyle_Title;
    }
    
    if( isStyleSysMenu->isChecked() )
    {
	flags |= WStyle_SysMenu;
    }
    
    if( isStyleMin->isChecked() )
    {
	flags |= WStyle_Minimize;
    }
    
    if( isStyleMax->isChecked() )
    {
	flags |= WStyle_Maximize;
    }
    
    if( isStyleToolWnd->isChecked() )
    {
	flags |= WStyle_Tool;
    }

    // add the custimized flag if any of the others were set, or if NoBorder
    // is set since its value is 0
    if( (flags != 0) || isNoBorder->isChecked() )
    {
	flags |= WStyle_Customize;
    }
        
    dialog->SetWindowFlags( flags );
}


void DialogWindowPage::LayoutTypeClicked( int )
{
    WidgetLayout::LayoutType type = WidgetLayout::None;
    
    if( isLayoutBox->isChecked() )
    {
	type = WidgetLayout::Box;
    }
    
    emit LayoutTypeChanged( type );
}

	  
