/**********************************************************************

	--- Dlgedit generated file ---

	File: WidgetLayoutPage.cpp
	Last generated: Tue May 20 15:30:42 1997

 *********************************************************************/

#include "WidgetLayoutPage.h"

#include "widget/DlgWidget.h"
#include "layout/BoxLayout.h"
#include "layout/BoxWidget.h"

#define Inherited WidgetLayoutPageData

WidgetLayoutPage::WidgetLayoutPage
(
    DlgWidget* widget,
    BoxLayout*	layout,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    isInLayout->setChecked( widget->GetLayoutStatus() != DlgWidget::NoLayout );
    isInLayout->setEnabled( layout != NULL );

    if( widget->GetLayoutStatus() == DlgWidget::InLayout )
    {
	BoxWidget* box = layout->FindBoxWidget( widget );

	if( box )
	{
	    QString str;
	    itsStretch->setText( str.setNum( box->GetStretch() ) );
	
	    int align = box->GetAlignment();
	    if( align & (AlignTop | AlignLeft) )
	    {
		isTopLeft->setChecked( TRUE );
	    }
	    else if( align & AlignCenter )
	    {
		isCenter->setChecked( TRUE );
	    }
	    else if( align & (AlignBottom | AlignRight) )
	    {
		isBottomRight->setChecked( TRUE );
	    }
	}
    }
    else
    {
	BoxWidget box( NULL, NULL, NULL );

	QString str;
	itsStretch->setText( str.setNum( box.GetStretch() ) );
	
	int align = box.GetAlignment();
	if( align & (AlignTop | AlignLeft) )
	{
	    isTopLeft->setChecked( TRUE );
	}
	else if( align & AlignCenter )
	{
	    isCenter->setChecked( TRUE );
	}
	else if( align & (AlignBottom | AlignRight) )
	{
	    isBottomRight->setChecked( TRUE );
	}
    }

    Update();
}


WidgetLayoutPage::~WidgetLayoutPage()
{
}


void WidgetLayoutPage::Apply
(
    DlgWidget*	widget,
    BoxLayout*	layout
)
{
    if( layout )
    {
	QString stretch = itsStretch->text();
	    
	int align;
	if( isTopLeft->isChecked() )
	{
	    align = AlignTop | AlignLeft;
	}
	else if( isCenter->isChecked() )
	{
	    align = AlignCenter;
	}
	else if( isBottomRight->isChecked() )
	{
	    align = AlignBottom | AlignRight;
	}

	DlgWidget::LayoutStatus layoutStatus = widget->GetLayoutStatus();
	// remove the widget from the layout
	if( (layoutStatus == DlgWidget::InLayout) && !isInLayout->isChecked() )
	{
	    layout->RemoveWidget( widget );
	}
	// add the widget to the layout
	else if( (layoutStatus == DlgWidget::NoLayout) && 
		 isInLayout->isChecked() )
	{
	    layout->AddBoxWidget( widget, stretch.toInt(), align );
	}
	// set the properties on the box widget
	else if( layoutStatus == DlgWidget::InLayout )
	{
	    BoxWidget* box = layout->FindBoxWidget( widget );

	    ASSERT( box );
	    
	    box->SetStretch( stretch.toInt() );
	    box->SetAlignment( align );
	}	    
    }
}


void WidgetLayoutPage::Update( void )
{
    bool inLayout = isInLayout->isChecked();
    
    itsStretchLabel->setEnabled( inLayout );
    itsStretch->setEnabled( inLayout );
    itsAlignmentBG->setEnabled( inLayout );
    isTopLeft->setEnabled( inLayout );
    isCenter->setEnabled( inLayout );
    isBottomRight->setEnabled( inLayout );
}


void WidgetLayoutPage::AddToLayoutClicked()
{
    Update();
}
