#include "widget/Slider.h"

#define Inherited QSlider

Slider::Slider
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( QSlider::Horizontal, widget, name )
{
}


void Slider::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void Slider::mouseDoubleClickEvent( QMouseEvent*	event )
{
    emit MouseDoubleClick( this, event );
}


void Slider::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void Slider::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void Slider::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void Slider::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this, event );
}


void Slider::moveEvent
(
    QMoveEvent*	event
)
{
    Inherited::moveEvent( event );
    
    emit Move( this, event );
}





