/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TDialogEditor
#define TDialogEditor TDialogEditor

#include <toad/pointer.hh>

class TDialogEditor;
typedef GSmartPointer<TDialogEditor> PDialogEditor;

class TDialogEditor:
	public TSmartObject
{
		static PDialogEditor active_editor;
		static TWindow* ctrl_window;
		static TWindow* edit_window;

	public:
		TDialogEditor();
		virtual ~TDialogEditor();

		static void SetDialogEditor(TDialogEditor *e) { active_editor = e; }
		static TDialogEditor* DialogEditor() { return active_editor; } 

		static void SetCtrlWindow(TWindow *w) { ctrl_window = w; }
		static TWindow* CtrlWindow() { return ctrl_window; }

		static void SetEditWindow(TWindow *w);
		static TWindow* EditWindow() { return edit_window; }

		static bool enabled;
		static bool running;
		
		// messages from the window being edited
		virtual void windowChanged(TWindow *wold, TWindow *wnew) = 0 ;
		virtual void paint()=0;
		virtual void mouseLDown(int,int,unsigned)=0;
		virtual void mouseMove(int,int,unsigned)=0;
		virtual void mouseLUp(int,int,unsigned)=0;
		virtual void keyDown(TKey,char*,unsigned)=0;
};

#endif
