/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TRadioButtonBase
#define TRadioButtonBase TRadioButtonBase

#include <toad/buttonbase.hh>
#include <toad/pointer.hh>
#include <vector>

class TRadioButtonBase;

class TRadioState:
	public TSmartObject
{
		friend TRadioButtonBase;
		
		TRadioButtonBase *_current;
		typedef vector<TRadioButtonBase*> TListenerBuffer;
		TListenerBuffer listener;
		void Register(TRadioButtonBase*);
		void Unregister(TRadioButtonBase*);
		
	public:
		TRadioState();
		void SetCurrent(TRadioButtonBase*);
		TRadioButtonBase* Current() { return _current; }
		TSignal sigValueChanged;
		void SetValue(int);
		int Value();
};

typedef GSmartPointer<TRadioState> PRadioState;

class TRadioButtonBase: public TButtonBase
{
		typedef TButtonBase super;
	public:
		TRadioButtonBase(TWindow *p, const string &t, int group, int value)
			:super(p,t)
		{
			_group = group;
			_value = value;
			_state = NULL;
		}
		TRadioButtonBase(TWindow *p, const string &t, TRadioState *state, int value)
			:super(p,t)
		{
			_group = -1;
			_value = value;
			_state = state;
			_state->Register(this);
		}
		~TRadioButtonBase() {
			if (_state)
				_state->Unregister(this);
		}
		void SetDown(bool down=true);
		void _SetDown(bool);
		void SetValue(int);
		int Value();
		void SetGroup(int group) { _group = group; }
		int Group() { return _group; }

		TSignal sigDeactivate;
		
	protected:
		void mouseLDown(int,int,unsigned);
		void keyDown(TKey,char*,unsigned);

		int _value;
		int _group;
		PRadioState _state;
		void _ClearGroupMember();
};

#endif
