/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

/** UNDER CONSTRUCTION ***** UNDER CONSTRUCTION *****  UNDER CONSTR*/

#include <toad/toad.hh>
#include <toad/scrollbar.hh>
#include <toad/region.hh>
#include <toad/scrolledarea.hh>

//!TScrolledArea
//.<OL>
//.	<LI> size of an item
//. <LI> size of the area by count of items
//. <LI> position of the upper left corner by count of items
//.</OL>


// constructor
//-------------------------------------
TScrolledArea::TScrolledArea(TWindow *p, const string &t):TWindow(p,t)
{
	SetArea(0,0);
	hscroll = vscroll = NULL;
	bAlwaysVertical = bAlwaysHorizontal = false;
}

// SetArea
//-------------------------------------
void TScrolledArea::SetArea(int aw, int ah, int x, int y, int iw, int ih)
{
	area_w=aw; area_h=ah;
	area_x=x;  area_y=y;
	item_w=iw; item_h=ih;
	visi_w = visi_h = 0;
	
	if (IsRealized())	{
		pArrangeSB();
		Invalidate();
	}
}

void TScrolledArea::SetItemSize(int w,int h)
{
	item_w = w;
	item_h = h;
}

void TScrolledArea::SetVisibleAreaPos(int x,int y)
{
	area_x = x;
	area_y = y;
}

void TScrolledArea::SetAreaSize(int w,int h)
{
	area_w = w;
	area_h = h;
}

void TScrolledArea::SetVisibleAreaSize(int w,int h)
{
	#warning "this is a hack"
	SetSize(w*item_w+TScrollBar::FixedSize(),h*item_h);
}

// actVScroll
//-------------------------------------
void TScrolledArea::actVScroll()
{
	int ny = vscroll->Value();		// new position
	int dy = ny - area_y;						// movement
	area_y = ny;										// set new position
	if (abs(dy)<visi_h)							// part of the area is still visible
	{
		ScrollWindow(0,-dy*item_h);					// generates 'paint' event
	}	else {
		Invalidate();
	}
}

// actHScroll
//-------------------------------------
void TScrolledArea::actHScroll()
{
	int nx = hscroll->Value();		// new position
	int dx = nx - area_x;						// movement
	area_x = nx;										// set new position
	if (abs(dx)<visi_w)							// part of the area is still visible
	{
		ScrollWindow(-dx*item_w,0);		// generates 'paint' event
	}	else {
		Invalidate();
	}
}

// pArrangeSB
//-------------------------------------
void TScrolledArea::pArrangeSB()
{
	// calculate visible area
	//------------------------
	visi_w = Width() / item_w;
	visi_h = Height() / item_h;
	
	// test which scrollbars are neccessary
	//--------------------------------------
	bool need_h, need_v;
	need_h = need_v = false;

	if (bAlwaysVertical || visi_h<area_h)	// need vertical scrollbar
	{
		need_v = true;
		visi_w = (Width()-TScrollBar::FixedSize()) / item_w;
	}
	
	if (bAlwaysHorizontal || visi_w < area_w)	// need horizontal scrollbar
	{
		need_h = true;
		visi_h = (Height()-TScrollBar::FixedSize()) / item_h;
	}
	
	// after adding only a horizontal scrollbar a vertical may be needed now
	if (!need_v && visi_h < area_h)	{
		need_v = true;
		visi_w = (Width()-TScrollBar::FixedSize()) / item_w;
	}
	
	// ensure that most of the area is visible
	//-----------------------------------------
	if (area_y+visi_h > area_h)	{
		area_y = area_h - visi_h;
		if (area_y < 0)
			area_y = 0;
	}

	if (area_x+visi_w > area_w)	{
		area_x = area_w - visi_w;
		if (area_x < 0)
			area_x = 0;
	}

	// create and destroy scrollbars
	//-------------------------------
	// NOTE: since a window is wasting about ?bytes of server memory,
	//       i believe it's a good idea to destroy them when not needed
	if (need_v)	{
		if (!vscroll)	{
			vscroll = new TVScrollBar(this,"");
			vscroll->bNoFocus = true;
			OLD_CONNECT(this,actVScroll, vscroll,vscroll->sigValueChanged);
		}	else {
			need_v = false;
		}
	}	else {
		if (vscroll) {
			delete vscroll;
			vscroll = NULL;
		}
	}

	if (need_h)	{
		if (!hscroll)	{
			hscroll = new THScrollBar(this,"");
			hscroll->bNoFocus = true;
			OLD_CONNECT(this,actHScroll, hscroll,hscroll->sigValueChanged);
		}	else {
			need_h = false;
		}
	}	else {
		if (hscroll) {
			delete hscroll;
			hscroll = NULL;
		}
	}

	// arrange scrollbars
	//--------------------
	if (vscroll) {
		vscroll->SetShape(
			Width()-TScrollBar::FixedSize(),
			0,
			TSIZE_PREVIOUS,
			(hscroll ? Height()-TScrollBar::FixedSize() : Height())
		);
		vscroll->SetRange(0,area_h-1);
		vscroll->SetVisible(visi_h);
		vscroll->SetValue(area_y);
	}

	if (hscroll) {
		hscroll->SetShape(
			0,
			Height()-TScrollBar::FixedSize(),
			vscroll ? Width()-TScrollBar::FixedSize() : Width(),
			TSIZE_PREVIOUS
		);

		hscroll->SetRange(0,area_w-1);
		hscroll->SetVisible(visi_w);
		hscroll->SetValue(area_x);
	}
	
	// create new scrollbars
	//-----------------------
	if (IsRealized() && need_v)
		vscroll->Create();
		
	if (IsRealized() && need_h)
		hscroll->Create();
}

// resize
//--------
void TScrolledArea::resize()
{
	pArrangeSB();
}

void TScrolledArea::ClipPen(TPen &pen)
{
	if (vscroll && hscroll) {
		TRectangle r(0,0,
			Width()-TScrollBar::FixedSize(),
			Height()-TScrollBar::FixedSize() );
		if (bNoBackground) {
			TPen pen2(this);
			pen.SetColor(TColor::DIALOG);
			pen.FillRectangle(Width()-TScrollBar::FixedSize(),
												Height()-TScrollBar::FixedSize(),
												TScrollBar::FixedSize(),
												TScrollBar::FixedSize() );
		}	
		pen&=r;
	}
}
