/*
 * $XConsortium: xperfmon.c,v 1.6 89/09/19 14:44:02 jim Exp $
 * 
 * xperfmon
 * X Window System -based Unix Performance Monitor.
 * Simple graphical performance monitor for system-wide data.
 *
 * Copyright 1985, Massachusetts Institute of Technology
 * Copyright 1989, PCS Computer Systeme GmbH, West Germany
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of PCS not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  PCS makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * PCS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL PCS
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * This original version was completed by Emanuel Jay Berkenbilt,
 * MIT Project Athena on 1/21/1988.  The program was built directly
 * on the Xlib.
 *
 * The current version was modified from the original by Thomas Bagli,
 * PCS GmbH on 8/8/89.  It is X Toolkit and Athena Widget -based.
 *
 * Copyright 1994, Roger Smith for Sterling Software and NASA-Ames Research Center
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of NASA and Sterling Software (collectively 
 * or individually) are not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  NASA and Sterling Software makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * NASA & STERLING SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL NASA & STERLING SOFTWARE
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * 1994 Revision
 * Author:           Roger Smith, Sterling Software @ NASA-Ames Research Center
 *                   Moffett Field, California, rsmith@proteus.arc.nasa.gov
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include "StripChart.h"
#include "TimeChart.h"
#include "xperfmon.bm"
#include "system.h"

extern void exit();
extern int sys_setup();
extern void start_graphs();
extern time_t timeStamp;
extern Dimension oldHeight, oldWidth;
extern int current_values[NUM_GRAPHS];

char *gprogname;
double testValue;
Bool down=FALSE;
Bool mono_screen;
int forceBoxG;

extern void HandleKey();

static char defaultTranslations[] =
    "<KeyDown>:    HandleKey()    ";

static XtActionsRec actionsTable[] = {
     { "HandleKey",    HandleKey },
     { NULL,           NULL      },
};

#define XtNinterval "interval"
#define XtNhelpGeneral "helpGeneral"
#define XtCHelpGeneral "HelpGeneral"
#define XtNhelpGraphs "helpGraphs"
#define XtCHelpGraphs "HelpGraphs"
#define XtNhelpGroups "helpGroups"
#define XtCHelpGroups "HelpGroups"
#define XtNhelpAlarms "helpAlarms"
#define XtCHelpAlarms "HelpAlarms"
#define XtNcount "count"
#define XtCCount "Count"
#define XtNfill "fill"
#define XtCFill "Fill"
#define XtNfast "fast"
#define XtCFast "Fast"
#define XtNstufAdd "stufAdd"
#define XtCStufAdd "StufAdd"
#define XtNstufSub "stufSub"
#define XtCStufSub "StufSub"
#define XtNdebug "debug"
#define XtCDebug "Debug"
#define XtNusercpuAdd "usercpuAdd"
#define XtCUsercpuAdd "UsercpuAdd"
#define XtNusercpuSub "usercpuSub"
#define XtCUsercpuSub "UsercpuSub"
#define XtNsystemcpuAdd "systemcpuAdd"
#define XtCSystemcpuAdd "SystemcpuAdd"
#define XtNsystemcpuSub "systemcpuSub"
#define XtCSystemcpuSub "SystemcpuSub"
#define XtNidlecpuAdd "idlecpuAdd"
#define XtCIdlecpuAdd "IdlecpuAdd"
#define XtNidlecpuSub "idlecpuSub"
#define XtCIdlecpuSub "IdlecpuSub"
#define XtNfreememAdd "freememAdd"
#define XtCFreememAdd "FreememAdd"
#define XtNfreememSub "freememSub"
#define XtCFreememSub "FreememSub"
#define XtNdiskxfrAdd "diskxfrAdd"
#define XtCDiskxfrAdd "DiskxfrAdd"
#define XtNdiskxfrSub "diskxfrSub"
#define XtCDiskxfrSub "DiskxfrSub"
#define XtNinterruptsAdd "interruptsAdd"
#define XtCInterrputsAdd "InterrputsAdd"
#define XtNinterruptsSub "interruptsSub"
#define XtCInterrputsSub "InterrputsSub"
#define XtNinputpktsAdd "inputpktsAdd"
#define XtCInputpktsAdd "InputpktsAdd"
#define XtNinputpktsSub "inputpktsSub"
#define XtCInputpktsSub "InputpktsSub"
#define XtNoutputpktsAdd "outputpktsAdd"
#define XtCOutputpktsAdd "OutputpktsAdd"
#define XtNoutputpktsSub "outputpktsSub"
#define XtCOutputpktsSub "OutputpktsSub"
#define XtNcollpktsAdd "collpktsAdd"
#define XtCCollpktsAdd "CollpktsAdd"
#define XtNcollpktsSub "collpktsSub"
#define XtCCollpktsSub "CollpktsSub"
#define XtNnfsclientAdd "nfsclientAdd"
#define XtCNfsclientAdd "NfsclientAdd"
#define XtNnfsclientSub "nfsclientSub"
#define XtCNfsclientSub "NfsclientSub"
#define XtNnfsserverAdd "nfsserverAdd"
#define XtCNfsserverAdd "NfsserverAdd"
#define XtNnfsserverSub "nfsserverSub"
#define XtCNfsserverSub "NfsserverSub"

#define XtNloadAvgAdd "loadAvgAdd"
#define XtCLoadAvgAdd "LoadAvgAdd"
#define XtNloadAvgSub "loadAvgSub"
#define XtCLoadAvgSub "LoadAvgSub"
#define XtNfreeSwapAdd "freeSwapAdd"
#define XtCFreeSwapAdd "FreeSwapAdd"
#define XtNfreeSwapSub "freeSwapSub"
#define XtCFreeSwapSub "FreeSwapSub"
#define XtNswapInAdd "swapInAdd"
#define XtCSwapInAdd "SwapInAdd"
#define XtNswapInSub "swapInSub"
#define XtCSwapInSub "SwapInSub"
#define XtNswapOutAdd "swapOutAdd"
#define XtCSwapOutAdd "SwapOutAdd"
#define XtNswapOutSub "swapOutSub"
#define XtCSwapOutSub "SwapOutSub"
#define XtNpageInAdd "pageInAdd"
#define XtCPageInAdd "PageInAdd"
#define XtNpageInSub "pageInSub"
#define XtCPageInSub "PageInSub"
#define XtNpageOutAdd "pageOutAdd"
#define XtCPageOutAdd "PageOutAdd"
#define XtNpageOutSub "pageOutSub"
#define XtCPageOutSub "PageOutSub"
#define XtNprocessesAdd "processesAdd"
#define XtCProcessesAdd "ProcessesAdd"
#define XtNprocessesSub "processesSub"
#define XtCProcessesSub "ProcessesSub"
#define XtNcpuSwitchAdd "cpuSwitchAdd"
#define XtCCpuSwitchAdd "CpuSwitchAdd"
#define XtNcpuSwitchSub "cpuSwitchSub"
#define XtCCpuSwitchSub "CpuSwitchSub"
#define XtNnfsGroupAdd "nfsGroupAdd"
#define XtCNfsGroupAdd "NfsGroupAdd"
#define XtNnfsGroupSub "nfsGroupSub"
#define XtCNfsGroupSub "NfsGroupSub"
#define XtNnetGroupAdd "netGroupAdd"
#define XtCNetGroupAdd "NetGroupAdd"
#define XtNnetGroupSub "netGroupSub"
#define XtCNetGroupSub "NetGroupSub"
#define XtNsysGroupAdd "sysGroupAdd"
#define XtCSysGroupAdd "SysGroupAdd"
#define XtNsysGroupSub "sysGroupSub"
#define XtCSysGroupSub "SysGroupSub"
#define XtNpageGroupAdd "pageGroupAdd"
#define XtCPageGroupAdd "PageGroupAdd"
#define XtNpageGroupSub "pageGroupSub"
#define XtCPageGroupSub "PageGroupSub"
#define XtNswapGroupAdd "swapGroupAdd"
#define XtCSwapGroupAdd "SwapGroupAdd"
#define XtNswapGroupSub "swapGroupSub"
#define XtCSwapGroupSub "SwapGroupSub"
#define XtNcpuGroupAdd "cpuGroupAdd"
#define XtCCpuGroupAdd "CpuGroupAdd"
#define XtNcpuGroupSub "cpuGroupSub"
#define XtCCpuGroupSub "CpuGroupSub"

#define DEF_INTERVAL	5
#define DEF_COUNT	-1
#define MS_PER_SEC 1000
#define SLOWEST_INTERVAL 100

static int defaultInterval = DEF_INTERVAL;
static int defaultCount = DEF_COUNT;
Widget perfmon[NUM_GRAPHS], timechart, labelBox, pappaBox;

AppData appData;

/*
*  Command line options table. The command line is parsed for these,
*  and it sets/overrides the appropriate values in the resource
*  database
*/
static XrmOptionDescRec optionDescList[] = {
    { "-interval",  ".interval",    XrmoptionSepArg,    (caddr_t) NULL},
    { "-immediate", "*PerfChart.immediate", XrmoptionNoArg, "False" },
    { "-current",   "*PerfChart.current",   XrmoptionNoArg, "False" },

    { "-lowmemAlarm", "*perfChartFree.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowmemWarn", "*perfChartFree.lowWarn", XrmoptionSepArg, NULL },
    { "-highmemAlarm", "*perfChartFree.highAlarm", XrmoptionSepArg, NULL },
    { "-highmemWarn", "*perfChartFree.highWarn", XrmoptionSepArg, NULL },

    { "-lowuserAlarm", "*perfChartUser.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowuserWarn", "*perfChartUser.lowWarn", XrmoptionSepArg, NULL },
    { "-highuserAlarm", "*perfChartUser.highAlarm", XrmoptionSepArg, NULL },
    { "-highuserWarn", "*perfChartUser.highWarn", XrmoptionSepArg, NULL },

    { "-lowsysAlarm", "*perfChartSystem.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowsysWarn", "*perfChartSystem.lowWarn", XrmoptionSepArg, NULL },
    { "-highsysAlarm", "*perfChartSystem.highAlarm", XrmoptionSepArg, NULL },
    { "-highsysWarn", "*perfChartSystem.highWarn", XrmoptionSepArg, NULL },

    { "-lowidleAlarm", "*perfChartIdle.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowidleWarn", "*perfChartIdle.lowWarn", XrmoptionSepArg, NULL },
    { "-highidleAlarm", "*perfChartIdle.highAlarm", XrmoptionSepArg, NULL },
    { "-highidleWarn", "*perfChartIdle.highWarn", XrmoptionSepArg, NULL },

    { "-lowdiskAlarm", "*perfChartDisk.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowdiskWarn", "*perfChartDisk.lowWarn", XrmoptionSepArg, NULL },
    { "-highdiskAlarm", "*perfChartDisk.highAlarm", XrmoptionSepArg, NULL },
    { "-highdiskWarn", "*perfChartDisk.highWarn", XrmoptionSepArg, NULL },

    { "-lowintrptsAlarm", "*perfChartIntrpts.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowintrptsWarn", "*perfChartIntrpts.lowWarn", XrmoptionSepArg, NULL },
    { "-highintrptsAlarm", "*perfChartIntrpts.highAlarm", XrmoptionSepArg, NULL },
    { "-highintrptsWarn", "*perfChartIntrpts.highWarn", XrmoptionSepArg, NULL },

    { "-lowinputAlarm", "*perfChartInput.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowinputWarn", "*perfChartInput.lowWarn", XrmoptionSepArg, NULL },
    { "-highinputAlarm", "*perfChartInput.highAlarm", XrmoptionSepArg, NULL },
    { "-highinputWarn", "*perfChartInput.highWarn", XrmoptionSepArg, NULL },

    { "-lowoutputAlarm", "*perfChartOutput.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowoutputWarn", "*perfChartOutput.lowWarn", XrmoptionSepArg, NULL },
    { "-highoutputAlarm", "*perfChartOutput.highAlarm", XrmoptionSepArg, NULL },
    { "-highoutputWarn", "*perfChartOutput.highWarn", XrmoptionSepArg, NULL },

    { "-lowcollisionAlarm", "*perfChartCollision.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowcollisionWarn", "*perfChartCollision.lowWarn", XrmoptionSepArg, NULL },
    { "-highcollisionAlarm", "*perfChartCollision.highAlarm", XrmoptionSepArg, NULL },
    { "-highcollisionWarn", "*perfChartCollision.highWarn", XrmoptionSepArg, NULL },

/*SC
    { "-lownfsclientAlarm", "*perfChartNFSClient.lowAlarm", XrmoptionSepArg, NULL },
    { "-lownfsclientWarn", "*perfChartNFSClient.lowWarn", XrmoptionSepArg, NULL },
    { "-highnfsclientAlarm", "*perfChartNFSClient.highAlarm", XrmoptionSepArg, NULL },
    { "-highnfsclientWarn", "*perfChartNFSClient.highWarn", XrmoptionSepArg, NULL },
  
    { "-lownfsserverAlarm", "*perfChartNFSServer.lowAlarm", XrmoptionSepArg, NULL },
    { "-lownfsserverWarn", "*perfChartNFSServer.lowWarn", XrmoptionSepArg, NULL },
    { "-highnfsserverAlarm", "*perfChartNFSServer.highAlarm", XrmoptionSepArg, NULL },
    { "-highnfsserverWarn", "*perfChartNFSServer.highWarn", XrmoptionSepArg, NULL },
SC*/
    { "-lowprocessesAlarm", "*perfChartProcesses.lowAlarm", XrmoptionSepArg, NULL },
    { "-lowprocessesWarn", "*perfChartProcesses.lowWarn", XrmoptionSepArg, NULL },
    { "-highprocessesAlarm", "*perfChartProcesses.highAlarm", XrmoptionSepArg, NULL },
    { "-highprocessesWarn", "*perfChartProcesses.highWarn", XrmoptionSepArg, NULL },
/*SC*/

    { "-helpgeneral", XtNhelpGeneral, XrmoptionNoArg, "True" },
    { "-helpgraphs", XtNhelpGraphs, XrmoptionNoArg, "True" },
    { "-helpgroups", XtNhelpGroups, XrmoptionNoArg, "True" },
    { "-helpalarms", XtNhelpAlarms, XrmoptionNoArg, "True" },

    { "-count",	    ".count",	    XrmoptionSepArg,    (caddr_t) NULL},
    { "-fill",      "*fill",        XrmoptionNoArg,     "True" },
    { "-debug",     "*debug",       XrmoptionNoArg,     "True" },
    { "-fast",      "*fast",        XrmoptionNoArg,     (XtPointer)"True" },
    { "-usercpu",   XtNusercpuSub,     XrmoptionNoArg,     "True" },
    { "+usercpu",   XtNusercpuAdd,     XrmoptionNoArg,     "TRUE" },
    { "-systemcpu", XtNsystemcpuSub,     XrmoptionNoArg,     "True" },
    { "+systemcpu", XtNsystemcpuAdd,     XrmoptionNoArg,     "TRUE" },
    { "-idlecpu",   XtNidlecpuSub,     XrmoptionNoArg,     "True" },
    { "+idlecpu",   XtNidlecpuAdd,     XrmoptionNoArg,     "TRUE" },
    { "-freemem",   XtNfreememSub,     XrmoptionNoArg,     "True" },
    { "+freemem",   XtNfreememAdd,     XrmoptionNoArg,     "TRUE" },
    { "-diskxfr",   XtNdiskxfrSub,     XrmoptionNoArg,     "True" },
    { "+diskxfr",   XtNdiskxfrAdd,     XrmoptionNoArg,     "TRUE" },
    { "-interrupts",  XtNinterruptsSub ,     XrmoptionNoArg,     "True" },
    { "+interrupts",   XtNinterruptsAdd,     XrmoptionNoArg,     "TRUE" },
    { "-inputpkts",   XtNinputpktsSub,     XrmoptionNoArg,     "True" },
    { "+inputpkts",   XtNinputpktsAdd,     XrmoptionNoArg,     "TRUE" },
    { "-outputpkts",   XtNoutputpktsSub,     XrmoptionNoArg,     "True" },
    { "+outputpkts",   XtNoutputpktsAdd,     XrmoptionNoArg,     "TRUE" },
    { "-collpkts",   XtNcollpktsSub,     XrmoptionNoArg,     "True" },
    { "+collpkts",   XtNcollpktsAdd,     XrmoptionNoArg,     "TRUE" },
/*SC
    { "-nfsclient",   XtNnfsclientSub,     XrmoptionNoArg,     "True" },
    { "+nfsclient",   XtNnfsclientAdd,     XrmoptionNoArg,     "TRUE" },
    { "-nfsserver",   XtNnfsserverSub,     XrmoptionNoArg,     "True" },
    { "+nfsserver",   XtNnfsserverAdd,     XrmoptionNoArg,     "TRUE" },
SC*/
    { "-stuf",      XtNstufSub,        XrmoptionNoArg,     (XtPointer)"True" },
    { "+stuf",      XtNstufAdd,        XrmoptionNoArg,     (XtPointer)"True" },
    { "-loadavg",     XtNloadAvgSub,       XrmoptionNoArg,     "True" },
    { "+loadavg",     XtNloadAvgAdd,       XrmoptionNoArg,     "True" },
    { "-freeswap",     XtNfreeSwapSub,       XrmoptionNoArg,     "True" },
    { "+freeswap",     XtNfreeSwapAdd,       XrmoptionNoArg,     "True" },
    { "-swapin",     XtNswapInSub,       XrmoptionNoArg,     "True" },
    { "+swapin",     XtNswapInAdd,       XrmoptionNoArg,     "True" },
    { "-swapout",     XtNswapOutSub,       XrmoptionNoArg,     "True" },
    { "+swapout",     XtNswapOutAdd,       XrmoptionNoArg,     "True" },
    { "-pagein",     XtNpageInSub,       XrmoptionNoArg,     "True" },
    { "+pagein",     XtNpageInAdd,       XrmoptionNoArg,     "True" },
    { "-pageout",     XtNpageOutSub,       XrmoptionNoArg,     "True" },
    { "+pageout",     XtNpageOutAdd,       XrmoptionNoArg,     "True" },
    { "-processes",     XtNprocessesSub,       XrmoptionNoArg,     "True" },
    { "+processes",     XtNprocessesAdd,       XrmoptionNoArg,     "True" },
    { "-cpuswitch",     XtNcpuSwitchSub,       XrmoptionNoArg,     "True" },
    { "+cpuswitch",     XtNcpuSwitchAdd,       XrmoptionNoArg,     "True" },
/*SC
    { "-nfsgroup",     XtNnfsGroupSub,       XrmoptionNoArg,     "True" },
    { "+nfsgroup",     XtNnfsGroupAdd,       XrmoptionNoArg,     "True" },
SC*/
    { "-netgroup",     XtNnetGroupSub,       XrmoptionNoArg,     "True" },
    { "+netgroup",     XtNnetGroupAdd,       XrmoptionNoArg,     "True" },
    { "-sysgroup",     XtNsysGroupSub,       XrmoptionNoArg,     "True" },
    { "+sysgroup",     XtNsysGroupAdd,       XrmoptionNoArg,     "True" },
    { "-pagegroup",     XtNpageGroupSub,       XrmoptionNoArg,     "True" },
    { "+pagegroup",     XtNpageGroupAdd,       XrmoptionNoArg,     "True" },
    { "-swapgroup",     XtNswapGroupSub,       XrmoptionNoArg,     "True" },
    { "+swapgroup",     XtNswapGroupAdd,       XrmoptionNoArg,     "True" },
    { "-cpugroup",      XtNcpuGroupSub,       XrmoptionNoArg,     "True" },
    { "+cpugroup",      XtNcpuGroupAdd,       XrmoptionNoArg,     "True" },
};

/* Application Resource List - no particular widget */

static XtResource resources[] = {
    { XtNstufAdd, XtCStufAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, stuf1), XtRImmediate, (XtPointer) NULL },
    { XtNstufSub, XtCStufSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, stuf2), XtRImmediate, (XtPointer) NULL },
    { XtNinterval, XtCInterval, XtRInt, sizeof(int),
	  XtOffsetOf(AppData, interval), XtRImmediate, (caddr_t) DEF_INTERVAL },
    { XtNcount, XtCCount, XtRInt, sizeof(int),
	  XtOffsetOf(AppData, count), XtRImmediate, (caddr_t) DEF_COUNT },
    { XtNfill, XtCFill, XtRBoolean, sizeof(Boolean),
	  XtOffsetOf(AppData, fill), XtRImmediate, (caddr_t)NULL },
    { XtNdebug, XtCDebug, XtRBoolean, sizeof(Boolean),
	  XtOffsetOf(AppData, debug), XtRImmediate, (caddr_t)NULL },
    { XtNfast, XtCFast, XtRBoolean, sizeof(Boolean),
	  XtOffsetOf(AppData, fast), XtRImmediate, (XtPointer) NULL },

    { XtNhelpGeneral, XtCHelpGeneral, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, helpReq[HELP_GENERAL]), XtRImmediate, (XtPointer) NULL },
    { XtNhelpGraphs, XtCHelpGraphs, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, helpReq[HELP_GRAPHS]), XtRImmediate, (XtPointer) NULL },
    { XtNhelpGroups, XtCHelpGroups, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, helpReq[HELP_GROUPS]), XtRImmediate, (XtPointer) NULL },
    { XtNhelpAlarms, XtCHelpAlarms, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, helpReq[HELP_ALARMS]), XtRImmediate, (XtPointer) NULL },
    { XtNusercpuAdd, XtCUsercpuAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[USR_CPU]), XtRImmediate, (XtPointer) NULL },
    { XtNusercpuSub, XtCUsercpuSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[USR_CPU]), XtRImmediate, (XtPointer) NULL },
    { XtNsystemcpuAdd, XtCSystemcpuAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[SYS_CPU]), XtRImmediate, (XtPointer) NULL },
    { XtNsystemcpuSub, XtCSystemcpuSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[SYS_CPU]), XtRImmediate, (XtPointer) NULL },
    { XtNidlecpuAdd, XtCIdlecpuAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[IDL_CPU]), XtRImmediate, (XtPointer) NULL },
    { XtNidlecpuSub, XtCIdlecpuSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[IDL_CPU]), XtRImmediate, (XtPointer) NULL },
    { XtNfreememAdd, XtCFreememAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[FRE_MEM]), XtRImmediate, (XtPointer) NULL },
    { XtNfreememSub, XtCFreememSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[FRE_MEM]), XtRImmediate, (XtPointer) NULL },
    { XtNdiskxfrAdd, XtCDiskxfrAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[DSK_XFR]), XtRImmediate, (XtPointer) NULL },
    { XtNdiskxfrSub, XtCDiskxfrSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[DSK_XFR]), XtRImmediate, (XtPointer) NULL },
    { XtNinterruptsAdd, XtCInterrputsAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[INTRPTS]), XtRImmediate, (XtPointer) NULL },
    { XtNinterruptsSub, XtCInterrputsSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[INTRPTS]), XtRImmediate, (XtPointer) NULL },
    { XtNinputpktsAdd, XtCInputpktsAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[INP_PKT]), XtRImmediate, (XtPointer) NULL },
    { XtNinputpktsSub, XtCInputpktsSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[INP_PKT]), XtRImmediate, (XtPointer) NULL },
    { XtNoutputpktsAdd, XtCOutputpktsAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[OUT_PKT]), XtRImmediate, (XtPointer) NULL },
    { XtNoutputpktsSub, XtCOutputpktsSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[OUT_PKT]), XtRImmediate, (XtPointer) NULL },
    { XtNcollpktsAdd, XtCCollpktsAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[COL_PKT]), XtRImmediate, (XtPointer) NULL },
    { XtNcollpktsSub, XtCCollpktsSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[COL_PKT]), XtRImmediate, (XtPointer) NULL },
/*SC
    { XtNnfsclientAdd, XtCNfsclientAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[NFS_CLT]), XtRImmediate, (XtPointer) NULL },
    { XtNnfsclientSub, XtCNfsclientSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[NFS_CLT]), XtRImmediate, (XtPointer) NULL },
    { XtNnfsserverAdd, XtCNfsserverAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[NFS_SRV]), XtRImmediate, (XtPointer) NULL },
    { XtNnfsserverSub, XtCNfsserverSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[NFS_SRV]), XtRImmediate, (XtPointer) NULL },
SC*/

    { XtNloadAvgAdd, XtCLoadAvgAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[LOAD_AVG]), XtRImmediate, (XtPointer) NULL },
    { XtNloadAvgSub, XtCLoadAvgSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[LOAD_AVG]), XtRImmediate, (XtPointer) NULL },
    { XtNfreeSwapAdd, XtCFreeSwapAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[FREE_SWAP]), XtRImmediate, (XtPointer) NULL },
    { XtNfreeSwapSub, XtCFreeSwapSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[FREE_SWAP]), XtRImmediate, (XtPointer) NULL },
    { XtNswapInAdd, XtCSwapInAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[SWAP_IN]), XtRImmediate, (XtPointer) NULL },
    { XtNswapInSub, XtCSwapInSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[SWAP_IN]), XtRImmediate, (XtPointer) NULL },
    { XtNswapOutAdd, XtCSwapOutAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[SWAP_OUT]), XtRImmediate, (XtPointer) NULL },
    { XtNswapOutSub, XtCSwapOutSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[SWAP_OUT]), XtRImmediate, (XtPointer) NULL },
    { XtNpageInAdd, XtCPageInAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[PAGE_IN]), XtRImmediate, (XtPointer) NULL },
    { XtNpageInSub, XtCPageInSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[PAGE_IN]), XtRImmediate, (XtPointer) NULL },
    { XtNpageOutAdd, XtCPageOutAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[PAGE_OUT]), XtRImmediate, (XtPointer) NULL },
    { XtNpageOutSub, XtCPageOutSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[PAGE_OUT]), XtRImmediate, (XtPointer) NULL },
    { XtNprocessesAdd, XtCProcessesAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[PROCESSES]), XtRImmediate, (XtPointer) NULL },
    { XtNprocessesSub, XtCProcessesSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[PROCESSES]), XtRImmediate, (XtPointer) NULL },
    { XtNcpuSwitchAdd, XtCCpuSwitchAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[CPU_SWITCH]), XtRImmediate, (XtPointer) NULL },
    { XtNcpuSwitchSub, XtCCpuSwitchSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[CPU_SWITCH]), XtRImmediate, (XtPointer) NULL },
/*SC
    { XtNnfsGroupAdd, XtCNfsGroupAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[NFS_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNnfsGroupSub, XtCNfsGroupSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[NFS_GROUP]), XtRImmediate, (XtPointer) NULL },
SC*/
    { XtNnetGroupAdd, XtCNetGroupAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[NET_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNnetGroupSub, XtCNetGroupSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[NET_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNsysGroupAdd, XtCSysGroupAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[SYS_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNsysGroupSub, XtCSysGroupSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[SYS_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNpageGroupAdd, XtCPageGroupAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[PAGE_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNpageGroupSub, XtCPageGroupSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[PAGE_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNswapGroupAdd, XtCSwapGroupAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[SWAP_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNswapGroupSub, XtCSwapGroupSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[SWAP_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNcpuGroupAdd, XtCCpuGroupAdd, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, addG[CPU_GROUP]), XtRImmediate, (XtPointer) NULL },
    { XtNcpuGroupSub, XtCCpuGroupSub, XtRBool, sizeof(Bool),
	  XtOffsetOf(AppData, subG[CPU_GROUP]), XtRImmediate, (XtPointer) NULL },

};

void
general_usage()
{
    fprintf(stderr, "\nusage: xperfmon++ option option option .....\n");
    fprintf(stderr, "options:\n");
    fprintf(stderr, "    [-display [{host}]:[{vs}]]\n");
    fprintf(stderr, "				(to specify display)\n");
    fprintf(stderr,
	"    [-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
    fprintf(stderr, "				(to set window geometry)\n");
    fprintf(stderr, "    [-bw {pixels}]		(border width)\n");
    fprintf(stderr, "    [-fn {font}]		(font)\n");
    fprintf(stderr, "    [-bd {color}]		(border color)\n");
    fprintf(stderr, "    [-fg {color}]		(foreground color)\n");
    fprintf(stderr, "    [-bg {color}]		(background color)\n");
    fprintf(stderr, "    [-interval {seconds|milliseconds}]	(update interval)\n");
    fprintf(stderr, "    [-fast]                (changes interval from seconds to milliseconds)\n");
    fprintf(stderr, "    [-immediate]           (causes background limit alarm color to be based on graph min or max)\n");
    fprintf(stderr, "                           (default limit alarm color is based on current sample)\n");
    fprintf(stderr, "    [-current]             (Disable printing of current values in each graph)\n");
    fprintf(stderr, "    [-fill]                (output filled graph instead of line graph)\n\n");
    fprintf(stderr, "For further help, use:\n");
    fprintf(stderr, "    [-helpgeneral]         ( This message.)\n");
    fprintf(stderr, "    [-helpgraphs]          ( Further info on adding|removing individual graphs.)\n");
    fprintf(stderr, "    [-helpgroups]          ( Further info on adding|removing groups of graphs.)\n");
    fprintf(stderr, "    [-helpalarms]          ( Further info on setting|removing warnings & alarms.)\n");
    exit(1);
}
void graph_usage()
{
    fprintf(stderr, "\nGRAPHS:\n");
    fprintf(stderr, "    [{-+}loadavg]          ({remove|add} 1 minute load average to list of graphs\n");
    fprintf(stderr, "    [{-+}usercpu]          ({remove|add} usercpu to list of graphs\n");
    fprintf(stderr, "    [{-+}systemcpu]        ({remove|add} systemcpu to list of graphs\n");
    fprintf(stderr, "    [{-+}idlecpu]          ({remove|add} idlecpu to list of graphs\n");
    fprintf(stderr, "    [{-+}freemem]          ({remove|add} freemem to list of graphs\n");
    fprintf(stderr, "    [{-+}freeswap]         ({remove|add} free swap space to list of graphs\n");
    fprintf(stderr, "    [{-+}swapin]           ({remove|add} pages swapped in to list of graphs\n");
    fprintf(stderr, "    [{-+}swapout]          ({remove|add} pages swapped out to list of graphs\n");
    fprintf(stderr, "    [{-+}pagein]           ({remove|add} kilobytes paged in to list of graphs\n");
    fprintf(stderr, "    [{-+}pageout]          ({remove|add} kilobytes paged out to list of graphs\n");
    fprintf(stderr, "    [{-+}diskxfr]          ({remove|add} disk transfers to list of graphs\n");
    fprintf(stderr, "    [{-+}interrupts]       ({remove|add} interrupts to list of graphs\n");
    fprintf(stderr, "    [{-+}processes]        ({remove|add} Number of processes to list of graphs\n");
    fprintf(stderr, "    [{-+}cpuswitch]        ({remove|add} number of cpu context switches to list of graphs\n");
    fprintf(stderr, "    [{-+}inputpkts]        ({remove|add} input packets to list of graphs\n");
    fprintf(stderr, "    [{-+}outputpkts]       ({remove|add} output packets to list of graphs\n");
    fprintf(stderr, "    [{-+}collpkts]         ({remove|add} collision packets to list of graphs\n");
/*SC
    fprintf(stderr, "    [{-+}nfsclient]        ({remove|add} NFS client transactions count to list of graphs\n");
    fprintf(stderr, "    [{-+}nfsserver]        ({remove|add} NFS server transactions count to list of graphs\n\n");
SC*/
    fprintf(stderr, "NOTE: The default is ALL graphs! A \"-\" option takes away from the default list.\n");
    fprintf(stderr, "      Any \"+\" option resets the default list to empty and then adds the option(s).\n\n");
    exit(1);
}
void group_usage()
{
    fprintf(stderr, "\nGROUPS:\n");
/*SC
    fprintf(stderr, "    [{-+}nfsgroup]         ({remove|add} nfsclient, nfsserver\n");
SC*/
    fprintf(stderr, "    [{-+}netgroup]         ({remove|add} inputpkts, outputpkts, collpkts\n");
    fprintf(stderr, "    [{-+}sysgroup]         ({remove|add} processes, cpuswitch\n");
    fprintf(stderr, "    [{-+}pagegroup]        ({remove|add} pagein, pageout\n");
    fprintf(stderr, "    [{-+}swapgroup]        ({remove|add} freeswap, swapin, swapout\n");
    fprintf(stderr, "    [{-+}cpugroup]         ({remove|add} usercpu, systemcpu, idlecpu\n");

    fprintf(stderr, "NOTE: The default is ALL graphs! A \"-\" option takes away from the default list.\n");
    fprintf(stderr, "      Any \"+\" option resets the default list to empty and then adds the option(s).\n\n");
    exit(1);
}
void alarm_usage()
{
    fprintf(stderr, "\nALARMS & WARNINGS:\n");
    fprintf(stderr, "  Any one or more of the following four alarm values can be set on any graph:\n");
    fprintf(stderr, "    [-low*Alarm {value}]      ( Set low Alarm value for *) ( 0 disables )\n");
    fprintf(stderr, "    [-low*Warn {value}]       ( Set low Warning value for *) ( 0 disables )\n");
    fprintf(stderr, "    [-high*Alarm {value}]     ( Set High Alarm value for *) ( 99999 disables )\n");
    fprintf(stderr, "    [-high*Warn {value}]      ( Set High Warning value for *) (99999 disables )\n");
    fprintf(stderr, "  Where \"*\" is one of the following:\n");
    fprintf(stderr, "    [load | mem | user | sys | idle | freeswap | swapin | swapout | disk | intrpts |\n");
    fprintf(stderr, "     pagein | pageout | processes | cpuswitch |input | output | collision]\n");
    fprintf(stderr, "  For Example:\n");
    fprintf(stderr, "    [-lowmemAlarm {value}]    ( Set low Free Memory Alarm Value)\n");
    fprintf(stderr, "WARNING: It is an error condition to set both a high, and a low, limit warning or alarm.\n");
    exit(1);
}

void
update_stat(w, client_data, value)
Widget w;
XtPointer client_data, value;
{
    *(double *)value = current_values[(int)client_data];
    if ( perSec[(int)client_data] && !appData.fast ) {
	*(double *)value /= appData.interval;
    }
    return;
}

void
update_time_stat(w, client_data, value)
Widget w;
XtPointer client_data, value;
{
    time(&timeStamp);
    return;
}
/*ARGSUSED*/
void handleResize( w, unused, event, contin2disp )
Widget w;
register XEvent *event;
XtPointer unused;
Boolean *contin2disp;
{
    Dimension neww, newh;
    int i;
    char eventString[60];
    switch (event->type) {
    case Expose:
	neww=event->xexpose.width;
	newh=event->xexpose.height;
	strcpy(eventString,"expose");
	break;
    case MapNotify:
	neww=0;
	newh=0;
	strcpy(eventString,"map notify");
	break;
    case ReparentNotify:
	neww=0;
	newh=0;
	strcpy(eventString,"reparent");
	break;
    case ConfigureNotify:
	neww=event->xconfigure.width;
	newh=event->xconfigure.height;
	strcpy(eventString,"configure");
	break;

    }
    if ( neww < 250 + 10 ) {
	neww = 250 + 10;
	w->core.width = 250 + 10;
	XtResizeWindow(w);
    }
    if ( appData.debug )
	printf("Resize Request: type=%d %s, oldw=%hu, oldh=%hu, neww=%hu, newh=%hu\n",
	       (int)event->type, eventString,
	       oldWidth, oldHeight,
	       neww, newh);

    if ( event->type == ConfigureNotify ) {
/*	Dimension h = perfmon[0]->core.height;*/
	Dimension hOverHead = 5 * appData.numGraphsOn;
	Dimension boxH = labelBox->core.height;
	Dimension timeH = timechart->core.height;
	Dimension newWidgetH = (newh - (boxH+8) - (timeH+10) - hOverHead) / appData.numGraphsOn;
	if ( oldWidth == neww && oldHeight == newh ) return;

	if ( appData.debug )
	    printf("BoxH=%hu, timeH=%hu, numGraphOn=%hu, newWidgetH=%hu\n",
		   boxH, timeH, appData.numGraphsOn, newWidgetH);

	neww -= 10;			/* allow for spacing and borders */

	for ( i=0; i<NUM_GRAPHS; i++ ) {
	    if ( appData.graphOn[i] ) {
		XtResizeWidget(perfmon[i], (Dimension)neww, newWidgetH,
			       (Dimension)1);
	    }
	}
	XtResizeWidget(timechart, (Dimension)neww, timeH,
		       (Dimension)1);
	XFlush(XtDisplay(w));

    }
    oldWidth = neww+=10, oldHeight = newh;
    return;
}

main(argc, argv)
    int argc;
    char **argv;
{
    Arg arg;
    Pixmap icon_pixmap = None;
    Widget  loadParent;

    char *progname = argv[0];
    Bool foundAnAdd = FALSE;
    char hostname[132], *c;
    char iconName[132], *IconName, *I;
    int i;
    gprogname = progname;

    (void)gethostname(hostname, sizeof(hostname));
    IconName = strdup(hostname);
    I = strchr(IconName, '.');	                     /* look for first dot */
    if ( I )					     /* if we found a dot */
	*I = (int)NULL;				     /* shorten name */
    sprintf(iconName, "xperfmon++ [v%s]   for %s", XPERFVERSION, IconName);
    appData.toplevel = XtVaAppInitialize(&appData.app_context, "XPerfmon++", 
					 optionDescList, XtNumber(optionDescList), 
					 &argc, argv,
					 NULL, 
					 XtNiconName, iconName,
					 NULL);

    if (argc != 1) general_usage();

    if ( appData.toplevel->core.depth == 1 )
	mono_screen = TRUE;
    else
	mono_screen = FALSE;

    XtGetApplicationResources(appData.toplevel, &appData, resources,
                              XtNumber(resources), NULL, 0 );

    if ( appData.helpReq[HELP_GENERAL] ) general_usage();
    if ( appData.helpReq[HELP_GRAPHS] ) graph_usage();
    if ( appData.helpReq[HELP_GROUPS] ) group_usage();
    if ( appData.helpReq[HELP_ALARMS] ) alarm_usage();

/*check resources to make sure they are in range */

    if ( (int)appData.fast ) {
	short uid = getuid();
	short euid = geteuid();
	if ( appData.debug ) fprintf(stderr, "uid = %hd, euid = %hd\n", uid, euid);
	if ( uid != 0 & euid != 0 ) {
	    fprintf(stderr, "xperfmon++: ERROR: Must be root to use \"-fast\"\n");
	    exit();
	}
	appData.ms_per_sec = 1;
    }
    else
	appData.ms_per_sec = MS_PER_SEC;

    if ( appData.ms_per_sec * appData.interval < SLOWEST_INTERVAL )
	appData.interval = SLOWEST_INTERVAL;	/* slowest interval is 100 milliseconds */

    if ( appData.ms_per_sec * appData.interval < 500 )
	fprintf(stderr, "WARNING: An update interval of %5.1f secs uses LOTS of system resources.\n",
		(float)(appData.interval * appData.ms_per_sec) / 1000.0 );

/* build graphOn table */

/*SC
    if ( appData.addG[NFS_GROUP] ) 
	appData.addG[NFS_CLT] = appData.addG[NFS_SRV] = TRUE;
SC*/
    if ( appData.addG[NET_GROUP] )
	appData.addG[INP_PKT] = appData.addG[OUT_PKT] = appData.addG[COL_PKT] = TRUE;
    if ( appData.addG[SYS_GROUP] )
	appData.addG[PROCESSES] = appData.addG[CPU_SWITCH] = TRUE;
    if ( appData.addG[PAGE_GROUP] )
	appData.addG[PAGE_IN] = appData.addG[PAGE_OUT] = TRUE;
    if ( appData.addG[SWAP_GROUP] )
	appData.addG[FREE_SWAP] = appData.addG[SWAP_IN] = appData.addG[SWAP_OUT] = TRUE;
    if ( appData.addG[CPU_GROUP] )
	appData.addG[USR_CPU] = appData.addG[SYS_CPU] = appData.addG[IDL_CPU] = TRUE;

/*SC
    if ( appData.subG[NFS_GROUP] ) 
	appData.subG[NFS_CLT] = appData.subG[NFS_SRV] = TRUE;
SC*/

    if ( appData.subG[NET_GROUP] )
	appData.subG[INP_PKT] = appData.subG[OUT_PKT] = appData.subG[COL_PKT] = TRUE;
    if ( appData.subG[SYS_GROUP] )
	appData.subG[PROCESSES] = appData.subG[CPU_SWITCH] = TRUE;
    if ( appData.subG[PAGE_GROUP] )
	appData.subG[PAGE_IN] = appData.subG[PAGE_OUT] = TRUE;
    if ( appData.subG[SWAP_GROUP] )
	appData.subG[FREE_SWAP] = appData.subG[SWAP_IN] = appData.subG[SWAP_OUT] = TRUE;
    if ( appData.subG[CPU_GROUP] )
	appData.subG[USR_CPU] = appData.subG[SYS_CPU] = appData.subG[IDL_CPU] = TRUE;

    for ( i=0; i<NUM_GRAPHS; i++ ) 
	if ( appData.addG[i] ) {
	    foundAnAdd = appData.graphOn[i] = TRUE;
	    appData.numGraphsOn++;
	}
    if ( !foundAnAdd ) {
	for ( i=0; i<NUM_GRAPHS; i++ ) {
	    appData.graphOn[i] = TRUE;
	    if ( appData.subG[i] ) 
		appData.graphOn[i] = FALSE;
	    else
		appData.numGraphsOn++;
	}
    }

/* add actions */

    XtAppAddActions(appData.app_context, actionsTable, XtNumber(actionsTable));

    XtSetArg(arg, XtNiconPixmap, &icon_pixmap);
    XtGetValues(appData.toplevel, &arg, 1);
    if (icon_pixmap == None) {
	XtSetArg(arg, XtNiconPixmap,
	    XCreateBitmapFromData(XtDisplay(appData.toplevel),
		XtScreen(appData.toplevel)->root, xperfmon_bits,
		xperfmon_width, xperfmon_height));
	XtSetValues(appData.toplevel, &arg, 1);
    }

/* create windows */

    pappaBox = XtVaCreateManagedWidget("PappaBox", boxWidgetClass, appData.toplevel, 
				       XtNborderWidth, 0,
				       NULL);

    XtOverrideTranslations(pappaBox, XtParseTranslationTable(defaultTranslations));

    (void)gethostname(hostname, sizeof(hostname));
    c = (char *) ((long) &hostname[0] + (int) strlen(hostname));
    sprintf(c, "\nUpdate Interval = %5.1f secs", (float)(appData.interval*appData.ms_per_sec)/1000.0);

    labelBox = XtVaCreateManagedWidget("LabelBox", labelWidgetClass, pappaBox,
					 XtNwidth, 250,
/*					 XtNheight, 16,*/
				         XtNjustify, XtJustifyLeft,
				         XtNinternalHeight, 0,
					 XtNtop, XtChainTop,
				         XtNlabel, hostname,
				         XtNborderWidth, 0,
					 NULL);
/* build the graph widgets */

    for ( i=0; i<NUM_GRAPHS; i++ ) {
	if ( appData.graphOn[i] ) {
	    sprintf(hostname, "perfChart%s", widgetLabels[i]);
	    perfmon[i] = XtVaCreateManagedWidget(hostname, perfChartWidgetClass, pappaBox, 
						 XtNtopLabel, topNames[i],
						 XtNbotLabel, botNames[i],
						 XtNwidth, 250,
						 XtNheight, 36,
						 XtNupdate, appData.interval*appData.ms_per_sec,
						 XtNfillRect, (int)appData.fill,
						 XtNjumpScroll, 1,
						 NULL);
	}
    }
    timechart = XtVaCreateManagedWidget("timeChart", timeChartWidgetClass, pappaBox, 
					 XtNfromVert, perfmon[1], 
					 XtNwidth, 250,
					 XtNheight, 18,
					 XtNupdate, appData.interval*appData.ms_per_sec,
					 XtNjumpScroll, 1,
					 NULL);
    sys_setup();
    XtAddCallback(timechart, XtNgetValue, update_time_stat, NULL);

    for ( i=0; i<NUM_GRAPHS; i++ ) 
	if ( appData.graphOn[i] ) 
	    XtAddCallback(perfmon[i], XtNgetValue, update_stat, (XtPointer)i);

    appData.interval_id = XtAppAddTimeOut(appData.app_context,
		    appData.interval*appData.ms_per_sec, start_graphs, (caddr_t) appData.toplevel);

    XtRealizeWidget(appData.toplevel);
    XtAppMainLoop(appData.app_context);
}
