/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Menu
extends MenuItem
implements MenuContainer {
    Vector items = new Vector();
    boolean tearOff;
    boolean isHelpMenu;
    private static final String base = "menu";
    private static int nameCounter;
    private static final long serialVersionUID = -8809584163345499784L;
    private int menuSerializedDataVersion = 1;

    public Menu() {
        this("", false);
    }

    public Menu(String string) {
        this(string, false);
    }

    public Menu(String string, boolean bl) {
        super(string);
        this.name = base + nameCounter++;
        this.tearOff = bl;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = Toolkit.getDefaultToolkit().createMenu(this);
        }
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getItem(n2);
            menuItem.parent = this;
            menuItem.addNotify();
            ++n2;
        }
    }

    public void removeNotify() {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.getItem(n2).removeNotify();
            ++n2;
        }
        super.removeNotify();
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    public synchronized MenuItem add(MenuItem menuItem) {
        if (menuItem.parent != null) {
            menuItem.parent.remove(menuItem);
        }
        this.items.addElement(menuItem);
        menuItem.parent = this;
        MenuPeer menuPeer = (MenuPeer)this.peer;
        if (menuPeer != null) {
            menuItem.addNotify();
            menuPeer.addItem(menuItem);
        }
        return menuItem;
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    public synchronized void insert(MenuItem menuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n2 = this.getItemCount();
        Vector vector = new Vector();
        int n3 = n;
        while (n3 < n2) {
            vector.addElement(this.getItem(n));
            this.remove(n);
            ++n3;
        }
        this.add(menuItem);
        int n4 = 0;
        while (n4 < vector.size()) {
            this.add((MenuItem)vector.elementAt(n4));
            ++n4;
        }
    }

    public void insert(String string, int n) {
        this.insert(new MenuItem(string), n);
    }

    public void addSeparator() {
        this.add("-");
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n2 = this.getItemCount();
        Vector vector = new Vector();
        int n3 = n;
        while (n3 < n2) {
            vector.addElement(this.getItem(n));
            this.remove(n);
            ++n3;
        }
        this.addSeparator();
        int n4 = 0;
        while (n4 < vector.size()) {
            this.add((MenuItem)vector.elementAt(n4));
            ++n4;
        }
    }

    public synchronized void remove(int n) {
        MenuItem menuItem = this.getItem(n);
        this.items.removeElementAt(n);
        MenuPeer menuPeer = (MenuPeer)this.peer;
        if (menuPeer != null) {
            menuItem.removeNotify();
            menuItem.parent = null;
            menuPeer.delItem(n);
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        int n = this.items.indexOf(menuComponent);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public synchronized void removeAll() {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.remove(0);
            ++n2;
        }
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getItem(n2);
            if (menuItem.handleShortcut(keyEvent)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = this.getItem(n2).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            MenuItem menuItem = this.getItem(n2);
            if (menuItem instanceof Menu) {
                object = ((Menu)menuItem).shortcuts();
                while (object.hasMoreElements()) {
                    vector.addElement(object.nextElement());
                }
            } else {
                object = menuItem.getShortcut();
                if (object != null) {
                    vector.addElement(object);
                }
            }
            ++n2;
        }
        return vector.elements();
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.getItem(n2).deleteShortcut();
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = 0;
        while (n < this.items.size()) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(n);
            menuItem.parent = this;
            ++n;
        }
    }

    public String paramString() {
        String string = ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu;
        return String.valueOf(super.paramString()) + string;
    }
}

