/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable {
    private transient Calendar cal;
    private transient long fastTime;
    private transient boolean modified;
    private static final long serialVersionUID = 7523967970034938905L;
    private static final String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final int[] ttb;

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long l) {
        this.cal = null;
        this.fastTime = l;
        this.modified = false;
    }

    public Date(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        this.cal = new GregorianCalendar(n + 1900, n2, n3, n4, n5, n6);
        this.cal.complete();
        this.modified = false;
    }

    public Date(String string) {
        this(Date.parse(string));
    }

    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.set(1, n + 1900);
        gregorianCalendar.set(2, n2);
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    /*
     * Unable to fully structure code
     */
    public static long parse(String var0) {
        block39: {
            var1_1 = -1;
            var2_2 = -1;
            var3_3 = -1;
            var4_4 = -1;
            var5_5 = -1;
            var6_6 = -1;
            var7_7 = -1;
            var8_8 = 0;
            var9_9 = -1;
            var10_10 = -1;
            var11_11 = 0;
            if (var0 == null) break block39;
            var12_12 = var0.length();
            block0: while (var8_8 < var12_12) {
                block40: {
                    var7_7 = var0.charAt(var8_8);
                    ++var8_8;
                    if (var7_7 <= 32 || var7_7 == 44) continue;
                    if (var7_7 == 40) {
                        var13_13 = 1;
                        while (var8_8 < var12_12) {
                            var7_7 = var0.charAt(var8_8);
                            ++var8_8;
                            if (var7_7 == 40) {
                                ++var13_13;
                                continue;
                            }
                            if (var7_7 == 41 && --var13_13 <= 0) continue block0;
                        }
                        continue;
                    }
                    if (var7_7 < 48 || var7_7 > 57) break block40;
                    var9_9 = var7_7 - 48;
                    if (true) ** GOTO lbl35
                    do {
                        var9_9 = var9_9 * 10 + var7_7 - 48;
                        ++var8_8;
lbl35:
                        // 2 sources

                        if (var8_8 >= var12_12) break;
                        v0 = var0.charAt(var8_8);
                        var7_7 = v0;
                    } while (v0 >= '0' && var7_7 <= 57);
                    if (var11_11 == 43 || var11_11 == 45 && var1_1 >= 0) {
                        var9_9 = var9_9 < 24 ? (var9_9 *= 60) : var9_9 % 100 + var9_9 / 100 * 60;
                        if (var11_11 == 43) {
                            var9_9 = -var9_9;
                        }
                        if (var10_10 != 0 && var10_10 != -1) break block39;
                        var10_10 = var9_9;
                    } else if (var9_9 >= 70) {
                        if (var1_1 >= 0 || var7_7 > 32 && var7_7 != 44 && var7_7 != 47 && var8_8 < var12_12) break block39;
                        var1_1 = var9_9 < 1900 ? var9_9 : var9_9 - 1900;
                    } else if (var7_7 == 58) {
                        if (var4_4 < 0) {
                            var4_4 = (byte)var9_9;
                        } else {
                            if (var5_5 >= 0) break block39;
                            var5_5 = (byte)var9_9;
                        }
                    } else if (var7_7 == 47) {
                        if (var2_2 < 0) {
                            var2_2 = (byte)(var9_9 - 1);
                        } else {
                            if (var3_3 >= 0) break block39;
                            var3_3 = (byte)var9_9;
                        }
                    } else {
                        if (var8_8 < var12_12 && var7_7 != 44 && var7_7 > 32 && var7_7 != 45) break block39;
                        if (var4_4 >= 0 && var5_5 < 0) {
                            var5_5 = (byte)var9_9;
                        } else if (var5_5 >= 0 && var6_6 < 0) {
                            var6_6 = (byte)var9_9;
                        } else {
                            if (var3_3 >= 0) break block39;
                            var3_3 = (byte)var9_9;
                        }
                    }
                    var11_11 = 0;
                    continue;
                }
                if (var7_7 == 47 || var7_7 == 58 || var7_7 == 43 || var7_7 == 45) {
                    var11_11 = var7_7;
                    continue;
                }
                var13_13 = var8_8 - 1;
                while (var8_8 < var12_12) {
                    var7_7 = var0.charAt(var8_8);
                    if ((var7_7 < 65 || var7_7 > 90) && (var7_7 < 97 || var7_7 > 122)) break;
                    ++var8_8;
                }
                if (var8_8 <= var13_13 + 1) break block39;
                var14_14 = Date.wtb.length;
                while (--var14_14 >= 0) {
                    if (!Date.wtb[var14_14].regionMatches(true, 0, var0, var13_13, var8_8 - var13_13)) continue;
                    var15_15 = Date.ttb[var14_14];
                    if (var15_15 == 0) break;
                    if (var15_15 == 1) {
                        if (var4_4 <= 12 && var4_4 >= 1) {
                            if (var4_4 >= 12) break;
                            var4_4 += 12;
                            break;
                        }
                        break block39;
                    }
                    if (var15_15 == 14) {
                        if (var4_4 <= 12 && var4_4 >= 1) {
                            if (var4_4 != 12) break;
                            var4_4 = 0;
                            break;
                        }
                        break block39;
                    }
                    if (var15_15 <= 13) {
                        if (var2_2 < 0) {
                            var2_2 = (byte)(var15_15 - 2);
                            break;
                        }
                        break block39;
                    }
                    var10_10 = var15_15 - 10000;
                    break;
                }
                if (var14_14 >= 0) {
                    var11_11 = 0;
                    continue;
                }
                break block39;
            }
            if (var1_1 >= 0 && var2_2 >= 0 && var3_3 >= 0) {
                if (var6_6 < 0) {
                    var6_6 = 0;
                }
                if (var5_5 < 0) {
                    var5_5 = 0;
                }
                if (var4_4 < 0) {
                    var4_4 = 0;
                }
                if (var10_10 == -1) {
                    return new Date(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6).getTime();
                }
                return Date.UTC(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6) + (long)(var10_10 * 60000);
            }
        }
        throw new IllegalArgumentException();
    }

    public int getYear() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        Calendar calendar = this.cal;
        calendar.complete();
        return calendar.fields[1] - 1900;
    }

    public void setYear(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(1, n + 1900);
        this.modified = true;
    }

    public int getMonth() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        Calendar calendar = this.cal;
        calendar.complete();
        return calendar.fields[2];
    }

    public void setMonth(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(2, n);
        this.modified = true;
    }

    public int getDate() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        Calendar calendar = this.cal;
        calendar.complete();
        return calendar.fields[5];
    }

    public void setDate(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(5, n);
        this.modified = true;
    }

    public int getDay() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        Calendar calendar = this.cal;
        calendar.complete();
        return calendar.fields[7] - 1;
    }

    public int getHours() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        Calendar calendar = this.cal;
        calendar.complete();
        return calendar.fields[11];
    }

    public void setHours(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(11, n);
        this.modified = true;
    }

    public int getMinutes() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        Calendar calendar = this.cal;
        calendar.complete();
        return calendar.fields[12];
    }

    public void setMinutes(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(12, n);
        this.modified = true;
    }

    public int getSeconds() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        Calendar calendar = this.cal;
        calendar.complete();
        return calendar.fields[13];
    }

    public void setSeconds(int n) {
        this.checkCal();
        this.cal.clear(16);
        this.cal.clear(15);
        this.cal.set(13, n);
        this.modified = true;
    }

    public long getTime() {
        if (this.cal == null) {
            return this.fastTime;
        }
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        return this.cal.getTimeInMillis();
    }

    public void setTime(long l) {
        if (this.cal == null) {
            this.fastTime = l;
            this.modified = false;
            return;
        }
        this.cal.setTimeInMillis(l);
        this.cal.computeFields();
        this.modified = false;
    }

    public boolean before(Date date) {
        return this.getTime() < date.getTime();
    }

    public boolean after(Date date) {
        return this.getTime() > date.getTime();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    public int hashCode() {
        long l = this.getTime();
        return (int)l ^ (int)(l >> 32);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        StringBuffer stringBuffer = ((DateFormat)simpleDateFormat).format(this, new StringBuffer(), new FieldPosition(0));
        return new String(stringBuffer);
    }

    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        StringBuffer stringBuffer = dateFormat.format(this, new StringBuffer(), new FieldPosition(0));
        return new String(stringBuffer);
    }

    public String toGMTString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuffer stringBuffer = ((DateFormat)simpleDateFormat).format(this, new StringBuffer(), new FieldPosition(0));
        return new String(stringBuffer);
    }

    public int getTimezoneOffset() {
        this.checkCal();
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
        TimeZone timeZone = this.cal.getTimeZone();
        Calendar calendar = this.cal;
        calendar.complete();
        int n = calendar.fields[0];
        calendar = this.cal;
        calendar.complete();
        int n2 = calendar.fields[1];
        calendar = this.cal;
        calendar.complete();
        int n3 = calendar.fields[2];
        calendar = this.cal;
        calendar.complete();
        int n4 = calendar.fields[5];
        calendar = this.cal;
        calendar.complete();
        int n5 = calendar.fields[7];
        calendar = this.cal;
        calendar.complete();
        int n6 = calendar.fields[11];
        calendar = this.cal;
        calendar.complete();
        int n7 = n6 * calendar.fields[12];
        calendar = this.cal;
        calendar.complete();
        int n8 = timeZone.getOffset(n, n2, n3, n4, n5, n7 * calendar.fields[13] * 1000);
        return -(n8 / 1000 / 60);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTime());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        long l = objectInputStream.readLong();
        this.cal = new GregorianCalendar(TimeZone.getDefault());
        this.cal.setTimeInMillis(l);
        this.cal.computeFields();
        this.modified = false;
    }

    private void checkCal() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar(TimeZone.getDefault());
            this.cal.setTimeInMillis(this.fastTime);
            this.cal.computeFields();
            this.modified = false;
        }
    }

    private void checkModified() {
        if (this.modified) {
            this.cal.complete();
            this.modified = false;
        }
    }

    static {
        int[] nArray = new int[32];
        nArray[0] = 14;
        nArray[1] = 1;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 4;
        nArray[12] = 5;
        nArray[13] = 6;
        nArray[14] = 7;
        nArray[15] = 8;
        nArray[16] = 9;
        nArray[17] = 10;
        nArray[18] = 11;
        nArray[19] = 12;
        nArray[20] = 13;
        nArray[21] = 10000;
        nArray[22] = 10000;
        nArray[23] = 10000;
        nArray[24] = 10300;
        nArray[25] = 10240;
        nArray[26] = 10360;
        nArray[27] = 10300;
        nArray[28] = 10420;
        nArray[29] = 10360;
        nArray[30] = 10480;
        nArray[31] = 10420;
        ttb = nArray;
    }
}

