/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.ByteToCharDefault;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class ByteToCharJISAutoDetect
extends ByteToCharConverter {
    private String convName;
    private ByteToCharConverter detectedConv;
    private ByteToCharConverter defaultConv;

    public ByteToCharJISAutoDetect() {
        try {
            this.defaultConv = ByteToCharConverter.getConverter((String)"8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.defaultConv = new ByteToCharDefault();
        }
        this.defaultConv.subChars = this.subChars;
        this.defaultConv.subMode = this.subMode;
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        this.badInputLength = 0;
        if (this.detectedConv != null) {
            return this.detectedConv.flush(cArray, n, n2);
        }
        return this.defaultConv.flush(cArray, n, n2);
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5;
        int n6 = n;
        int n7 = n + n2;
        String string = null;
        ByteToCharConverter byteToCharConverter = null;
        try {
            if (this.detectedConv == null) {
                int n8 = n6;
                while (n8 < n7) {
                    int n9 = byArray[n8] & 0xFF;
                    if (n9 == 27) {
                        this.convName = "JIS";
                        break;
                    }
                    if (n9 >= 129 && n9 <= 159) {
                        this.convName = "SJIS";
                        break;
                    }
                    if (n9 >= 161 && n9 <= 223 || n9 >= 253 && n9 <= 254) {
                        this.convName = "EUCJIS";
                        break;
                    }
                    if (n9 >= 224 && n9 <= 234) {
                        if (n8 + 1 < n7) {
                            if ((n9 = byArray[++n8] & 0xFF) >= 64 && n9 <= 126) {
                                this.convName = "SJIS";
                                break;
                            }
                            if (string != null) break;
                            string = "SJIS";
                            break;
                        }
                        throw new MalformedInputException();
                    }
                    if (n9 >= 235 && n9 <= 252) {
                        if (n8 + 1 < n7) {
                            if ((n9 = byArray[++n8] & 0xFF) >= 64 && n9 <= 126) {
                                this.convName = "SJIS";
                                break;
                            }
                            if (string != null) break;
                            string = "EUCJIS";
                            break;
                        }
                        throw new MalformedInputException();
                    }
                    ++n8;
                }
                if (this.convName != null) {
                    try {
                        this.detectedConv = ByteToCharConverter.getConverter((String)this.convName);
                        this.detectedConv.subChars = this.subChars;
                        this.detectedConv.subMode = this.subMode;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.detectedConv = null;
                        this.convName = null;
                    }
                } else if (string != null) {
                    try {
                        byteToCharConverter = ByteToCharConverter.getConverter(string);
                        byteToCharConverter.subChars = this.subChars;
                        byteToCharConverter.subMode = this.subMode;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        byteToCharConverter = null;
                        string = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.detectedConv = this.defaultConv;
        }
        if (this.detectedConv != null) {
            try {
                n5 = this.detectedConv.convert(byArray, n, n2, cArray, n3, n4);
                this.charOff = this.detectedConv.nextCharIndex();
                this.byteOff = this.detectedConv.nextByteIndex();
                this.badInputLength = this.detectedConv.badInputLength;
            }
            catch (UnknownCharacterException unknownCharacterException) {
                this.charOff = this.detectedConv.nextCharIndex();
                this.byteOff = this.detectedConv.nextByteIndex();
                this.badInputLength = this.detectedConv.badInputLength;
                throw unknownCharacterException;
            }
            catch (MalformedInputException malformedInputException) {
                this.charOff = this.detectedConv.nextCharIndex();
                this.byteOff = this.detectedConv.nextByteIndex();
                this.badInputLength = this.detectedConv.badInputLength;
                throw malformedInputException;
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                this.charOff = this.detectedConv.nextCharIndex();
                this.byteOff = this.detectedConv.nextByteIndex();
                this.badInputLength = this.detectedConv.badInputLength;
                throw conversionBufferFullException;
            }
        }
        if (byteToCharConverter != null) {
            try {
                n5 = byteToCharConverter.convert(byArray, n, n2, cArray, n3, n4);
                this.charOff = byteToCharConverter.nextCharIndex();
                this.byteOff = byteToCharConverter.nextByteIndex();
                this.badInputLength = byteToCharConverter.badInputLength;
            }
            catch (UnknownCharacterException unknownCharacterException) {
                this.charOff = byteToCharConverter.nextCharIndex();
                this.byteOff = byteToCharConverter.nextByteIndex();
                this.badInputLength = byteToCharConverter.badInputLength;
                throw unknownCharacterException;
            }
            catch (MalformedInputException malformedInputException) {
                this.charOff = byteToCharConverter.nextCharIndex();
                this.byteOff = byteToCharConverter.nextByteIndex();
                this.badInputLength = byteToCharConverter.badInputLength;
                throw malformedInputException;
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                this.charOff = byteToCharConverter.nextCharIndex();
                this.byteOff = byteToCharConverter.nextByteIndex();
                this.badInputLength = byteToCharConverter.badInputLength;
                throw conversionBufferFullException;
            }
        }
        try {
            n5 = this.defaultConv.convert(byArray, n, n2, cArray, n3, n4);
            this.charOff = this.defaultConv.nextCharIndex();
            this.byteOff = this.defaultConv.nextByteIndex();
            this.badInputLength = this.defaultConv.badInputLength;
        }
        catch (UnknownCharacterException unknownCharacterException) {
            this.charOff = this.defaultConv.nextCharIndex();
            this.byteOff = this.defaultConv.nextByteIndex();
            this.badInputLength = this.defaultConv.badInputLength;
            throw unknownCharacterException;
        }
        catch (MalformedInputException malformedInputException) {
            this.charOff = this.defaultConv.nextCharIndex();
            this.byteOff = this.defaultConv.nextByteIndex();
            this.badInputLength = this.defaultConv.badInputLength;
            throw malformedInputException;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            this.charOff = this.defaultConv.nextCharIndex();
            this.byteOff = this.defaultConv.nextByteIndex();
            this.badInputLength = this.defaultConv.badInputLength;
            throw conversionBufferFullException;
        }
        return n5;
    }

    public void reset() {
        if (this.detectedConv != null) {
            this.detectedConv.reset();
            this.detectedConv = null;
            this.convName = null;
            return;
        }
        this.defaultConv.reset();
    }

    public String getCharacterEncoding() {
        return "JISAutoDetect";
    }
}

