/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Stack;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private boolean blockDataMode;
    private byte[] buf;
    private int count;
    private OutputStream out;
    private DataOutputStream dos;
    private IOException abortIOException;
    private Object[] wireHandle2Object;
    private int[] wireNextHandle;
    private int[] wireHash2Handle;
    private int nextWireOffset;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Stack classDescStack;
    private boolean enableReplace;
    private Object[] replaceObjects;
    private int nextReplaceOffset;
    private int recursionDepth;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.out = outputStream;
        this.dos = new DataOutputStream(this);
        this.buf = new byte[1024];
        this.writeStreamHeader();
        this.resetStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeObject(Object object) throws IOException {
        boolean bl;
        ObjectStreamClass objectStreamClass;
        Object object2;
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            boolean bl2;
                            object2 = this.currentObject;
                            objectStreamClass = this.currentClassDesc;
                            if (!this.blockDataMode) {
                                bl2 = false;
                            } else {
                                this.drain();
                                this.blockDataMode = false;
                                bl2 = true;
                            }
                            bl = bl2;
                            ++this.recursionDepth;
                            try {
                                try {
                                    Object object3;
                                    if (this.serializeNullAndRepeat(object)) {
                                        Object var6_5 = null;
                                        --this.recursionDepth;
                                        this.currentObject = object2;
                                        this.currentClassDesc = objectStreamClass;
                                        if (this.blockDataMode == bl) {
                                            return;
                                        }
                                        break block27;
                                    }
                                    if (this.checkSpecialClasses(object)) {
                                        break block28;
                                    }
                                    if (this.enableReplace && object != (object3 = this.replaceObject(object))) {
                                        if (object3 != null && !(object3 instanceof Serializable)) {
                                            String string = object3.getClass().getName();
                                            throw new NotSerializableException(string);
                                        }
                                        if (this.serializeNullAndRepeat(object3)) {
                                            this.addReplacement(object, object3);
                                            break block29;
                                        }
                                        this.addReplacement(object, object3);
                                        if (this.checkSpecialClasses(object3)) {
                                            break block30;
                                        }
                                        object = object3;
                                    }
                                    this.outputObject(object);
                                }
                                catch (ObjectStreamException objectStreamException) {
                                    if (this.abortIOException == null) {
                                        try {
                                            if (this.blockDataMode) {
                                                this.drain();
                                                this.blockDataMode = false;
                                            }
                                            this.writeByte(123);
                                            this.resetStream();
                                            this.writeObject(objectStreamException);
                                            this.resetStream();
                                            this.abortIOException = objectStreamException;
                                        }
                                        catch (IOException iOException) {
                                            this.abortIOException = new StreamCorruptedException(iOException.getMessage());
                                        }
                                    }
                                    break block31;
                                }
                                catch (IOException iOException) {
                                    if (this.abortIOException == null) {
                                        this.abortIOException = iOException;
                                    }
                                    break block31;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                --this.recursionDepth;
                                this.currentObject = object2;
                                this.currentClassDesc = objectStreamClass;
                                if (this.blockDataMode == bl) throw throwable;
                                this.drain();
                                this.blockDataMode = bl;
                                throw throwable;
                            }
                        }
                        this.drain();
                        this.blockDataMode = bl;
                        return;
                    }
                    Object var6_6 = null;
                    --this.recursionDepth;
                    this.currentObject = object2;
                    this.currentClassDesc = objectStreamClass;
                    if (this.blockDataMode == bl) return;
                    this.drain();
                    this.blockDataMode = bl;
                    return;
                }
                Object var6_7 = null;
                --this.recursionDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
                if (this.blockDataMode == bl) return;
                this.drain();
                this.blockDataMode = bl;
                return;
            }
            Object var6_8 = null;
            --this.recursionDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
            if (this.blockDataMode == bl) return;
            this.drain();
            this.blockDataMode = bl;
            return;
        }
        Object var6_9 = null;
        --this.recursionDepth;
        this.currentObject = object2;
        this.currentClassDesc = objectStreamClass;
        if (this.blockDataMode != bl) {
            this.drain();
            this.blockDataMode = bl;
        }
        IOException iOException = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException == null) return;
        throw iOException;
    }

    private boolean checkSpecialClasses(Object object) throws IOException {
        if (object instanceof Class) {
            this.outputClass((Class)object);
            return true;
        }
        if (object instanceof ObjectStreamClass) {
            this.outputClassDescriptor((ObjectStreamClass)object);
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            this.assignWireOffset(string);
            this.writeByte(116);
            this.writeUTF(string);
            return true;
        }
        if (object.getClass().isArray()) {
            this.outputArray(object);
            return true;
        }
        return false;
    }

    public final void defaultWriteObject() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultWriteObject");
        }
        if (this.currentClassDesc.getFieldSequence() != null) {
            boolean bl;
            if (!this.blockDataMode) {
                bl = false;
            } else {
                this.drain();
                this.blockDataMode = false;
                bl = true;
            }
            boolean bl2 = bl;
            this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), this.currentClassDesc.getFieldSequence());
            if (this.blockDataMode != bl2) {
                this.drain();
                this.blockDataMode = bl2;
                return;
            }
        }
    }

    public void reset() throws IOException {
        if (this.currentObject != null || this.currentClassDesc != null) {
            throw new IOException("Illegal call to reset");
        }
        if (this.blockDataMode) {
            this.drain();
            this.blockDataMode = false;
        }
        this.writeByte(121);
        this.resetStream();
        this.abortIOException = null;
    }

    private void resetStream() throws IOException {
        this.wireHandle2Object = new Object[100];
        this.wireNextHandle = new int[100];
        this.wireHash2Handle = new int[101];
        int n = 0;
        while (n < this.wireHash2Handle.length) {
            this.wireHash2Handle[n] = -1;
            ++n;
        }
        this.classDescStack = new Stack();
        this.nextWireOffset = 0;
        this.replaceObjects = null;
        this.nextReplaceOffset = 0;
        if (!this.blockDataMode) {
            this.drain();
            this.blockDataMode = true;
        }
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected final boolean enableReplaceObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableReplace;
        if (bl) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader == null) {
                this.enableReplace = true;
                return bl2;
            }
            throw new SecurityException("Not trusted class");
        }
        this.enableReplace = false;
        return bl2;
    }

    protected void writeStreamHeader() throws IOException {
        this.writeShort(-21267);
        this.writeShort(5);
    }

    private void outputString(String string) throws IOException {
        this.assignWireOffset(string);
        this.writeByte(116);
        this.writeUTF(string);
    }

    private void outputClass(Class clazz) throws IOException {
        this.writeByte(118);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass == null) {
            throw new NotSerializableException(clazz.getName());
        }
        this.outputClassDescriptor(objectStreamClass);
        this.assignWireOffset(clazz);
    }

    private void outputClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        boolean bl;
        if (this.serializeNullAndRepeat(objectStreamClass)) {
            return;
        }
        this.writeByte(114);
        String string = objectStreamClass.getName();
        this.writeUTF(string);
        this.writeLong(objectStreamClass.getSerialVersionUID());
        this.assignWireOffset(objectStreamClass);
        objectStreamClass.write(this);
        if (this.blockDataMode) {
            bl = true;
        } else {
            this.drain();
            this.blockDataMode = true;
            bl = false;
        }
        boolean bl2 = bl;
        this.annotateClass(objectStreamClass.forClass());
        if (this.blockDataMode != bl2) {
            this.drain();
            this.blockDataMode = bl2;
        }
        this.writeByte(120);
        ObjectStreamClass objectStreamClass2 = objectStreamClass.getSuperclass();
        this.outputClassDescriptor(objectStreamClass2);
    }

    private void outputArray(Object object) throws IOException {
        Class clazz = object.getClass();
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        this.writeByte(117);
        this.outputClassDescriptor(objectStreamClass);
        this.assignWireOffset(object);
        Class clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])object;
                int n = nArray.length;
                this.writeInt(n);
                int n2 = 0;
                while (n2 < n) {
                    this.writeInt(nArray[n2]);
                    ++n2;
                }
                return;
            }
            if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                int n = byArray.length;
                this.writeInt(n);
                this.write(byArray, 0, n);
                return;
            }
            if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])object;
                int n = lArray.length;
                this.writeInt(n);
                int n3 = 0;
                while (n3 < n) {
                    this.writeLong(lArray[n3]);
                    ++n3;
                }
                return;
            }
            if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])object;
                int n = fArray.length;
                this.writeInt(n);
                int n4 = 0;
                while (n4 < n) {
                    this.writeFloat(fArray[n4]);
                    ++n4;
                }
                return;
            }
            if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                int n = dArray.length;
                this.writeInt(n);
                int n5 = 0;
                while (n5 < n) {
                    this.writeDouble(dArray[n5]);
                    ++n5;
                }
                return;
            }
            if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])object;
                int n = sArray.length;
                this.writeInt(n);
                int n6 = 0;
                while (n6 < n) {
                    this.writeShort(sArray[n6]);
                    ++n6;
                }
                return;
            }
            if (clazz2 == Character.TYPE) {
                char[] cArray = (char[])object;
                int n = cArray.length;
                this.writeInt(n);
                int n7 = 0;
                while (n7 < n) {
                    this.writeChar(cArray[n7]);
                    ++n7;
                }
                return;
            }
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                int n = blArray.length;
                this.writeInt(n);
                int n8 = 0;
                while (n8 < n) {
                    this.writeBoolean(blArray[n8]);
                    ++n8;
                }
                return;
            }
            throw new InvalidClassException(clazz.getName());
        }
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        this.writeInt(n);
        int n9 = 0;
        while (n9 < n) {
            this.writeObject(objectArray[n9]);
            ++n9;
        }
    }

    private void outputObject(Object object) throws IOException {
        this.currentObject = object;
        Class clazz = object.getClass();
        this.currentClassDesc = ObjectStreamClass.lookup(clazz);
        if (this.currentClassDesc == null) {
            throw new NotSerializableException(clazz.getName());
        }
        this.writeByte(115);
        this.outputClassDescriptor(this.currentClassDesc);
        this.assignWireOffset(object);
        if (this.currentClassDesc.isExternalizable()) {
            Externalizable externalizable = (Externalizable)object;
            externalizable.writeExternal(this);
            return;
        }
        int n = this.classDescStack.size();
        try {
            ObjectStreamClass objectStreamClass;
            while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                this.classDescStack.push(this.currentClassDesc);
                this.currentClassDesc = objectStreamClass;
            }
            do {
                if (this.currentClassDesc.hasWriteObject()) {
                    if (!this.blockDataMode) {
                        this.drain();
                        this.blockDataMode = true;
                    }
                    this.invokeObjectWriter(object, this.currentClassDesc.forClass());
                    if (this.blockDataMode) {
                        this.drain();
                        this.blockDataMode = false;
                    }
                    this.writeByte(120);
                } else {
                    this.defaultWriteObject();
                }
                if (this.classDescStack.size() <= n) break;
            } while ((this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.classDescStack.setSize(n);
            throw throwable;
        }
        Object var5_6 = null;
        this.classDescStack.setSize(n);
    }

    private boolean serializeNullAndRepeat(Object object) throws IOException {
        int n;
        if (object == null) {
            this.writeByte(112);
            return true;
        }
        if (this.replaceObjects != null) {
            n = 0;
            while (n < this.nextReplaceOffset) {
                if (this.replaceObjects[n] == object) {
                    object = this.replaceObjects[n + 1];
                    break;
                }
                n += 2;
            }
        }
        if ((n = this.findWireOffset(object)) >= 0) {
            this.writeByte(113);
            this.writeInt(n + 0x7E0000);
            return true;
        }
        return false;
    }

    private int findWireOffset(Object object) {
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        int n3 = this.wireHash2Handle[n2];
        while (n3 >= 0) {
            if (this.wireHandle2Object[n3] == object) {
                return n3;
            }
            n3 = this.wireNextHandle[n3];
        }
        return -1;
    }

    private void assignWireOffset(Object object) throws IOException {
        if (this.nextWireOffset == this.wireHandle2Object.length) {
            Object[] objectArray = this.wireHandle2Object;
            this.wireHandle2Object = new Object[this.nextWireOffset * 2];
            System.arraycopy(objectArray, 0, this.wireHandle2Object, 0, this.nextWireOffset);
            int[] nArray = this.wireNextHandle;
            this.wireNextHandle = new int[this.nextWireOffset * 2];
            System.arraycopy(nArray, 0, this.wireNextHandle, 0, this.nextWireOffset);
        }
        this.wireHandle2Object[this.nextWireOffset] = object;
        this.hashInsert(object, this.nextWireOffset);
        ++this.nextWireOffset;
    }

    private void hashInsert(Object object, int n) {
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        this.wireNextHandle[n] = this.wireHash2Handle[n3];
        this.wireHash2Handle[n3] = n;
    }

    private void addReplacement(Object object, Object object2) {
        if (this.replaceObjects == null) {
            this.replaceObjects = new Object[10];
        }
        if (this.nextReplaceOffset == this.replaceObjects.length) {
            Object[] objectArray = this.replaceObjects;
            this.replaceObjects = new Object[2 + this.nextReplaceOffset * 2];
            System.arraycopy(objectArray, 0, this.replaceObjects, 0, this.nextReplaceOffset);
        }
        this.replaceObjects[this.nextReplaceOffset++] = object;
        this.replaceObjects[this.nextReplaceOffset++] = object2;
    }

    private void writeCode(int n) throws IOException {
        this.writeByte(n);
    }

    public void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.buf.length - this.count;
        if (n2 <= n3) {
            System.arraycopy(byArray, n, this.buf, this.count, n2);
            this.count += n2;
            return;
        }
        this.drain();
        if (this.blockDataMode) {
            if (n2 <= 255) {
                this.out.write(119);
                this.out.write(n2);
            } else {
                this.out.write(122);
                this.out.write(n2 >> 24 & 0xFF);
                this.out.write(n2 >> 16 & 0xFF);
                this.out.write(n2 >> 8 & 0xFF);
                this.out.write(n2 & 0xFF);
            }
        }
        this.out.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    protected void drain() throws IOException {
        if (this.count == 0) {
            return;
        }
        if (this.blockDataMode) {
            if (this.count <= 255) {
                this.out.write(119);
                this.out.write(this.count);
            } else {
                this.out.write(122);
                this.out.write(this.count >> 24 & 0xFF);
                this.out.write(this.count >> 16 & 0xFF);
                this.out.write(this.count >> 8 & 0xFF);
                this.out.write(this.count & 0xFF);
            }
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private boolean setBlockData(boolean bl) throws IOException {
        if (this.blockDataMode == bl) {
            return bl;
        }
        this.drain();
        this.blockDataMode = bl;
        return !bl;
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void writeShort(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeChar(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeInt(int n) throws IOException {
        if (this.count + 4 > this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeLong(long l) throws IOException {
        if (this.count + 8 > this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        if (this.count + 4 > this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        if (this.count + 8 > this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    public void writeBytes(String string) throws IOException {
        this.dos.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.dos.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        this.dos.writeUTF(string);
    }

    private native void outputClassFields(Object var1, Class var2, int[] var3) throws IOException, InvalidClassException;

    private native boolean invokeObjectWriter(Object var1, Class var2) throws IOException;
}

