/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class Locale
implements Cloneable,
Serializable {
    public static final Locale ENGLISH = new Locale("en", "", "");
    public static final Locale FRENCH = new Locale("fr", "", "");
    public static final Locale GERMAN = new Locale("de", "", "");
    public static final Locale ITALIAN = new Locale("it", "", "");
    public static final Locale JAPANESE = new Locale("ja", "", "");
    public static final Locale KOREAN = new Locale("ko", "", "");
    public static final Locale CHINESE = new Locale("zh", "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN", "");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW", "");
    public static final Locale FRANCE = new Locale("fr", "FR", "");
    public static final Locale GERMANY = new Locale("de", "DE", "");
    public static final Locale ITALY = new Locale("it", "IT", "");
    public static final Locale JAPAN = new Locale("ja", "JP", "");
    public static final Locale KOREA = new Locale("ko", "KR", "");
    public static final Locale CHINA = new Locale("zh", "CN", "");
    public static final Locale PRC = new Locale("zh", "CN", "");
    public static final Locale TAIWAN = new Locale("zh", "TW", "");
    public static final Locale UK = new Locale("en", "GB", "");
    public static final Locale US = new Locale("en", "US", "");
    public static final Locale CANADA = new Locale("en", "CA", "");
    public static final Locale CANADA_FRENCH = new Locale("fr", "CA", "");
    private String language = "";
    private String country = "";
    private String variant = "";
    private int hashcode = -1;
    private static Locale defaultLocale = null;

    public Locale(String string, String string2, String string3) {
        this.language = this.toLowerCase(string);
        this.country = this.toUpperCase(string2);
        this.variant = this.toUpperCase(string3);
    }

    public Locale(String string, String string2) {
        this.language = this.toLowerCase(string);
        this.country = this.toUpperCase(string2);
        this.variant = "";
    }

    public static synchronized Locale getDefault() {
        if (defaultLocale == null) {
            String string = System.getProperty("user.language", "EN");
            String string2 = System.getProperty("user.region", "");
            defaultLocale = new Locale(string, string2);
        }
        return defaultLocale;
    }

    public static synchronized void setDefault(Locale locale) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.language");
        }
        defaultLocale = locale;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.language);
        if (this.country.length() != 0) {
            stringBuffer.append('_');
            stringBuffer.append(this.country);
            if (this.variant.length() != 0) {
                stringBuffer.append('_');
                stringBuffer.append(this.variant);
            }
        }
        return new String(stringBuffer);
    }

    public String getISO3Language() throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        return (String)resourceBundle.getObject("ShortLanguage");
    }

    public String getISO3Country() throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        return (String)resourceBundle.getObject("ShortCountry");
    }

    private int getLCID() throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
        String string = (String)resourceBundle.getObject("LocaleID");
        return Integer.parseInt(string, 16);
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
            return this.findStringMatch((String[][])resourceBundle.getObject("Languages"), locale.language, this.language);
        }
        catch (Exception exception) {
            return this.language;
        }
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", this);
            return this.findStringMatch((String[][])resourceBundle.getObject("Countries"), locale.language, this.language);
        }
        catch (Exception exception) {
            return this.country;
        }
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            String[][] stringArray = (String[][])resourceBundle.getObject("Variants");
            if (stringArray == null) {
                return this.variant;
            }
            return this.findStringMatch(stringArray, locale.language, this.language);
        }
        catch (Exception exception) {
            return this.variant;
        }
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer(this.getDisplayLanguage(locale));
        String string = this.getDisplayCountry(locale);
        String string2 = this.getDisplayVariant(locale);
        if (string.length() != 0 || string2.length() != 0) {
            stringBuffer.append(" (");
            stringBuffer.append(this.getDisplayCountry(locale));
            if (string.length() != 0 && string2.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.getDisplayVariant(locale));
            stringBuffer.append(")");
        }
        return new String(stringBuffer);
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = this.language.hashCode() ^ this.country.hashCode() ^ this.variant.hashCode();
        }
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        Locale locale = (Locale)object;
        if (this.hashCode() != locale.hashCode()) {
            return false;
        }
        if (!this.language.equals(locale.language)) {
            return false;
        }
        if (!this.country.equals(locale.country)) {
            return false;
        }
        return this.variant.equals(locale.variant);
    }

    private String toLowerCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toLowerCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private String toUpperCase(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = Character.toUpperCase(cArray[n]);
            ++n;
        }
        return new String(cArray);
    }

    private String findStringMatch(String[][] stringArray, String string, String string2) {
        int n;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2][0])) {
                return stringArray[n2][1];
            }
            ++n2;
        }
        if (!string2.equals(string)) {
            n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        if (!"EN".equals(string) && "EN".equals(string2)) {
            n = 0;
            while (n < stringArray.length) {
                if ("EN".equals(stringArray[n][0])) {
                    return stringArray[n][1];
                }
                ++n;
            }
        }
        return "";
    }

    private boolean matches(Locale locale) {
        if (this.language.length() != 0 && !this.language.equals(locale.language)) {
            return false;
        }
        if (this.country.length() != 0 && !this.country.equals(locale.country)) {
            return false;
        }
        return this.variant.length() == 0 || this.variant.equals(locale.variant);
    }
}

