﻿package LWP::UserAgent::Anonymous::Proxy;

use strict; use warnings;

use Carp;
use Exporter;
use Data::Dumper;

our @ISA    = 'Exporter';
our @EXPORT = qw( $DEFAULT );

=head1 NAME

LWP::UserAgent::Anonymous::Proxy - A pool of anonymous proxies compiled from various online sources.

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

Storage class of anonymous proxies.

=cut

# A pool of 2329 anonymous proxies available by default.
our $DEFAULT =
[
    # http://www.multiproxy.org/txt_anon/proxy.txt (703)
    '116.225.151.192:8088'  , '123.6.19.97:8088'     , '173.45.229.206:9090'  , '189.122.171.234:6588'   , '189.3.176.130:6588'   ,
    '189.55.174.28:6588'    , '195.135.236.204:3128' , '200.109.72.53:6588'   , '200.168.152.152:6588'   , '200.171.175.157:6588' ,
    '200.252.201.144:80'    , '201.1.63.111:6588'    , '201.15.218.158:6588'  , '201.17.163.70:6588'     , '201.17.188.5:6588'    ,
    '201.24.125.218:6588'   , '201.252.211.201:6588' , '201.26.8.186:6588'    , '201.74.205.134:6588'    , '201.93.128.110:6588'  ,
    '208.98.17.40:4589'     , '213.158.112.202:8080' , '24.23.29.41:8080'     , '59.94.38.39:6588'       , '59.94.41.39:6588'     ,
    '59.95.205.216:6588'    , '61.54.82.130:808'     , '62.193.246.10:6654'   , '65.75.189.33:9090'      , '68.207.186.253:9090'  ,
    '68.81.191.233:9090'    , '70.176.119.94:9090'   , '82.239.187.75:21570'  , '91.188.161.235:3128'    , '91.203.136.191:80'    ,
    '97.91.188.113:9090'    , '119.115.52.109:8088'  , '121.8.98.90:8888'     , '123.131.44.66:8088'     , '124.193.97.60:3128'   ,
    '128.208.4.197:3124'    , '128.208.4.199:3124'   , '146.57.249.98:3128'   , '160.7.251.98:9090'      , '189.23.208.37:6588'   ,
    '189.47.137.189:6588'   , '189.55.219.176:6588'  , '189.55.219.252:6588'  , '189.60.224.13:6588'     , '190.128.30.14:6588'   ,
    '190.53.89.103:6588'    , '200.101.13.202:6588'  , '200.102.191.228:6588' , '200.104.104.91:6588'    , '200.112.70.53:6588'   ,
    '200.112.84.5:6588'     , '200.120.224.207:6588' , '200.158.26.223:6588'  , '200.159.216.247:6588'   , '200.161.31.11:6588'   ,
    '200.171.17.23:6588'    , '200.171.232.140:6588' , '201.10.42.166:6588'   , '201.12.116.112:6588'    , '201.15.143.25:6588'   ,
    '201.15.30.1:6588'      , '201.229.208.3:80'     , '201.246.116.96:6588'  , '201.53.73.44:6588'      , '201.66.27.218:6588'   ,
    '201.75.78.76:6588'     , '201.86.70.162:80'     , '203.124.21.224:6588'  , '203.86.31.92:3128'      , '207.161.20.188:9090'  ,
    '208.53.196.161:9090'   , '209.159.228.202:9090' , '209.218.218.171:9090' , '211.140.151.214:8080'   , '218.248.20.160:6588'  ,
    '220.224.226.149:3128'  , '24.127.113.227:9090'  , '24.14.112.139:9090'   , '24.153.249.240:9090'    , '24.189.5.235:9090'    ,
    '24.22.86.147:9090'     , '24.230.182.225:9090'  , '24.98.81.111:9090'    , '59.92.3.208:6588'       , '59.94.177.245:6588'   ,
    '60.49.51.63:6588'      , '62.168.174.254:3128'  , '67.149.215.109:9090'  , '67.168.222.227:9090'    , '67.182.204.248:9090'  ,
    '67.188.156.177:9090'   , '67.87.64.23:9090'     , '68.10.87.155:9090'    , '68.102.90.174:2301'     , '68.11.145.150:9090'   ,
    '68.11.182.166:9090'    , '68.11.237.184:9090'   , '68.13.220.63:9090'    , '68.198.151.89:9090'     , '68.199.107.24:9090'   ,
    '68.229.158.96:9090'    , '68.45.42.160:9090'    , '68.60.189.199:9090'   , '68.63.48.36:9090'       , '68.8.224.217:9090'    ,
    '68.83.156.112:9090'    , '68.9.242.26:9090'     , '68.97.121.200:9090'   , '68.98.0.233:9090'       , '69.118.237.19:9090'   ,
    '69.136.70.21:9090'     , '69.180.8.201:9090'    , '69.246.123.26:9090'   , '69.246.45.182:9090'     , '69.246.61.14:9090'    ,
    '70.177.53.179:9090'    , '70.95.110.195:9090'   , '71.14.95.198:9090'    , '71.192.234.31:9090'     , '71.205.238.236:9090'  ,
    '71.207.56.148:9090'    , '71.229.16.100:9090'   , '71.80.99.54:7212'     , '72.55.191.6:3128'       , '75.87.189.110:9090'   ,
    '76.106.127.211:9090'   , '76.107.44.181:9090'   , '76.113.8.160:9090'    , '76.116.82.97:9090'      , '76.27.54.31:9090'     ,
    '76.28.1.186:9090'      , '76.29.10.61:11055'    , '76.89.23.238:9090'    , '80.0.76.158:9090'       , '82.13.85.245:9090'    ,
    '82.28.185.247:9090'    , '82.38.36.40:9090'     , '82.9.52.183:9090'     , '83.167.122.41:3128'     , '83.220.195.232:9090'  ,
    '86.21.200.186:9090'    , '86.22.7.232:9090'     , '87.120.67.39:6588'    , '88.171.218.44:9090'     , '88.173.201.9:21570'   ,
    '90.188.254.197:3128'   , '91.78.100.114:38392'  , '92.237.9.240:9090'    , '96.28.116.40:9090'      , '96.28.160.240:9090'   ,
    '96.3.152.82:9090'      , '98.202.107.151:9090'  , '98.240.186.255:9090'  , '98.244.161.239:9090'    , '99.155.153.203:9090'  ,
    '142.59.52.201:9090'    , '157.182.52.224:9090'  , '189.20.207.150:8080'  , '190.152.37.58:6588'     , '198.164.83.28:9090'   ,
    '201.13.169.167:6588'   , '201.14.225.222:6588'  , '201.229.208.2:80'     , '201.252.106.88:6588'    , '201.255.178.224:6588' ,
    '201.26.19.180:6588'    , '201.3.184.222:6588'   , '201.42.69.73:6588'    , '201.45.188.169:6588'    , '201.68.18.124:6588'   ,
    '201.75.20.103:6588'    , '201.76.29.82:6588'    , '201.88.248.243:6588'  , '202.134.202.251:80'     , '203.110.240.22:80'    ,
    '204.111.219.182:9090'  , '204.85.72.128:9090'   , '206.174.3.131:9090'   , '207.38.251.111:9090'    , '208.107.124.142:9090' ,
    '209.145.114.173:9090'  , '209.159.241.112:9090' , '210.52.15.210:808'    , '211.90.22.106:8088'     , '212.17.86.109:8080'   ,
    '216.80.118.13:9090'    , '218.75.23.110:3128'   , '218.97.194.94:80'     , '221.224.95.158:808'     , '24.10.186.31:9090'    ,
    '24.10.84.226:9090'     , '24.12.214.237:9090'   , '24.137.215.227:9090'  , '24.156.135.87:9090'     , '24.161.131.67:9090'   ,
    '24.167.83.34:9090'     , '24.174.246.62:9090'   , '24.185.121.80:9090'   , '24.188.121.167:9090'    , '24.188.125.225:9090'  ,
    '24.192.240.240:9090'   , '24.217.194.73:9090'   , '24.228.49.186:9090'   , '24.23.182.99:9090'      , '24.3.105.116:9090'    ,
    '24.30.90.20:9090'      , '24.4.239.144:9090'    , '24.8.191.246:9090'    , '24.9.22.230:9090'       , '24.98.204.26:9090'    ,
    '58.8.150.146:6588'     , '59.56.174.199:808'    , '61.175.226.78:808'    , '61.187.187.28:80'       , '61.238.104.200:808'   ,
    '62.168.173.33:3128'    , '64.17.66.234:9090'    , '65.30.92.48:9090'     , '66.167.228.62:9090'     , '66.214.17.189:9090'   ,
    '66.229.205.251:9090'   , '66.41.189.96:9090'    , '66.57.75.68:9090'     , '67.163.161.226:9090'    , '67.191.141.209:9090'  ,
    '67.191.220.137:9090'   , '67.48.22.73:9090'     , '67.84.115.34:9090'    , '67.84.84.89:9090'       , '67.9.20.215:9090'     ,
    '68.105.0.173:9090'     , '68.105.12.164:9090'   , '68.11.226.141:9090'   , '68.11.249.230:9090'     , '68.227.129.204:9090'  ,
    '68.228.236.251:9090'   , '68.62.176.8:9090'     , '68.84.126.225:9090'   , '69.113.232.218:9090'    , '69.114.237.205:9090'  ,
    '69.116.42.119:9090'    , '69.123.44.118:9090'   , '69.127.115.255:9090'  , '69.136.136.125:9090'    , '69.136.58.38:9090'    ,
    '69.138.46.194:9090'    , '69.161.78.160:9090'   , '69.242.176.42:9090'   , '69.245.52.76:9090'      , '69.246.117.136:9090'  ,
    '69.249.151.19:9090'    , '69.253.188.82:9090'   , '69.71.85.202:9090'    , '70.125.110.220:9090'    , '70.161.20.242:9090'   ,
    '70.172.242.76:9090'    , '70.186.168.130:9090'  , '70.186.174.186:9090'  , '70.238.144.197:9090'    , '70.74.213.38:9090'    ,
    '71.178.155.167:9090'   , '71.192.233.196:9090'  , '71.194.0.41:9090'     , '71.194.217.243:9090'    , '71.197.189.88:9090'   ,
    '71.205.102.196:9090'   , '71.205.238.140:9090'  , '71.205.37.198:9090'   , '71.224.107.188:9090'    , '71.224.87.71:9090'    ,
    '71.237.41.13:9090'     , '71.8.98.36:9090'      , '71.86.150.78:9090'    , '71.90.230.116:9090'     , '72.196.135.11:9090'   ,
    '74.15.86.86:9090'      , '75.180.26.184:9090'   , '75.183.7.150:9090'    , '75.65.64.163:9090'      , '75.81.22.134:9090'    ,
    '75.83.57.219:9090'     , '76.102.95.54:9090'    , '76.107.208.13:9090'   , '76.107.42.95:9090'      , '76.110.138.122:9090'  ,
    '76.110.211.162:9090'   , '76.112.150.1:9090'    , '76.112.25.186:9090'   , '76.123.18.157:9090'     , '76.127.22.84:9090'    ,
    '76.170.85.232:9090'    , '76.173.155.23:9090'   , '77.100.241.213:9090'  , '80.143.220.5:8080'      , '80.195.248.30:9090'   ,
    '80.4.60.88:9090'       , '81.101.145.245:9090'  , '82.238.32.72:14848'   , '82.41.198.251:9090'     , '82.41.56.62:9090'     ,
    '82.43.58.68:9090'      , '82.45.110.245:9090'   , '82.46.44.15:9090'     , '82.7.105.26:9090'       , '84.198.202.74:9090'   ,
    '85.168.233.221:9090'   , '86.0.224.116:9090'    , '86.12.7.19:9090'      , '87.116.164.85:6588'     , '88.113.14.234:3128'   ,
    '89.241.213.95:9090'    , '89.29.195.27:8080'    , '92.234.144.16:9090'   , '92.236.16.51:9090'      , '92.236.26.72:9090'    ,
    '92.9.76.236:9090'      , '96.3.172.29:9090'     , '97.85.152.126:9090'   , '98.141.23.139:9090'     , '98.155.147.62:9090'   ,
    '98.163.204.145:9090'   , '98.169.171.231:9090'  , '98.192.95.181:9090'   , '98.208.46.176:9090'     , '98.223.204.15:9090'   ,
    '99.225.136.21:9090'    , '12.13.94.227:9090'    , '12.208.168.97:9090'   , '12.208.190.71:9090'     , '12.51.72.38:9090'     ,
    '156.34.176.45:9090'    , '194.46.229.3:9090'    , '195.24.131.87:3128'   , '200.102.217.207:6588'   , '200.161.118.198:6588' ,
    '200.207.48.252:8080'   , '201.1.113.10:6588'    , '201.13.187.229:6588'  , '201.59.184.124:6588'    , '201.80.207.132:6588'  ,
    '202.194.133.31:808'    , '202.78.225.1:8090'    ,  '202.98.141.200:808'  , '203.129.53.177:9090'    , '207.50.148.37:9090'   ,
    '208.53.199.75:9090'    , '210.245.63.218:80'    , '210.34.14.166:81'     , '213.55.87.105:6588'     , '218.206.194.247:8800' ,
    '218.75.76.74:8088'     , '222.73.205.27:808'    , '24.11.124.76:9090'    , '24.139.68.242:9090'     , '24.170.82.144:9090'   ,
    '24.188.251.54:9090'    , '24.190.104.34:9090'   , '24.205.202.45:9090'   , '24.23.199.14:9090'      , '24.254.34.183:9090'   ,
    '24.44.219.167:9090'    , '24.59.34.24:9090'     , '24.70.39.70:9090'     , '64.179.170.189:9090'    , '64.30.123.252:9090'   ,
    '65.28.107.26:9090'     , '65.28.8.13:9090'      , '65.29.85.76:9090'     , '66.177.219.202:9090'    , '66.25.114.65:9090'    ,
    '66.91.101.52:9090'     , '67.149.165.201:9090'  , '67.65.242.94:9090'    , '67.84.148.144:9090'     , '67.9.255.2:9090'      ,
    '68.104.55.221:9090'    , '68.113.102.37:9090'   , '68.117.211.122:9090'  , '68.118.245.35:9090'     , '68.144.70.254:9090'   ,
    '68.198.72.147:9090'    , '68.201.46.56:9090'    , '68.205.170.214:9090'  , '68.59.217.62:9090'      , '68.60.168.230:9090'   ,
    '69.127.102.247:9090'   , '69.127.175.231:9090'  , '69.180.245.32:9090'   , '69.181.89.167:9090'     , '69.47.174.178:9090'   ,
    '71.205.107.223:9090'   , '71.237.98.13:9090'    , '72.128.40.214:9090'   , '72.141.35.81:9090'      , '72.174.123.174:9090'  ,
    '72.178.248.236:9090'   , '72.190.122.130:9090'  , '72.197.212.200:7212'  , '72.203.130.111:9090'    , '74.131.139.186:9090'  ,
    '74.171.2.153:9090'     , '75.85.136.141:9090'   , '75.87.150.14:9090'    , '75.93.212.146:9090'     , '76.244.189.250:9090'  ,
    '77.101.103.239:9090'   , '77.103.254.43:9090'   , '77.99.162.166:9090'   , '82.12.101.34:9090'      , '82.234.51.250:9090'   ,
    '82.24.250.31:9090'     , '82.32.221.58:9090'    , '82.36.86.70:9090'     , '82.40.48.179:9090'      , '82.41.21.126:9090'    ,
    '82.43.63.99:9090'      , '82.45.117.238:9090'   , '83.36.162.217:9090'   , '85.134.160.128:9090'    , '86.10.109.253:9090'   ,
    '86.11.208.239:9090'    , '88.172.20.212:11033'  , '88.174.252.233:11011' , '91.110.151.89:9090'     , '92.236.137.151:9090'  ,
    '92.237.70.251:9090'    , '96.21.139.56:9090'    , '98.197.219.216:9090'  , '98.206.20.88:9090'      , '98.210.139.101:9090'  ,
    '98.28.33.20:9090'      , '99.199.237.158:9090'  , '99.247.210.73:9090'   , '116.48.224.179:9090'    , '201.68.227.8:6588'    ,
    '209.124.242.193:9090'  , '216.228.57.247:9090'  , '218.252.37.227:808'   , '24.175.116.55:9090'     , '24.254.113.238:9090'  ,
    '24.67.14.108:9090'     , '24.77.22.225:9090'    , '65.28.103.187:9090'   , '66.67.106.227:9090'     , '69.151.73.128:9090'   ,
    '69.71.95.69:9090'      , '71.10.72.221:9090'    , '72.174.161.51:9090'   , '72.24.212.232:9090'     , '74.129.180.10:9090'   ,
    '75.179.140.16:9090'    , '76.105.105.96:9090'   , '76.107.137.6:9090'    , '76.69.32.139:9090'      , '77.99.30.244:9090'    ,
    '78.162.45.2:8080'      , '81.101.146.0:9090'    , '82.158.219.108:6588'  , '82.3.162.235:9090'      , '82.34.224.141:9090'   ,
    '82.40.28.187:9090'     , '82.44.34.27:9090'     , '84.198.148.132:9090'  , '86.15.193.138:9090'     , '86.42.180.157:9090'   ,
    '88.165.169.130:9090'   , '92.236.222.129:9090'  , '92.238.25.211:9090'   , '99.232.189.8:9090'      , '99.242.140.117:9090'  ,
    '99.254.203.191:9090'   , '194.117.157.72:11251' , '200.204.235.123:6588' , '201.13.176.9:6588'      , '201.26.133.204:8080'  ,
    '207.181.207.36:9090'   , '209.145.101.201:3128' , '209.159.184.219:9090' , '24.14.107.77:9090'      , '24.154.129.8:9090'    ,
    '24.2.69.26:9090'       , '24.211.49.0:9090'     , '61.234.254.69:8088'   , '65.190.207.153:9090'    , '69.88.35.197:9090'    ,
    '72.207.200.241:9090'   , '74.193.33.187:9090'   , '76.183.112.143:9090'  , '76.214.55.31:9090'      , '77.103.153.29:9090'   ,
    '77.99.11.82:9090'      , '78.224.128.22:80'     , '81.96.127.75:9090'    , '82.22.138.43:9090'      , '82.41.57.26:9090'     ,
    '82.45.253.25:9090'     , '86.61.76.7:8088'      , '90.199.136.7:9090'    , '92.235.253.182:9090'    , '92.238.40.83:9090'    ,
    '97.87.65.118:9090'     , '97.97.255.95:9090'    , '98.16.253.47:8080'    , '189.79.63.28:6588'      , '200.119.56.48:6588'   ,
    '200.21.24.79:6588'     , '201.253.144.1:8080'   , '61.144.109.96:8080'   , '66.253.168.169:9090'    , '66.38.121.88:9090'    ,
    '76.173.95.124:9090'    , '77.100.110.112:9090'  , '77.103.130.91:9090'   , '77.96.143.223:9090'     , '78.43.175.129:9090'   ,
    '80.192.214.147:9090'   , '80.193.158.197:9090'  , '82.24.15.141:9090'    , '82.33.168.194:9090'     , '82.41.10.6:9090'      ,
    '82.46.144.165:9090'    , '86.46.156.172:9090'   , '88.104.209.63:9090'   , '124.53.159.169:80'      , '130.63.177.192:8080'  ,
    '200.217.53.234:6588'   , '201.26.212.10:6588'   , '207.192.207.240:9090' , '216.119.183.110:9090'   , '24.208.37.143:9090'   ,
    '24.78.169.73:9090'     , '71.205.109.70:9090'   , '76.107.108.144:9090'  , '76.187.117.138:9090'    , '77.101.103.91:9090'   ,
    '77.96.105.84:9090'     , '80.4.59.69:9090'      , '82.0.100.211:9090'    , '82.154.126.143:6588'    , '82.33.117.189:9090'   ,
    '82.6.69.14:9090'       , '83.70.106.206:9090'   , '84.194.92.1:9090'     , '92.233.3.150:9090'      , '99.237.129.44:9090'   ,
    '99.254.157.217:9090'   , '122.107.124.56:9090'  , '125.40.59.193:8080'   , '189.111.166.103:6588'   , '193.69.186.83:80'     ,
    '218.229.29.128:8080'   , '58.83.197.27:8080'    , '68.201.24.46:9090'    , '70.76.83.81:9090'       , '75.184.41.3:9090'     ,
    '80.193.189.226:9090'   , '82.12.118.67:9090'    , '82.45.59.203:9090'    , '86.12.57.51:9090'       , '86.24.213.144:9090'   ,
    '92.233.226.34:9090'    , '92.236.18.113:9090'   , '98.165.245.250:9090'  , '116.5.232.33:8088'      , '189.19.168.149:6588'  ,
    '190.139.49.20:8090'    , '201.68.77.129:6588'   , '61.159.214.215:808'   , '80.192.75.52:9090'      , '99.228.104.199:9090'  ,
    '123.127.110.247:80'    , '129.93.193.140:9090'  , '195.3.150.187:3128'   , '67.80.81.65:9090'       , '125.34.30.201:8080'   ,
    '200.232.184.253:6588'  , '92.236.102.208:9090'  , '213.231.139.130:808'  , '67.49.162.117:9090'     , '67.82.22.33:9090'     ,
    '91.147.97.179:3128'    , '67.49.150.210:9090'   , '115.99.10.9:6588'     , '67.81.235.37:9090'      , '12.240.37.195:9090'   ,
    '68.111.231.178:9090'   , '68.42.247.66:9090'    , '218.248.31.212:6588'  , '124.207.168.48:808'     , '216.117.225.240:9090' ,
    '68.84.47.147:9090'     , '122.6.245.14:8090'    , '68.55.225.102:9090'   , '92.233.166.55:9090'     , '128.208.4.199:3127'   ,
    '69.142.108.83:9090'    , '92.239.120.214:9090'  , '140.113.156.245:3128' , '174.0.50.242:9090'      , '69.122.222.90:9090'   ,
    '163.30.32.90:80'       , '69.254.246.123:9090'  , '69.246.218.125:9090'  , '70.119.146.106:9090'    , '70.127.205.107:9090'  ,
    '142.59.90.148:9090'    , '69.250.8.55:9090'     , '189.19.10.23:6588'    , '189.29.117.58:6588'     , '70.86.138.210:8131'   ,
    '70.180.62.153:9090'    , '70.180.206.70:9090'   , '189.19.60.123:6588'   , '187.11.250.36:6588'     , '69.46.16.232:34311'   ,
    '70.64.225.85:9090'     , '71.200.233.55:9090'   , '70.64.250.176:9090'   , '71.205.113.223:9090'    , '24.108.35.246:7212'   ,
    '194.117.157.72:16727'  , '24.118.147.89:9090'   , '24.12.3.143:9090'     , '71.61.176.210:3128'     , '24.151.126.249:9090'  ,
    '72.137.122.212:9090'   , '71.85.121.118:9090'   , '72.207.59.75:9090'    , '72.227.236.241:9090'    , '72.227.36.24:9090'    ,
    '71.82.77.13:9090'      , '71.89.55.232:9090'    , '74.197.219.75:9090'   , '74.77.117.65:9090'      , '24.13.108.167:9090'   ,
    '24.230.163.136:9090'   , '24.20.45.101:9090'    , '74.210.84.24:9090'    , '74.141.111.159:9090'    , '24.61.52.46:9090'     ,
    '72.222.172.142:9090'   , '24.197.130.9:9090'    , '24.85.205.35:9090'    , '24.83.40.206:9090'      , '76.110.119.179:9090'  ,
    '75.94.80.132:9090'     , '98.181.60.131:9090'   , '76.115.37.7:9090'     , '75.64.35.123:9090'      , '76.107.151.18:9090'   ,
    '200.187.136.122:6588'  , '200.61.19.208:6588'   , '76.28.208.70:9090'    , '76.107.38.217:9090'     , '76.247.168.177:9090'  ,
    '200.3.252.170:3128'    , '59.177.176.21:8088'   , '59.37.166.56:3128'    , '76.28.250.36:9090'      , '76.176.208.180:9090'  ,
    '76.22.128.2:9090'      , '76.9.42.163:9090'     , '60.28.209.8:80'       , '77.99.113.100:9090'     , '61.153.140.106:808'   ,
    '77.97.103.232:9090'    , '77.99.183.136:9090'   , '78.138.131.150:8080'  , '98.210.147.111:9090'    , '81.98.109.201:9090'   ,
    '62.119.28.242:80'      , '64.111.32.54:9090'    , '64.83.209.110:9090'   , '81.97.147.154:9090'     , '82.21.184.178:9090'   ,
    '82.33.67.71:9090'      , '82.37.169.145:9090'   , '82.41.5.12:9090'      , '82.40.215.66:9090'      , '82.42.57.203:9090'    ,
    '65.30.216.140:9090'    , '82.33.46.103:9090'    , '66.199.247.42:6649'   , '66.57.230.14:9090'      , '82.35.201.216:9090'   ,
    '82.47.59.57:9090'      , '66.57.1.142:9090'     , '82.46.169.181:9090'   , '209.159.204.250:9090'   , '208.53.199.48:9090'   ,
    '83.85.27.225:9090'     , '86.4.25.128:9090'     , '85.24.89.199:6588'    , '99.232.137.243:9090'    , '86.9.124.75:9090'     ,
    '86.2.31.207:9090'      , '88.183.152.141:11011' , '99.253.188.98:9090'   ,

    # http://www.multiproxy.org/txt_all/proxy.txt (1527)
    '122.6.245.14:8090'     , '123.184.6.251:8088'   , '123.236.215.131:6588' , '172.163.146.56:6588'    , '189.37.28.147:6588'   ,
    '190.53.89.103:6588'    , '200.104.104.91:6588'  , '200.126.98.135:6588'  , '200.252.201.144:80'     , '201.42.59.201:6588'   ,
    '202.134.202.226:80'    , '211.140.151.214:8080' , '212.12.114.252:3128'  , '218.252.37.227:808'     , '59.95.1.229:6588'     ,
    '59.95.73.173:6588'     , '61.174.122.2:8088'    , '61.54.82.130:808'     , '66.167.100.59:6649'     , '68.175.47.31:9090'    ,
    '69.36.7.253:4004'      , '70.86.138.210:8131'   , '71.61.176.210:3128'   , '78.138.131.150:8080'    , '79.172.81.79:44933'   ,
    '81.164.167.69:9090'    , '82.228.101.113:14841' , '82.23.123.51:9090'    , '83.167.122.41:3128'     , '85.11.150.211:6588'   ,
    '85.24.89.199:6588'     , '98.175.97.7:8080'     , '125.137.151.104:3128' , '193.19.82.24:3128'      , '195.89.143.211:8090'  ,
    '200.112.83.72:6588'    , '200.140.83.108:6588'  , '200.150.139.211:6588' , '201.17.188.5:6588'      , '201.229.208.2:80'     ,
    '201.229.208.3:80'      , '207.38.251.111:9090'  , '212.17.86.109:8080'   , '218.83.248.32:8088'     , '222.88.211.181:8089'  ,
    '24.1.166.12:9090'      , '24.10.243.231:7212'   , '24.10.84.226:9090'    , '24.116.25.150:9090'     , '24.118.207.118:9090'  ,
    '24.125.84.2:9090'      , '24.126.147.186:9090'  , '24.127.113.227:9090'  , '24.137.215.227:9090'    , '24.139.68.242:9090'   ,
    '24.14.112.139:9090'    , '24.15.52.62:9090'     , '24.185.121.80:9090'   , '24.189.131.189:9090'    , '24.189.29.189:9090'   ,
    '24.217.194.73:9090'    , '24.222.220.140:9090'  , '24.230.182.225:9090'  , '24.3.105.116:9090'      , '24.4.239.144:9090'    ,
    '24.98.81.111:9090'     , '58.253.111.2:8089'    , '59.94.189.230:6588'   , '61.153.140.106:808'     , '64.179.172.134:9090'  ,
    '64.30.123.252:9090'    , '65.75.189.33:9090'    , '67.149.165.201:9090'  , '67.149.215.109:9090'    , '67.161.239.245:9090'  ,
    '67.166.66.244:9090'    , '67.191.220.137:9090'  , '67.9.3.63:9090'       , '68.10.87.155:9090'      , '68.180.117.215:9090'  ,
    '68.194.177.78:9090'    , '68.198.252.19:9090'   , '68.198.72.147:9090'   , '68.59.217.62:9090'      , '68.63.27.57:9090'     ,
    '68.84.47.147:9090'     , '69.113.232.218:9090'  , '69.120.173.183:9090'  , '69.123.44.118:9090'     , '69.127.115.255:9090'  ,
    '69.136.136.125:9090'   , '69.138.47.42:9090'    , '69.180.245.32:9090'   , '69.180.8.201:9090'      , '69.22.123.154:9090'   ,
    '69.242.176.42:9090'    , '69.246.117.136:9090'  , '69.254.246.123:9090'  , '71.194.216.20:7212'     , '71.195.130.227:9090'  ,
    '71.197.189.88:9090'    , '71.199.134.177:9090'  , '71.205.113.223:9090'  , '71.205.37.198:9090'     , '71.224.87.71:9090'    ,
    '71.228.231.241:9090'   , '71.236.126.53:9090'   , '71.237.41.13:9090'    , '71.237.98.13:9090'      , '72.198.36.75:9090'    ,
    '75.64.232.63:9090'     , '75.64.35.123:9090'    , '75.66.1.212:9090'     , '75.85.136.141:9090'     , '76.106.127.211:9090'  ,
    '76.116.82.97:9090'     , '76.117.245.191:9090'  , '76.183.112.143:9090'  , '76.28.0.206:9090'       , '76.28.250.36:9090'    ,
    '76.29.10.61:11055'     , '81.192.16.53:6588'    , '82.238.120.88:8080'   , '82.32.122.223:9090'     , '82.34.88.122:9090'    ,
    '82.35.73.55:9090'      , '86.4.25.128:9090'     , '86.6.122.30:9090'     , '87.116.164.85:6588'     , '87.120.67.39:6588'    ,
    '88.165.169.130:9090'   , '88.171.218.44:9090'   , '88.172.20.212:11033'  , '96.21.139.56:9090'      , '96.28.160.240:9090'   ,
    '98.163.204.145:9090'   , '98.181.63.127:9090'   , '98.192.95.181:9090'   , '98.216.3.48:9090'       , '98.223.204.15:9090'   ,
    '98.240.186.255:9090'   , '99.199.237.158:9090'  , '125.128.25.151:11011' , '157.182.52.224:9090'    , '160.7.251.98:9090'    ,
    '189.111.166.103:6588'  , '189.18.103.16:6588'   , '200.150.47.167:6588'  , '200.223.197.176:6588'   , '201.40.178.226:6588'  ,
    '202.105.31.68:443'     , '204.111.219.182:9090' , '208.53.199.48:9090'   , '208.53.199.75:9090'     , '211.90.22.106:8088'   ,
    '216.51.236.24:9090'    , '218.206.194.247:8800' , '218.75.23.110:3128'   , '218.75.76.74:8088'      , '218.97.194.94:80'     ,
    '219.121.151.29:80'     , '24.125.217.129:9090'  , '24.13.108.167:9090'   , '24.164.253.14:9090'     , '24.175.116.55:9090'   ,
    '24.186.57.77:9090'     , '24.188.121.167:9090'  , '24.19.124.152:9090'   , '24.190.104.34:9090'     , '24.190.65.208:9090'   ,
    '24.20.45.101:9090'     , '24.201.119.10:9090'   , '24.209.62.190:9090'   , '24.211.49.0:9090'       , '24.23.182.99:9090'    ,
    '24.231.250.241:7212'   , '24.254.113.238:9090'  , '24.255.219.247:9090'  , '24.5.195.141:9090'      , '24.8.191.246:9090'    ,
    '58.20.51.207:808'      , '59.92.40.60:6588'     , '61.234.254.69:8088'   , '63.245.152.3:9090'      , '64.136.197.96:9090'   ,
    '64.179.170.189:9090'   , '66.165.197.37:9090'   , '66.175.164.59:9090'   , '66.177.219.202:9090'    , '66.214.17.189:9090'   ,
    '66.229.205.251:9090'   , '66.38.121.88:9090'    , '66.91.101.52:9090'    , '67.162.165.118:9090'    , '67.165.189.3:9090'    ,
    '67.188.156.177:9090'   , '67.48.22.73:9090'     , '67.84.148.144:9090'   , '67.84.35.131:9090'      , '67.87.24.194:9090'    ,
    '68.104.55.221:9090'    , '68.11.237.184:9090'   , '68.199.153.104:9090'  , '68.201.24.46:9090'      , '68.225.96.18:9090'    ,
    '68.8.224.217:9090'     , '68.81.191.233:9090'   , '68.83.91.141:9090'    , '69.116.42.119:9090'     , '69.122.222.90:9090'   ,
    '69.124.132.102:9090'   , '69.127.175.231:9090'  , '69.136.70.21:9090'    , '69.161.78.160:9090'     , '69.246.61.14:9090'    ,
    '69.249.151.19:9090'    , '69.47.165.83:9090'    , '69.47.174.178:9090'   , '70.177.47.119:9090'     , '70.177.53.179:9090'   ,
    '70.180.206.70:9090'    , '70.180.62.153:9090'   , '70.186.174.186:9090'  , '70.225.83.202:9090'     , '70.64.225.85:9090'    ,
    '71.192.234.31:9090'    , '71.204.73.210:9090'   , '71.205.238.140:9090'  , '71.205.238.236:9090'    , '71.207.56.148:9090'   ,
    '71.224.107.188:9090'   , '71.226.155.186:9090'  , '71.64.8.82:9090'      , '72.134.20.99:9090'      , '72.178.207.48:9090'   ,
    '72.188.68.197:9090'    , '72.227.236.241:9090'  , '72.227.36.24:9090'    , '74.15.86.86:9090'       , '75.108.122.150:9090'  ,
    '75.181.46.254:9090'    , '75.64.211.234:9090'   , '75.87.189.110:9090'   , '76.102.161.57:9090'     , '76.102.95.54:9090'    ,
    '76.110.211.162:9090'   , '76.114.240.59:9090'   , '76.115.37.7:9090'     , '76.182.53.239:9090'     , '76.26.216.31:9090'    ,
    '76.89.23.238:9090'     , '80.193.168.196:9090'  , '80.25.151.126:15353'  , '80.4.60.88:9090'        , '82.2.234.184:9090'    ,
    '82.38.36.40:9090'      , '82.4.69.11:9090'      , '89.241.213.95:9090'   , '92.9.76.236:9090'       , '96.18.67.70:9090'     ,
    '96.3.152.82:9090'      , '96.3.172.29:9090'     , '97.85.152.126:9090'   , '97.91.188.113:9090'     , '98.121.129.95:9090'   ,
    '98.193.185.111:9090'   , '98.194.172.64:9090'   , '98.247.53.216:9090'   , '99.139.195.186:9090'    , '99.228.98.56:9090'    ,
    '99.242.140.117:9090'   , '123.127.110.243:80'   , '189.19.233.32:6588'   , '194.117.157.72:27076'   , '201.17.130.27:6588'   ,
    '201.228.130.234:6588'  , '201.251.34.65:6588'   , '204.112.136.25:9090'  , '210.52.15.210:808'      , '211.167.248.228:8080' ,
    '216.164.170.134:9090'  , '218.194.80.220:808'   , '220.174.209.178:808'  , '24.10.186.31:9090'      , '24.118.147.89:9090'   ,
    '24.151.126.249:9090'   , '24.175.139.203:9090'  , '24.2.4.204:9090'      , '24.22.86.147:9090'      , '24.77.22.225:9090'    ,
    '24.90.177.18:9090'     , '64.111.32.54:9090'    , '64.83.209.110:9090'   , '65.30.92.48:9090'       , '66.57.1.142:9090'     ,
    '66.99.71.247:9090'     , '67.9.255.2:9090'      , '67.9.28.224:9090'     , '68.105.0.173:9090'      , '68.144.70.254:9090'   ,
    '68.62.176.8:9090'      , '69.151.73.128:9090'   , '69.246.218.125:9090'  , '69.246.38.184:9090'     , '70.127.205.107:9090'  ,
    '70.186.168.130:9090'   , '70.26.57.239:9090'    , '71.178.155.167:9090'  , '71.192.233.196:9090'    , '71.200.233.55:9090'   ,
    '71.89.55.232:9090'     , '72.190.121.79:9090'   , '72.24.212.232:9090'   , '72.24.213.96:9090'      , '72.9.72.199:9090'     ,
    '74.131.139.186:9090'   , '74.192.92.162:9090'   , '74.79.165.21:9090'    , '75.83.57.219:9090'      , '76.170.85.232:9090'   ,
    '76.68.66.51:9090'      , '76.84.237.206:9090'   , '77.97.26.167:9090'    , '82.33.117.189:9090'     , '82.35.165.44:9090'    ,
    '82.40.28.187:9090'     , '82.44.239.26:9090'    , '82.6.69.14:9090'      , '86.42.180.157:9090'     , '98.206.20.88:9090'    ,
    '98.210.111.207:9090'   , '99.253.188.98:9090'   , '142.59.52.201:9090'   , '173.32.150.159:9090'    , '189.79.63.28:6588'    ,
    '200.161.6.214:6588'    , '200.58.206.145:6588'  , '201.21.210.84:6588'   , '201.254.56.35:6588'     , '207.181.207.36:9090'  ,
    '217.119.20.82:3128'    , '24.166.174.56:7212'   , '24.170.82.144:9090'   , '24.2.69.26:9090'        , '24.208.37.143:9090'   ,
    '24.30.90.20:9090'      , '60.28.209.8:80'       , '65.185.5.17:9090'     , '66.186.237.190:9090'    , '66.57.75.68:9090'     ,
    '66.67.106.227:9090'    , '68.104.19.90:9090'    , '68.113.102.37:9090'   , '68.117.211.122:9090'    , '68.118.245.35:9090'   ,
    '68.207.186.253:9090'   , '69.245.52.76:9090'    , '70.74.213.38:9090'    , '72.141.35.81:9090'      , '72.141.53.106:9090'   ,
    '72.174.161.51:9090'    , '75.18.209.8:7212'     , '75.183.7.150:9090'    , '76.107.137.6:9090'      , '80.192.65.203:9090'   ,
    '82.6.184.38:9090'      , '83.220.195.232:9090'  , '92.233.226.34:9090'   , '92.234.58.166:9090'     , '97.87.101.89:9090'    ,
    '98.161.24.110:9090'    , '99.199.229.95:9090'   , '99.21.134.25:9090'    , '201.3.53.102:6588'      , '204.85.72.128:9090'   ,
    '216.117.225.240:9090'  , '24.168.35.163:9090'   , '24.179.152.2:9090'    , '59.56.174.199:808'      , '65.28.107.26:9090'    ,
    '65.28.8.13:9090'       , '67.177.158.94:9090'   , '67.68.46.169:9090'    , '68.188.91.22:9090'      , '68.4.217.7:9090'      ,
    '70.82.140.29:9090'     , '71.90.230.116:9090'   , '72.136.252.159:9090'  , '76.27.54.31:9090'       , '77.99.183.136:9090'   ,
    '78.43.175.129:9090'    , '80.6.34.116:9090'     , '86.2.160.241:9090'    , '88.109.194.140:9090'    , '201.86.70.162:80'     ,
    '208.53.196.161:9090'   , '66.253.168.169:9090'  , '66.26.117.254:9090'   , '67.61.171.202:9090'     , '70.125.110.220:9090'  ,
    '71.200.118.56:9090'    , '75.152.23.65:9090'    , '76.107.94.147:9090'   , '81.106.225.136:9090'    , '92.238.40.83:9090'    ,
    '200.220.222.215:6588'  , '201.26.133.204:8080'  , '209.159.241.112:9090' , '24.78.155.155:9090'     , '66.57.230.14:9090'    ,
    '70.76.83.81:9090'      , '75.68.212.175:9090'   , '24.11.124.76:9090'    , '66.253.232.57:9090'     , '91.188.161.235:3128'  ,
    '86.12.223.22:9090'     , '116.7.255.88:8080'    , '124.107.149.63:3128'  , '20.132.16.22:80'        , '201.245.152.230:80'   ,
    '202.129.181.242:8080'  , '202.83.174.14:8080'   , '202.99.29.27:80'      , '207.248.228.166:80'     , '212.95.178.130:80'    ,
    '219.102.226.100:8080'  , '62.69.178.8:80'       , '70.86.138.210:8125'   , '114.30.47.10:80'        , '117.102.54.110:8080'  ,
    '12.130.107.115:80'     , '130.225.245.156:8080' , '131.247.155.3:9090'   , '142.33.100.41:8080'     , '165.166.201.241:8080' ,
    '190.144.112.42:8080'   , '192.115.90.150:8080'  , '210.51.22.185:80'     , '212.119.85.164:80'      , '212.191.130.227:8080' ,
    '212.24.237.49:8080'    , '213.130.111.206:8080' , '219.198.208.140:8080' , '219.53.216.132:8080'    , '221.249.144.93:8088'  ,
    '222.188.91.85:8080'    , '24.72.74.152:9090'    , '38.103.164.174:9090'  , '58.22.101.251:80'       , '61.19.222.7:80'       ,
    '62.99.163.242:8080'    , '66.171.189.82:9090'   , '66.187.205.130:80'    , '71.227.225.115:8000'    , '75.148.238.58:8080'   ,
    '75.68.4.225:9090'      , '76.110.43.10:7212'    , '82.76.17.46:8080'     , '83.141.17.20:80'        , '85.105.144.28:8088'   ,
    '87.245.155.179:80'     , '89.189.84.1:80'       , '89.189.84.118:80'     , '89.189.85.20:80'        , '89.189.85.67:80'      ,
    '91.203.132.59:3128'    , '119.147.23.118:8080'  , '211.100.4.71:80'      , '218.4.65.118:8080'      , '219.106.246.6:80'     ,
    '219.117.209.83:80'     , '219.133.180.67:80'    , '219.142.121.37:80'    , '220.157.98.136:80'      , '221.11.27.110:8080'   ,
    '24.126.135.71:9090'    , '58.42.242.10:8089'    , '60.213.25.170:3128'   , '62.150.81.35:80'        , '78.109.149.162:3128'  ,
    '120.28.64.69:8080'     , '160.97.36.70:8000'    , '193.173.119.83:8080'  , '195.209.224.91:3128'    , '200.163.66.116:80'    ,
    '203.67.172.25:8080'    , '207.157.9.179:9090'   , '212.14.233.47:3128'   , '213.97.52.28:8080'      , '219.239.90.83:80'     ,
    '221.91.128.132:8080'   , '67.162.88.110:9090'   , '67.85.66.187:9090'    , '82.233.131.115:7212'    , '121.73.79.171:9090'   ,
    '189.19.231.136:8000'   , '194.176.176.82:8080'  , '202.106.121.134:80'   , '206.64.92.16:8000'      , '208.77.219.76:80'     ,
    '63.162.106.70:80'      , '64.184.84.246:80'     , '66.253.186.239:9090'  , '70.181.122.211:9090'    , '75.148.238.57:8080'   ,
    '75.185.79.63:8080'     , '80.126.22.246:80'       ,'195.248.239.142:80'    ,'200.243.51.252:80'     , '203.94.229.227:8080'  ,
    '210.86.181.202:80'     , '24.189.79.154:8000'   , '62.150.126.228:80'    , '200.104.250.92:80'      , '66.146.139.235:8000'  ,
    '85.252.212.138:9090'   , '118.98.232.202:8080'  , '151.11.232.92:80'     , '203.70.96.9:80'         , '216.195.37.250:82'    ,
    '74.54.156.73:80'       , '195.226.16.132:80'    , '200.55.208.203:80'    , '59.61.88.193:80'        , '211.138.198.6:10917'  ,
    '213.132.44.241:80'     , '217.172.187.98:80'    , '220.224.224.66:3128'  , '92.64.178.98:8080'      , '62.149.95.43:8080'    ,
    '208.81.7.18:80'        , '91.121.84.92:80'      , '125.89.73.159:80'     , '116.90.129.134:80'      , '159.148.82.3:3128'    ,
    '189.51.255.19:8080'    , '192.203.138.63:80'    , '193.45.143.12:80'     , '193.45.143.41:80'       , '194.44.221.137:3128'  ,
    '200.165.90.114:8080'   , '200.171.58.137:3128'  , '200.211.233.132:3128' , '200.213.117.2:8080'     , '200.49.141.56:8080'   ,
    '201.133.171.213:8080'  , '201.14.116.3:3128'    , '202.134.202.144:80'   , '202.40.182.82:8080'     , '202.71.103.109:3128'  ,
    '206.227.34.10:3128'    , '208.45.143.105:80'    , '208.67.195.32:80'     , '208.74.50.197:3128'     , '209.124.34.27:80'     ,
    '209.20.82.228:80'      , '209.235.218.83:80'    , '209.237.236.110:80'   , '209.34.241.44:80'       , '26.14.98.225:80'      ,
    '216.173.2.205:8080'    , '217.12.51.38:8080'    , '218.107.24.3:3128'    , '222.92.51.221:808'      , '59.93.43.186:3128'    ,
    '60.217.80.36:8080'     , '60.6.205.20:808'      , '63.146.109.190:80'    , '65.199.160.6:80'        , '65.243.68.184:80'     ,
    '65.57.240.117:80'      , '65.57.240.121:80'     , '65.57.240.174:80'     , '65.57.240.176:80'       , '65.57.240.177:80'     ,
    '65.57.240.234:80'      , '66.77.122.132:80'     , '66.77.122.135:80'     , '66.94.172.129:8080'     , '67.15.104.28:80'      ,
    '77.42.159.251:80'      , '79.188.118.70:8080'   , '80.51.221.94:3128'    , '80.81.52.225:8080'      , '81.177.3.10:3128'     ,
    '83.170.109.8:8080'     , '87.204.246.122:8080'  , '87.204.246.192:8080'  , '87.204.246.68:8080'     , '87.204.246.78:8080'   ,
    '88.191.44.184:8080'    , '89.208.43.141:80'     , '91.121.61.20:80'      , '119.70.40.101:8080'     , '121.14.211.71:80'     ,
    '121.15.164.9:3128'     , '121.207.252.139:80'   , '121.80.179.213:80'    , '159.148.82.4:3128'      , '189.108.155.120:3128' ,
    '189.21.136.84:3128'    , '190.24.8.82:3128'     , '190.65.211.154:8080'  , '190.65.224.10:80'       , '195.248.240.146:8080' ,
    '195.251.38.71:8888'    , '200.207.9.168:3128'   , '200.223.102.82:80'    , '200.223.19.101:3128'    , '200.29.106.240:3128'  ,
    '200.43.141.173:8080'   , '201.24.240.130:3128'  , '201.65.121.102:3128'  , '202.107.231.157:8080'   , '202.181.211.237:80'   ,
    '202.29.22.12:3128'     , '202.29.22.3:3128'     , '202.29.22.4:3128'     , '203.153.214.146:80'     , '203.160.1.103:80'     ,
    '203.160.1.112:80'      , '203.160.1.121:80'     , '203.160.1.130:554'    , '203.160.1.162:554'      , '203.160.1.66:80'      ,
    '203.77.192.92:80'      , '203.89.30.142:80'     , '208.45.143.104:80'    , '210.238.184.150:3128'   , '212.109.155.130:8080' ,
    '212.117.162.228:3128'  , '212.93.193.72:443'    , '212.93.193.74:443'    , '212.93.193.78:443'      , '212.93.193.82:443'    ,
    '212.93.193.83:443'     , '213.207.35.43:80'     , '218.17.246.197:3128'  , '218.75.100.114:8080'    , '219.101.35.83:3128'   ,
    '219.132.142.10:8080'   , '219.134.242.204:3128' , '219.159.77.144:3128'  , '220.227.31.179:8080'    , '220.227.47.6:8080'    ,
    '220.227.47.7:8080'     , '221.215.143.18:808'   , '221.224.53.83:3128'   , '221.230.139.83:3128'    , '222.124.5.92:8080'    ,
    '222.223.127.130:808'   , '222.73.227.233:80'    , '222.73.86.75:80'      , '58.242.42.91:3128'      , '58.254.201.237:3128'  ,
    '60.2.93.11:80'         , '66.104.77.20:3128'    , '66.197.252.182:80'    , '66.198.41.11:3128'      , '67.19.148.234:3128'   ,
    '67.228.42.208:80'      , '67.69.254.243:80'     , '67.69.254.246:80'     , '67.69.254.248:80'       , '67.69.254.252:80'     ,
    '67.69.254.254:80'      , '67.69.254.255:80'     , '72.249.149.144:80'    , '75.126.176.161:80'      , '77.240.82.6:80'       ,
    '80.91.112.202:8080'    , '82.192.83.7:3128'     , '85.214.59.79:8080'    , '87.224.243.113:3128'    , '87.237.228.18:8080'   ,
    '89.144.96.79:808'      , '89.210.114.220:8080'  , '89.31.143.2:80'       , '95.82.194.72:3128'      , '117.102.15.218:8080'  ,
    '117.102.60.205:8080'   , '117.102.93.131:3128'  , '118.144.187.156:80'   , '119.10.182.20:80'       , '119.146.73.114:8080'  ,
    '12.191.44.111:80'      , '12.228.215.52:9090'   , '12.228.215.61:9090'   , '12.228.215.62:9090'     , '121.22.29.180:80'     ,
    '121.22.29.181:80'      , '121.22.29.182:80'     , '121.22.29.183:80'     , '122.224.97.85:3128'     , '123.49.42.81:8080'    ,
    '124.106.77.200:3128'   , '124.164.247.43:3128'  , '124.30.18.245:3128'   , '124.81.45.233:80'       , '125.242.128.78:8080'  ,
    '125.93.187.234:3128'   , '187.4.61.2:3128'      , '189.21.246.135:3128'  , '190.136.215.70:3128'    , '196.212.252.194:8080' ,
    '200.174.31.29:3128'    , '200.254.12.2:8080'    , '200.254.221.146:3128' , '201.26.37.196:3128'     , '201.75.105.179:8080'  ,
    '203.160.1.75:80'       , '203.160.1.85:80'      , '203.160.1.94:80'      , '203.162.183.222:80'     , '203.162.7.82:8080'    ,
    '203.172.138.187:80'    , '203.177.152.162:3128' , '203.179.87.186:3128'  , '211.95.176.6:808'       , '218.0.1.30:8080'      ,
    '218.14.227.197:3128'   , '219.136.252.120:3128' , '219.239.90.85:3128'   , '219.239.90.96:3128'     , '221.203.154.26:8080'  ,
    '222.122.19.72:80'      , '222.122.19.76:80'     , '222.124.9.122:80'     , '222.135.178.62:8080'    , '222.208.242.30:3128'  ,
    '222.239.222.56:8080'   , '41.242.150.184:3128'  , '41.244.100.108:3128'  , '58.222.254.13:3128'     , '58.61.143.137:3128'   ,
    '59.18.13.75:80'        , '60.188.118.172:8088'  , '60.28.252.206:3128'   , '61.139.73.6:8080'       , '61.144.24.106:3128'   ,
    '64.66.192.62:80'       , '67.69.254.245:80'     , '69.90.107.184:80'     , '78.138.4.34:80'         , '89.211.49.84:3128'    ,
    '89.31.143.3:80'        , '118.98.172.34:3128'   , '196.29.205.45:80'     , '201.26.74.58:3128'      , '201.6.125.234:8080'   ,
    '201.9.131.84:80'       , '203.151.233.143:80'   , '212.116.208.242:3128' , '220.128.169.153:3128'   , '222.215.152.139:8080' ,
    '59.120.47.230:3128'    , '60.249.176.80:3128'   , '60.49.177.228:3128'   , '67.69.254.240:80'       , '67.69.254.244:80'     ,
    '67.69.254.250:80'      , '77.71.0.246:3128'     , '82.206.129.160:3128'  , '89.207.240.235:3128'    , '12.228.215.55:9090'   ,
    '122.224.222.134:3128'  , '125.22.252.134:80'    , '196.202.28.38:80'     , '200.199.22.92:3128'     , '200.201.187.250:3128' ,
    '200.41.60.135:3128'    , '201.251.159.7:3128'   , '201.48.46.3:3128'     , '60.12.190.109:8088'     , '60.251.140.10:3128'   ,
    '67.69.254.253:80'      , '86.105.181.238:3128'  , '87.120.60.3:8080'     , '89.31.143.1:80'         , '120.50.176.58:8080'   ,
    '122.224.171.91:3128'   , '187.0.92.17:3128'     , '189.108.124.155:3128' , '189.85.162.190:3128'    , '190.18.106.88:80'     ,
    '194.44.170.81:3128'    , '195.234.182.13:3128'  , '200.242.232.8:8080'   , '219.88.253.41:80'       , '222.187.221.91:80'    ,
    '87.120.58.65:8080'     , '89.28.20.132:3128'    , '170.210.18.245:8080'  , '187.5.67.55:80'         , '196.29.205.49:80'     ,
    '201.82.32.56:8080'     , '203.73.180.16:3128'   , '59.120.77.147:3128'   , '60.190.151.77:8088'     , '118.98.169.66:80'     ,
    '164.100.42.68:8080'    , '189.114.225.170:80'   , '189.74.11.18:8080'    , '201.17.130.41:3128'     , '210.51.14.197:80'     ,
    '213.169.51.151:8080'   , '213.185.116.152:8080' , '213.215.7.108:3128'   , '58.213.152.15:3128'     , '60.30.83.220:8080'    ,
    '60.50.80.111:3128'     , '61.19.213.91:80'      , '67.69.254.247:80'     , '67.69.254.251:80'       , '81.85.253.74:80'      ,
    '89.42.17.147:3128'     , '91.121.14.70:3128'    , '219.93.178.162:3128'  , '68.100.4.165:3128'      , '85.114.131.54:8081'   ,
    '87.120.57.8:8080'      , '187.2.151.207:3128'   , '201.75.54.245:3128'   , '202.101.8.184:80'       , '220.194.221.29:3128'  ,
    '222.124.172.220:8080'  , '123.255.250.5:3128'   , '217.10.246.2:8080'    , '217.133.80.15:3128'     , '61.105.175.113:88'    ,
    '61.247.7.8:3128'       , '221.2.145.28:3128'    , '200.243.243.150:3128' , '212.0.143.5:3128'       , '123.127.110.244:80'   ,
    '200.109.72.53:6588'    , '201.15.184.136:6588'  , '201.44.24.98:80'      , '201.53.164.111:3128'    , '201.53.73.44:6588'    ,
    '24.23.29.41:8080'      , '58.34.239.226:8088'   , '59.95.161.172:6588'   , '59.99.129.193:6588'     , '66.199.247.42:6649'   ,
    '72.55.191.6:3128'      , '86.122.132.27:8080'   , '92.48.127.2:8080'     , '121.204.86.172:8088'    , '121.206.106.110:8090' ,
    '195.135.236.204:3128'  , '200.118.158.45:6588'  , '201.13.183.108:6588'  , '201.43.215.59:6588'     , '201.88.248.243:6588'  ,
    '202.134.202.251:80'    , '203.86.31.92:3128'    , '216.183.95.239:80'    , '24.125.134.220:9090'    , '24.125.71.100:9090'   ,
    '24.156.135.87:9090'    , '24.188.125.225:9090'  , '24.239.46.244:9090'   , '24.61.52.46:9090'       , '65.182.107.212:9090'  ,
    '65.30.216.140:9090'    , '67.191.141.209:9090'  , '67.84.241.17:9090'    , '67.86.138.122:9090'     , '68.11.182.166:9090'   ,
    '68.11.249.230:9090'    , '68.42.122.142:9090'   , '68.43.246.42:9090'    , '68.45.42.160:9090'      , '68.52.135.28:9090'    ,
    '68.55.132.134:9090'    , '68.55.225.102:9090'   , '69.119.243.192:9090'  , '69.127.102.247:9090'    , '69.136.140.1:9090'    ,
    '69.136.58.38:9090'     , '69.251.251.153:9090'  , '69.253.188.82:9090'   , '71.57.210.123:9090'     , '72.196.135.11:9090'   ,
    '74.131.165.152:9090'   , '74.141.111.159:9090'  , '76.107.38.217:9090'   , '76.107.44.181:9090'     , '76.127.22.84:9090'    ,
    '76.22.0.234:9090'      , '76.30.187.68:9090'    , '80.143.226.158:8080'  , '82.41.96.73:9090'       , '82.43.58.68:9090'     ,
    '82.5.189.202:7212'     , '98.141.23.139:9090'   , '98.192.124.144:9090'  , '98.27.180.252:9090'     , '99.163.104.229:9090'  ,
    '99.233.94.169:9090'    , '12.208.190.71:9090'   , '12.51.72.38:9090'     , '123.6.23.77:8090'       , '142.59.90.148:9090'   ,
    '200.3.252.170:3128'    , '201.75.9.88:6588'     , '210.245.63.218:80'    , '216.80.118.13:9090'     , '220.72.71.220:8080'   ,
    '222.179.57.225:808'    , '24.12.214.237:9090'   , '24.127.136.205:9090'  , '24.161.131.67:9090'     , '24.189.5.235:9090'    ,
    '24.192.240.240:9090'   , '24.228.49.186:9090'   , '24.59.34.24:9090'     , '58.33.52.65:8088'       , '61.191.53.137:808'    ,
    '61.238.104.200:808'    , '65.29.85.76:9090'     , '66.167.228.62:9090'   , '67.163.161.226:9090'    , '67.217.17.182:9090'   ,
    '67.84.196.173:9090'    , '67.87.64.23:9090'     , '68.11.145.150:9090'   , '68.194.169.106:7212'    , '68.49.227.31:9090'    ,
    '69.142.108.83:9090'    , '69.142.114.143:9090'  , '69.181.224.191:9090'  , '69.71.85.202:9090'      , '70.172.242.76:9090'   ,
    '70.95.110.195:9090'    , '71.101.126.174:9090'  , '71.12.195.20:9090'    , '71.82.77.13:9090'       , '71.86.150.78:9090'    ,
    '72.174.123.174:9090'   , '74.211.5.196:9090'    , '75.34.25.118:7212'    , '75.87.150.14:9090'      , '76.104.70.144:9090'   ,
    '76.105.105.96:9090'    , '76.123.18.157:9090'   , '76.176.208.180:9090'  , '76.228.201.224:9090'    , '76.9.38.239:9090'     ,
    '76.98.163.114:9090'    , '77.99.40.240:9090'    , '80.195.186.31:9090'   , '81.105.32.186:9090'     , '86.17.234.113:9090'   ,
    '87.232.56.70:9090'     , '92.236.137.151:9090'  , '98.169.171.231:9090'  , '98.181.60.131:9090'     , '98.202.107.151:9090'  ,
    '98.208.46.176:9090'    , '98.210.147.111:9090'  , '99.155.153.203:9090'  , '12.167.39.75:9090'      , '12.240.37.195:9090'   ,
    '156.34.176.45:9090'    , '171.66.223.221:9090'  , '174.0.50.242:9090'    , '200.89.39.210:6588'     , '207.50.148.37:9090'   ,
    '210.34.14.166:81'      , '218.6.15.70:8080'     , '221.11.11.202:30781'  , '24.125.158.161:9090'    , '59.37.166.56:3128'    ,
    '64.17.66.234:9090'     , '65.25.158.119:7212'   , '65.31.98.112:9090'    , '66.184.78.194:9090'     , '68.11.226.141:9090'   ,
    '68.118.147.60:9090'    , '69.246.123.26:9090'   , '70.101.148.107:9090'  , '70.176.119.94:9090'     , '70.179.177.238:9090'  ,
    '71.14.93.226:9090'     , '71.14.94.189:9090'    , '71.229.16.100:9090'   , '71.86.181.6:9090'       , '71.89.7.99:28848'     ,
    '72.128.40.214:9090'    , '72.203.130.111:9090'  , '74.222.221.250:9090'  , '74.77.117.65:9090'      , '76.22.128.2:9090'     ,
    '77.96.218.150:9090'    , '82.22.138.43:9090'    , '82.36.17.30:9090'     , '99.254.218.6:9090'      , '202.98.141.200:808'   ,
    '203.129.53.177:9090'   , '222.242.221.156:8080' , '24.230.163.136:9090'  , '65.190.207.153:9090'    , '66.211.127.78:9090'   ,
    '68.111.231.178:9090'   , '69.250.8.55:9090'     , '69.46.16.232:34311'   , '70.24.40.159:9090'      , '71.17.227.187:9090'   ,
    '71.71.69.209:9090'     , '74.60.191.215:9090'   , '75.81.22.134:9090'    , '75.94.87.64:9090'       , '76.102.189.58:9090'   ,
    '76.107.111.45:9090'    , '81.103.66.124:9090'   , '82.39.25.203:9090'    , '82.41.10.6:9090'        , '92.233.176.50:9090'   ,
    '99.252.209.25:9090'    , '202.149.113.148:8080' , '206.174.3.131:9090'   , '207.192.207.240:9090'   , '209.124.242.193:9090' ,
    '209.145.114.173:9090'  , '24.108.35.246:7212'   , '24.174.246.62:9090'   , '24.197.130.9:9090'      , '24.70.39.70:9090'     ,
    '65.50.35.144:9090'     , '65.50.35.157:9090'    , '68.13.235.68:9090'    , '71.205.51.156:9090'     , '74.197.219.75:9090'   ,
    '75.119.93.168:9090'    , '76.107.42.95:9090'    , '76.107.93.40:9090'    , '81.100.109.24:9090'     , '82.29.59.18:9090'     ,
    '82.33.114.102:9090'    , '82.38.0.167:9090'     , '92.233.166.55:9090'   , '194.117.157.72:14624'   , '208.59.142.26:9090'   ,
    '68.183.54.233:7212'    , '81.106.241.109:9090'  , '82.33.168.194:9090'   , '86.61.76.7:8088'        , '99.225.136.21:9090'   ,
    '24.68.44.46:7212'      , '68.98.0.233:9090'     , '24.14.107.77:9090'    , '208.149.67.192:9090'    , '72.222.172.142:9090'  ,
    '76.9.42.163:9090'      , '77.103.136.52:9090'   , '99.253.240.184:9090'  , '193.69.186.83:80'       , '70.111.46.122:7212'   ,
    '81.98.109.201:9090'    , '71.109.3.95:7212'     , '82.46.144.165:9090'   , '163.29.250.4:3128'      , '190.67.73.194:8080'   ,
    '193.2.8.8:80'          , '212.193.5.226:80'     , '217.12.254.154:80'    , '220.15.224.200:8080'    , '221.25.244.167:8080'  ,
    '67.84.8.11:7212'       , '80.88.242.32:9090'    , '84.113.7.221:8080'    , '124.35.158.72:80'       , '203.82.52.210:8080'   ,
    '219.191.64.95:8080'    , '220.22.196.3:80'      , '24.44.64.205:8000'    , '67.208.3.220:8080'      , '68.196.110.175:8000'  ,
    '68.43.151.18:9090'     , '72.191.26.100:7212'   , '72.214.91.6:8008'     , '74.210.245.5:8008'      , '84.23.101.224:8080'   ,
    '91.203.68.222:80'      , '92.239.116.56:9090'   , '98.165.169.136:8000'  , '124.29.140.84:80'       , '124.5.165.8:8080'     ,
    '195.34.253.66:3128'    , '200.253.135.236:80'   , '212.11.179.159:80'    , '212.57.189.242:80'      , '213.166.145.170:80'   ,
    '216.102.26.104:8000'   , '41.240.178.30:80'     , '76.31.231.123:8000'   , '220.53.245.8:8080'      , '41.242.80.113:80'     ,
    '59.144.175.48:8080'    , '91.121.3.29:9090'     , '212.123.91.165:80'    , '221.8.16.189:3128'      , '62.244.72.48:80'      ,
    '65.190.201.251:9090'   , '88.2.102.209:3128'    , '218.182.134.23:8080'  , '218.222.200.97:8080'    , '67.69.140.58:80'      ,
    '82.41.145.108:9090'    , '194.55.138.53:80'     , '200.31.42.3:80'       , '217.86.159.36:80'       , '219.201.68.111:8080'  ,
    '91.189.240.25:80'      , '150.188.8.211:80'     , '222.255.29.46:8888'   , '76.25.6.162:7212'       , '210.86.181.201:80'    ,
    '216.101.231.130:8000'  , '122.169.242.249:8080' , '174.36.168.202:8080'  , '202.168.193.131:80'     , '210.82.31.151:80'     ,
    '200.104.250.91:80'     , '187.153.52.168:80'    , '212.100.132.149:3128' , '65.57.240.166:80'       , '65.57.240.173:80'     ,
    '65.57.240.178:80'      , '65.57.240.211:80'     , '65.57.240.214:80'     , '65.57.240.227:80'       , '65.57.240.241:80'     ,
    '67.69.254.249:80'      , '81.177.3.10:80'       , '82.146.41.129:80'     , '88.80.194.14:3128'      , '12.68.114.188:8080'   ,
    '125.160.60.131:80'     , '187.5.16.81:8080'     , '189.16.1.204:3128'    , '200.49.141.58:8080'     , '200.49.141.71:8080'   ,
    '64.66.192.61:80'       , '64.66.192.62:32080'   , '67.69.254.241:80'     , '84.50.83.126:3128'      , '85.10.197.73:8000'    ,
    '125.160.145.163:3128'  , '201.34.32.45:3128'    , '201.68.9.74:3128'     , '202.152.27.181:3128'    , '202.57.9.186:8080'    ,
    '203.160.1.130:553'     , '203.160.1.162:553'    , '211.137.205.254:8008' , '211.99.188.218:80'      , '58.211.186.250:3128'  ,
    '67.69.254.242:80'      , '91.142.12.174:8080'   , '124.106.77.46:3128'   , '200.49.141.59:8080'     , '201.73.61.2:3128'     ,
    '212.100.132.146:3128'  , '212.100.132.148:3128' , '220.227.170.27:80'    , '85.255.79.34:3128'      , '86.62.23.70:8080'     ,
    '88.255.57.7:3128'      , '91.193.255.174:3128'  , '200.164.91.8:8080'    , '200.87.30.3:3128'       , '202.133.85.68:8080'   ,
    '202.155.10.131:8080'   , '204.16.127.126:8080'  , '222.124.226.43:8080'  , '60.50.8.98:3128'        , '91.112.244.198:8080'  ,
    '189.111.206.139:3128'  , '201.17.130.41:80'     , '202.152.3.82:8080'    , '83.3.145.82:8080'       , '89.191.100.2:8080'    ,
    '91.142.12.62:8080'     , '118.98.172.187:3128'  , '121.242.41.67:3128'   , '203.70.237.16:3128'     , '212.100.64.41:3128'   ,
    '220.181.19.108:8090'   , '61.220.224.115:3128'  , '118.136.202.245:3128' , '219.163.71.130:3128'    , '222.124.9.122:8080'   ,
    '200.140.88.98:3128'    , '200.171.149.199:3128' , '202.57.48.195:3128'   , '218.94.9.38:8080'       , '222.123.83.42:3128'   ,
    '222.124.177.60:3128'   , '60.54.129.30:3128'    , '87.250.37.182:80'     , '125.162.90.26:3128'     , '190.216.249.4:80'     ,
    '201.42.136.25:3128'    , '24.91.133.150:57223'  , '24.46.40.108:56537'   , '24.61.217.227:30223'    , '24.22.4.18:37119'     ,
    '160.80.2.198:4304'     , '24.95.66.210:25997'   , '24.191.8.191:52369'   , '69.37.32.236:22243'     , '189.47.129.62:1080'   ,
    '69.255.94.177:46129'   , '24.94.66.230:56033'   , '189.111.207.75:1080'  , '71.233.35.25:4021'      , '69.137.215.241:52441' ,
    '71.204.34.188:30503'   , '71.79.69.245:2731'    , '24.214.140.113:6293'  , '71.201.65.181:57783'    , '121.8.124.42:1080'    ,
    '71.71.23.25:61197'     , '69.126.32.27:49185'   , '124.128.224.2:1080'   , '70.52.129.143:58329'    , '71.87.102.164:8329'   ,
    '69.140.56.187:7539'    , '58.56.87.2:1080'      , '58.57.60.26:1080'     , '58.214.247.198:1080'    , '124.42.122.163:1080'  ,
    '98.222.47.229:42929'   , '71.58.225.132:16935'  , '72.11.85.77:3661'     , '194.117.157.72:19245'   , '72.136.220.101:42931' ,
    '98.238.35.199:52173'   , '69.91.87.60:53935'    , '70.71.22.79:33963'    , '69.134.50.18:44429'     , '75.111.227.101:42359' ,
    '71.192.9.147:5789'     , '98.231.8.76:30595'    , '123.203.186.11:1080'  , '162.83.95.16:40547'     , '71.60.128.209:9043'   ,
    '74.192.84.183:54889'   , '71.139.163.70:17429'  , '75.139.61.41:27359'   , '122.50.139.155:1080'    , '74.14.253.48:62113'   ,
    '24.46.70.97:7831'      , '59.94.41.39:1080'     , '70.121.145.153:37501' , '75.159.127.60:43575'    , '75.42.200.67:22127'   ,
    '75.26.160.76:3533'     , '75.64.104.185:33459'  , '122.121.228.92:1080'  , '98.228.131.188:39001'   , '75.64.157.172:34403'  ,
    '71.60.244.81:59593'    , '123.237.251.19:1080'  , '69.253.217.118:24359' , '75.137.111.30:49866'    , '75.70.34.248:26447'   ,
    '98.28.87.38:53629'     , '99.142.87.117:35231'  , '99.147.198.31:53047'  , '200.161.118.198:1080'   , '74.210.132.235:24096' ,
    '76.109.20.32:26679'    , '200.161.81.98:1080'   , '76.111.241.84:14457'  , '201.68.227.8:1080'      , '200.59.10.45:1080'    ,
    '76.101.214.203:22421'  , '76.113.229.133:59145' , '76.28.70.104:12907'   , '76.254.6.241:57023'     , '76.187.180.235:23269' ,
    '76.89.0.61:43229'      , '76.122.50.197:4675'   , '82.114.78.222:1080'   , '82.114.78.225:1080'     , '78.227.88.37:20053'   ,
    '76.119.132.67:52737'   , '66.30.83.96:5991'     , '66.177.89.235:60729'  , '61.116.180.131:1080'    , '60.10.193.26:1080'    ,
    '61.150.92.158:1080'    , '202.57.10.38:1080'    , '67.161.140.214:47347' , '219.136.191.218:1080'   , '211.3.199.21:1080'    ,
    '202.104.35.116:1080'   , '220.189.227.2:1080'   , '66.41.99.70:50111'    , '218.5.18.252:1080'      , '65.184.60.38:22319'   ,
    '218.90.161.189:1080'   , '202.152.44.62:1080'   , '220.136.65.183:1080'  , '67.160.54.36:25065'     , '221.2.196.4:1080'     ,
    '221.12.147.80:1080'    , '64.85.160.217:1080'   , '221.7.229.66:1080'    , '67.174.172.234:35419'   , '67.165.59.130:51743'  ,
    '67.167.42.106:14691'   , '87.244.211.184:1080'  , '60.177.244.252:1080'  , '88.161.144.236:53415'   , '65.64.246.51:9169'    ,
    '87.250.47.36:1080'     , '88.169.195.83:21523'  , '222.167.234.172:1080' , '201.92.247.3:1080'      , '24.190.48.233:5435'   ,
    '67.168.244.141:50877'  , '24.190.96.97:55059'   , '85.159.104.183:1080'  , '24.179.130.205:54045'   , '222.88.11.22:1080'    ,
    '66.203.232.67:60947'   , '222.88.5.182:1080'    , '84.194.160.12:40475'  , '216.194.70.3:1080'      , '83.136.12.2:1080'     ,
    '91.139.241.58:1080'    , '66.186.237.85:6549'   , '88.213.4.99:1080'     , '24.125.77.113:55539'    , '80.247.189.158:1080'  ,
    '220.138.34.244:1080'   , '76.20.225.237:30165'  , '64.85.160.216:1080'   , '99.230.89.13:54249'     , '80.74.94.234:1080'    ,
    '67.43.175.139:1080'    , '96.30.133.60:21811'   , '83.13.143.74:1080'    , '216.12.76.66:21025'     , '66.41.24.69:13247'    ,
    '68.113.197.114:59841'  , '65.26.42.225:53917'   , '98.201.26.161:25345'  , '67.162.119.247:31667'   , '68.194.114.144:12739' ,
    '67.173.210.137:22289'  , '98.206.48.50:40439'   , '67.86.21.88:44093'    , '76.27.146.194:22487'    , '67.82.164.145:26677'  ,
    '76.119.53.226:6391'    , '76.29.75.139:46051'   , '76.78.62.28:13261'    , '76.97.75.84:15765'      , '24.128.2.134:16967'   ,
    '98.216.91.216:15821'   , '91.124.185.172:1080'  , '98.206.0.42:3085'     , '67.66.50.118:18233'     , '66.56.6.98:17941'     ,
    '99.238.161.230:41241'  , '68.45.202.49:34077'   , '24.10.102.196:19105'  , '66.177.236.251:48293'   , '99.244.41.222:2717'   ,
    '68.54.147.33:35223'    , '97.82.166.34:7849'    , '68.62.24.79:6817'     , '99.254.37.138:34693'    , '207.229.149.149:39451',
    '69.120.62.83:62419'    , '123.238.50.6:1080'    , '125.130.27.204:11033' , '121.12.249.207:1080'    , '116.113.47.21:1080'   ,
    '66.133.217.190:3751'   , '118.98.163.109:1080'  , '92.241.102.118:1080'  , '189.47.137.189:1080'    , '123.55.226.74:1080'   ,
    '125.128.25.151:11011'  , '123.176.47.202:1080'  , '189.111.208.162:1080' , '61.177.248.202:1080'    , '124.119.145.2:1080'   ,
    '189.122.89.74:1080'    , '66.169.175.223:51089' , '123.237.8.238:1080'   , '67.166.13.16:13403'     , '194.117.157.72:10416' ,
    '67.167.42.106:40277'   , '189.11.210.77:1080'   , '67.189.231.137:33927' , '66.189.248.247:20573'   , '193.206.43.85:8605'   ,
    '189.47.170.203:1080'   , '189.122.187.204:1080' , '61.159.214.215:1080'  , '189.23.208.37:1080'     , '189.55.219.252:1080'  ,
    '173.98.165.201:2963'   , '64.247.11.135:3307'   , '123.238.35.104:1080'  , '189.19.233.32:1080'     , '61.238.104.200:1080'  ,
    '114.145.227.183:43231' , '65.184.65.236:18191', ' 64.247.11.131:3307'    , '62.150.4.22:1080'       , '123.238.135.198:1080' ,
    '64.198.81.120:1080'    , '68.117.181.133:44633' , '64.247.11.130:3307'   , '61.51.18.104:5394'      , '68.48.134.218:51067'  ,
    '201.252.211.201:1080'  , '202.78.225.1:8888'    , '202.96.159.221:1080'  , '98.182.56.177:23071'    , '69.14.101.143:7445'   ,
    '200.161.139.161:15853' , '200.109.72.53:1080'   , '208.4.254.138:49187'  , '210.6.236.122:1080'     , '207.229.149.149:9983' ,
    '207.255.39.7:15261'    , '71.90.109.248:15099'  , '217.219.80.4:1080'    , '72.4.29.178:58941'      , '218.248.20.160:1080'  ,
    '209.155.105.37:85'     , '218.7.191.182:1080'   , '200.171.17.23:1080'   , '220.112.40.251:1080'    , '220.127.244.50:11033' ,
    '220.231.180.251:1080'  , '75.142.138.35:25552'  , '220.248.224.54:1080'  , '218.250.204.134:1080'   , '75.62.232.144:27055'  ,
    '75.64.39.150:59557'    , '222.135.178.62:1080'  , '222.66.47.115:8088'   , '76.10.169.62:4695'      , '24.121.82.58:6052'    ,
    '75.70.66.136:47311'    , '24.185.240.113:19017' , '222.161.2.180:1080'   , '76.29.10.61:11055'      , '76.171.146.35:23949'  ,
    '98.228.131.188:4905'   , '77.242.19.9:1080'     , '82.225.176.17:17327'  , '82.72.56.119:3388'      , '77.104.239.1:1080'    ,
    '84.127.213.40:48023'   , '24.197.121.90:32557'  , '88.172.20.212:11033'  , '78.83.225.40:11033'     , '85.159.104.245:1080'  ,
    '89.252.5.210:1080'     , '99.130.28.48:34525'   , '99.170.149.73:51849'  , '99.243.172.100:46533'   , '60.191.89.44:1080'    ,
    '121.22.20.202:1080'    , '61.116.180.128:1080'  , '123.240.192.1:1080'   , '118.98.184.86:1080'     , '60.30.83.220:1080'    ,
    '72.178.126.227:39767'  , '72.252.152.124:1080'  , '24.46.217.248:4633'   , '189.101.18.148:1080'    , '64.247.11.128:3307'   ,
    '24.99.196.253:21143'   , '189.19.233.59:1080'   , '189.19.75.98:1080'    , '189.3.176.130:1080'     , '74.174.5.68:1080'     ,
    '189.54.209.254:1080'   , '200.153.197.14:1080'  , '190.67.91.234:1080'   , '194.117.157.72:11251'   , '201.228.149.35:1080'  ,
    '75.94.67.90:1080'      , '201.26.8.186:1080'    , '201.93.128.110:1080'  , '202.57.10.25:1080'      , '201.90.55.194:1080'   ,
    '217.219.80.3:1080'     , '218.241.238.141:1080' , '202.98.141.200:1080'  , '68.20.20.140:6475'      , '218.56.21.226:1080'   ,
    '213.255.196.219:1080'  , '218.64.215.86:1080'   , '219.150.227.101:1080' , '219.159.199.34:1080'    , '222.134.69.181:8000'  ,
    '222.188.10.1:1080'     , '68.82.102.9:25552'    , '80.108.206.239:11033' , '85.113.252.214:1080'    , '86.100.64.151:14841'  ,
    '85.132.201.196:25552'  , '82.228.53.39:11033'   , '80.35.156.3:17327'    , '82.238.32.72:14848'     , '89.77.158.227:17327'  ,
    '87.97.237.135:11033'   , '69.226.246.172:41941' , '89.77.94.73:22568'    , '69.116.194.146:3073'    , '83.143.145.67:1080'   ,
    '88.174.252.233:11011'  , '71.145.167.207:15621' ,

    # http://www.digitalcybersoft.com/ProxyList/fresh-proxy-list.shtml (99)
    '221.130.18.16:80'      , '61.19.205.133:80'     , '221.130.18.20:80'     , '221.130.18.29:80'       , '111.1.32.11:80'       ,
    '111.1.32.59:80'        , '111.1.32.9:80'        , '221.130.18.53:80'     , '221.130.18.13:80'       , '221.130.18.19:80'     ,
    '61.135.130.214:80'     , '218.100.22.60:80'     , '210.107.100.251:8080' , '221.130.18.7:80'        , '111.1.32.19:80'       ,
    '202.104.188.53:80'     , '221.130.18.188:80'    , '221.130.23.132:80'    , '221.130.18.38:80'       , '221.130.23.136:80'    ,
    '221.130.18.37:80'      , '221.130.18.91:80'     , '221.130.18.40:80'     , '221.130.18.15:80'       , '221.130.18.77:80'     ,
    '221.130.17.150:80'     , '221.130.17.152:80'    , '221.130.18.189:80'    , '221.130.18.222:80'      , '111.1.32.18:80'       ,
    '221.130.18.39:80'      , '221.130.23.157:80'    , '111.1.32.4:80'        , '111.1.32.8:80'          , '173.13.150.136:80'    ,
    '111.1.32.17:80'        , '221.130.23.103:80'    , '221.130.18.18:80'     , '111.1.32.16:80'         , '221.130.18.51:80'     ,
    '221.130.23.82:80'      , '67.107.172.53:80'     , '38.112.100.49:8080'   , '173.13.150.143:80'      , '129.177.16.92:80'     ,
    '221.130.23.78:80'      , '211.138.124.164:80'   , '111.1.32.46:80'       , '202.129.58.66:80'       , '111.1.32.49:80'       ,
    '168.216.68.110:8080'   , '210.72.154.153:3128'  , '195.55.130.77:80'     , '221.130.18.80:80'       , '221.130.18.124:80'    ,
    '91.187.152.10:3128'    , '163.43.161.134:80'    , '173.203.125.44:3128'  , '195.55.130.78:80'       , '221.130.18.48:80'     ,
    '213.13.27.248:8080'    , '64.107.146.21:80'     , '124.207.99.60:8080'   , '221.130.18.17:80'       , '111.1.32.60:80'       ,
    '111.1.32.10:80'        , '211.143.117.73:8080'  , '221.130.18.157:80'    , '95.66.8.1:80'           , '95.66.7.1:80'         ,
    '111.1.32.5:80'         , '78.46.69.87:80'       , '118.97.186.219:80'    , '218.248.29.75:80'       , '111.1.32.47:80'       ,
    '72.73.25.190:8118'     , '111.1.32.50:80'       , '221.130.18.49:80'     , '111.1.32.61:80'         , '221.130.23.79:80'     ,
    '95.66.35.1:80'         , '221.130.18.252:80'    , '221.130.23.80:80'     , '211.138.124.197:80'     , '218.201.21.177:80'    ,
    '221.130.7.227:80'      , '221.130.7.228:80'     , '221.130.162.244:80'   , '195.116.53.12:3128'     , '221.130.17.50:80'     ,
    '221.130.17.62:80'      , '208.92.249.118:80'    , '221.130.17.125:80'    , '221.130.17.140:80'      , '218.201.21.176:80'    ,
    '41.208.14.4:80'        , '221.130.17.151:80'    , '218.201.21.164:80'    , '221.130.17.137:80'      ,
];

=head1 AUTHOR

Mohammad S Anwar, C<< <mohammad.anwar at yahoo.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-lwp-useragent-anonymous-proxy at rt.cpan.org>,
or through the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=LWP-UserAgent-Anonymous-Proxy>.
I will be notified, and then you'll automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc LWP::UserAgent::Anonymous::Proxy

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=LWP-UserAgent-Anonymous-Proxy>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/LWP-UserAgent-Anonymous-Proxy>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/LWP-UserAgent-Anonymous-Proxy>

=item * Search CPAN

L<http://search.cpan.org/dist/LWP-UserAgent-Anonymous-Proxy>

=back

=head1 LICENSE AND COPYRIGHT

Copyright 2011 Mohammad S Anwar.

This program is free software; you can redistribute it and/or modify it under
the terms of either: the GNU General Public License as published by the Free
Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=head1 DISCLAIMER

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

=cut

1;