# Generated by default/object.tt
package Paws::ACMPCA::OtherName;
  use Moose;
  has TypeId => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::OtherName

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::OtherName object:

  $service_obj->Method(Att1 => { TypeId => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::OtherName object:

  $result = $service_obj->Method(...);
  $result->Att1->TypeId

=head1 DESCRIPTION

Defines a custom ASN.1 X.400 C<GeneralName> using an object identifier
(OID) and value. The OID must satisfy the regular expression shown
below. For more information, see NIST's definition of Object Identifier
(OID) (https://csrc.nist.gov/glossary/term/Object_Identifier).

=head1 ATTRIBUTES


=head2 B<REQUIRED> TypeId => Str

Specifies an OID.


=head2 B<REQUIRED> Value => Str

Specifies an OID value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

