BEGIN {
  use strict; use warnings;
  {
    my $fn = 'Class/Inspector.pm';
    unless(index('lib/Class/Inspector.pm', $fn) == index('lib/Class/Inspector.pm', 'Class/Inspector.pm'))
    {
      print "I believe you have a broken Perl.\n";
      print "Please see https://github.com/plicease/Class-Inspector/issues/5\n";
      print "If you believe this diagnostic is mistaken, you can edit the Makefile.PL and comment out the logic that determins this.\n";
      print "If you believe this diagnostic is mistaken, feel free to comment on the issue above.\n";
      exit;
    }
  }
  unless(eval q{ use 5.008; 1}) {
    print "Perl 5.008 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.37.
use strict;
use warnings;
use 5.008;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Get information about a class and its structure",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>, Adam Kennedy <adamk\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "Class-Inspector",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME"             => "Class::Inspector",
  "PM"               => {
    "lib/Class/Inspector.pm"           => "\$(INST_LIB)/Class/Inspector.pm",
    "lib/Class/Inspector/Functions.pm" => "\$(INST_LIB)/Class/Inspector/Functions.pm"
  },
  "PREREQ_PM" => {
    "File::Spec" => "0.80",
    "base"       => 0
  },
  "TEST_REQUIRES" => {
    "Test::More" => "0.98"
  },
  "VERSION" => "1.36",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "File::Spec" => "0.80",
  "Test::More" => "0.98",
  "base"       => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);