/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFT6Compressor;
import com.sun.medialib.codec.g4fax.Encoder;

public class TIFFCodecLibT6Compressor
extends TIFFT6Compressor {
    private static final boolean DEBUG = false;
    Object encoder;

    public TIFFCodecLibT6Compressor() {
        try {
            Encoder encoder = new Encoder();
            this.encoder = encoder;
        }
        catch (Throwable t) {
            throw new RuntimeException("CodecLib not available");
        }
    }

    public final synchronized int encodeT6(byte[] data, int lineStride, int colOffset, int width, int height, byte[] compData) {
        if (colOffset % 8 != 0) {
            return super.encodeT6(data, lineStride, colOffset, width, height, compData);
        }
        int bytesPerRow = (width + 7) / 8;
        byte[] image = null;
        if (colOffset == 0 && bytesPerRow == lineStride) {
            image = data;
        } else {
            image = new byte[bytesPerRow * height];
            int dataOffset = colOffset / 8;
            int imageOffset = 0;
            for (int row = 0; row < height; ++row) {
                System.arraycopy(data, dataOffset, image, imageOffset, bytesPerRow);
                dataOffset += lineStride;
                imageOffset += bytesPerRow;
            }
        }
        Encoder clibEncoder = (Encoder)this.encoder;
        int encodingFlags = this.inverseFill ? 128 : 0;
        int result = -1;
        try {
            result = clibEncoder.encode(compData, image, width, height, encodingFlags);
        }
        catch (Throwable t) {
            result = -1;
        }
        if (result == -1) {
            result = super.encodeT6(data, lineStride, colOffset, width, height, compData);
        }
        return result;
    }
}

