/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui;

import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import net.sourceforge.javaocr.gui.GUIController;
import net.sourceforge.javaocr.gui.characterExtractor.CharExtractionPanel;
import net.sourceforge.javaocr.gui.characterTracer.CharacterTracerPanel;
import net.sourceforge.javaocr.gui.handwritingRecognizer.HandwritingRecognizer;
import net.sourceforge.javaocr.gui.lineExtractor.LineExtractionPanel;
import net.sourceforge.javaocr.gui.meanSquareOCR.MeanSquareAnalyzer;

public class OCRTabPane
extends JTabbedPane {
    public static final long serialVersionUID = 0L;
    private final GUIController guiController;
    private static final Logger LOG = Logger.getLogger(OCRTabPane.class.getName());

    public OCRTabPane(GUIController guiController) {
        this.guiController = guiController;
        CharacterTracerPanel characterTracer = new CharacterTracerPanel(guiController);
        this.add("Character Tracer", characterTracer);
        CharExtractionPanel characterExtractor = new CharExtractionPanel(guiController);
        this.add("Character Extractor", characterExtractor);
        LineExtractionPanel lineExtractor = new LineExtractionPanel(guiController);
        this.add("Line Extractor", lineExtractor);
        MeanSquareAnalyzer meanSquareAnalyzer = new MeanSquareAnalyzer(guiController);
        this.add("Mean Square OCR Recognizer", meanSquareAnalyzer);
        HandwritingRecognizer handwritingRecognizer = new HandwritingRecognizer(guiController);
        this.add("[Pre-Alpha] Handwriting Recognizer", handwritingRecognizer);
    }
}

