/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import ucar.ma2.ArrayLong;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;

public class AvhrrConvention
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        if (!ncfile.getFileTypeId().equals("HDF5")) {
            return false;
        }
        Group loc = ncfile.findGroup("VHRR/Geo-Location");
        if (null == loc) {
            return false;
        }
        if (null == loc.findVariable("Latitude")) {
            return false;
        }
        if (null == loc.findVariable("Longitude")) {
            return false;
        }
        return null != ncfile.findGroup("VHRR/Image Data");
    }

    public AvhrrConvention() {
        this.conventionName = "AvhrrSatellite";
    }

    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        ds.addAttribute(null, new Attribute("FeatureType", FeatureType.IMAGE.toString()));
        Group vhrr = ds.findGroup("VHRR");
        Group loc = vhrr.findGroup("Geo-Location");
        Variable lat = loc.findVariable("Latitude");
        lat.addAttribute(new Attribute("units", "degrees_north"));
        lat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lon = loc.findVariable("Longitude");
        lon.addAttribute(new Attribute("units", "degrees_east"));
        lon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int[] shape = lat.getShape();
        assert (shape.length == 2);
        Dimension scan = new Dimension("scan", shape[0]);
        Dimension xscan = new Dimension("xscan", shape[1]);
        vhrr.addDimension(scan);
        vhrr.addDimension(xscan);
        lat.setDimensions("scan xscan");
        lon.setDimensions("scan xscan");
        Group data = vhrr.findGroup("Image Data");
        for (Variable v : data.getVariables()) {
            int[] vs = v.getShape();
            if (vs.length != 2 || vs[0] != shape[0] || vs[1] != shape[1]) continue;
            v.setDimensions("scan xscan");
            v.addAttribute(new Attribute("_CoordinateAxes", "lat lon time"));
        }
        Group info = ds.findGroup("PRODUCT_METADATA/PRODUCT_DETAILS");
        String dateS = info.findAttribute("ACQUISITION_DATE").getStringValue();
        String timeS = info.findAttribute("ACQUISITION_TIME_IN_GMT").getStringValue();
        SimpleDateFormat format = new SimpleDateFormat("ddMMMyyyyHHmm");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date d = format.parse(dateS + timeS);
            VariableDS time = new VariableDS(ds, vhrr, null, "time", DataType.LONG, "", "seconds since 1970-01-01 00:00", "time generated from PRODUCT_METADATA/PRODUCT_DETAILS");
            time.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            time.addAttribute(new Attribute("IsoDate", new DateFormatter().toDateTimeStringISO(d)));
            ds.addVariable(vhrr, time);
            ArrayLong.D0 timeData = new ArrayLong.D0();
            timeData.set(d.getTime() / 1000L);
            time.setCachedData(timeData, true);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        ds.finish();
    }
}

