pragma Singleton
import QtQuick 6.7
import QtQuick.Studio.Application

QtObject {
    readonly property int width: 1920
    readonly property int height: 1080

    property string relativeFontDirectory: "fonts"

    /* Edit this comment to add your custom font */
    readonly property font font: Qt.font({
                                             family: Qt.application.font.family,
                                             pixelSize: Qt.application.font.pixelSize
                                         })
    readonly property font largeFont: Qt.font({
                                                  family: Qt.application.font.family,
                                                  pixelSize: Qt.application.font.pixelSize * 1.6
                                              })

    readonly property color backgroundColor: "#EAEAEA"
    readonly property color textColor: "#EAEAEA"
    readonly property color controlColor: "#6a6a6a"
    readonly property color controlDarkColor: "#353637"
    readonly property color controlLightColor: "#e4e4e4"
    readonly property color controlBgColor: "#212121"
    readonly property color controlBorderColor: "#000000"
    readonly property color controlBorderLightColor: "#FFFFFF"

    property StudioApplication application: StudioApplication {
        fontPath: Qt.resolvedUrl("../FresnelDemoContent/" + relativeFontDirectory)
    }
}
