/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Design Studio Material Bundle.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick
import QtQuick3D

CustomMaterial {
    id: satin
    property real opacity: 1
    property real vcoloron: 1
    property color secondaryColor: "white"
    property color subsurfaceColor: "white"
    property real metalness: 0
    property color baseColor: "#333333"
    property real clearcoat: 0
    property real specular: 0.5
    property real density: 0.0
    property real sssDistortion: 1
    property real sssScale: 0.5
    property real sssPower: 1
    property real roughness: 0.5
    property TextureInput noiseNormal: flaketexture

    cullMode: Material.NoCulling
    fragmentShader: Qt.resolvedUrl("shaders/satin.frag")
    vertexShader: Qt.resolvedUrl("shaders/satin.vert")
    depthDrawMode: Material.AlwaysDepthDraw
    objectName: "Fabric, Satin"

    TextureInput {
        id: flaketexture
        texture: noiseMap
        enabled: true
    }

    Texture {
        id: noiseMap
        source: "images/LDR_RGB1_3.png"
        mipFilter: Texture.Linear
        magFilter: Texture.Linear
        scaleV: 1
        generateMipmaps: true
        scaleU: 1
        minFilter: Texture.Linear
    }
}
