import QtQuick
import QtQuick3D
Node {
    id: rootNode
    property bool detected: false
	property bool night: false

    AdasBase {
        id: adasBase
        visible: true
        dayColor: "#08b526"
        night: rootNode.night
    }
    states: [
        State {
            name: "yes"
            when: detected == true

            PropertyChanges {
                target: adasBase
                opacity: 1
            }


        },
        State {
            name: "no"
            when: detected == false


            PropertyChanges {
                target: adasBase
                opacity: 0
            }


        }
    ]
    transitions: Transition {
                    NumberAnimation {
                        properties: "opacity"
                        easing.type: Easing.InOutQuad
                        duration: 2000
                    }
                }
}
