/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Helpers
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0
import Generated.QtQuick3D.Cluster 1.0
import QtQuick3D.Particles3D 6.2
import Generated.QtQuick3D.Gaugelines 1.0
import Generated.QtQuick3D.AdasPlane 1.0
import Generated.QtQuick3D.Car_Optimized_2 1.0
import Generated.QtQuick3D.Desert_Enviroment 1.0
import Generated.QtQuick3D.Car 1.0
import Generated.QtQuick3D.Demo_City_Buildings 1.0
import Generated.QtQuick3D.Demo_City_Ground 1.0
import Generated.QtQuick3D.AdasPlane2 1.0

Image {

    property real stateValue: 50
    visible: true
    property bool nightmode: globalNightMode
    id: safety
    //onStateValueChanged: console.log(stateValue)
    //    source: "../images/ADAS_72-3_n.png"
    states: [
        State {
            name: "safety1"
            when: stateValue >= 1 && stateValue <= 20

            PropertyChanges {
                target: safety
                visible: true
                source: nightmode ? "../images/ADAS_72-3_day.png" : "../images/ADAS_72-3_n.png"
            }
        },
        State {
            name: "safety2"
            when: stateValue >= 21 && stateValue <= 50

            PropertyChanges {
                target: safety
                visible: true
                source: nightmode ? "../images/ADAS_72_day.png" : "../images/ADAS_72_n.png"
            }
        },
        State {
            name: "safety3"
            when: stateValue >= 51 && stateValue <= 80

            PropertyChanges {
                target: safety
                visible: true
                source: nightmode ? "../images/ADAS_72-1_day.png" : "../images/ADAS_72-1_n.png"
            }
        },
        State {
            name: "safety4"
            when: stateValue >= 81 && stateValue <= 90
            PropertyChanges {
                target: safety
                visible: true
                source: nightmode ? "../images/ADAS_72-2_day.png" : "../images/ADAS_72-2_n.png"
            }
        }
    ]
    fillMode: Image.PreserveAspectFit
}
/*##^##
Designer {
    D{i:0;autoSize:true;formeditorZoom:0.9;height:480;width:640}
}
##^##*/

