

/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick3D.Helpers
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick 2.15
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0
import Generated.QtQuick3D.Cluster 1.0
import QtQuick3D.Particles3D 6.2

import Generated.QtQuick3D.Gaugelines 1.0
import Generated.QtQuick3D.AdasPlane 1.0
import Generated.QtQuick3D.Car_Optimized_2 1.0
import Generated.QtQuick3D.Desert_Enviroment 1.0
import Generated.QtQuick3D.Car 1.0
import Generated.QtQuick3D.Demo_City_Buildings 1.0
import Generated.QtQuick3D.Demo_City_Ground 1.0
import Generated.QtQuick3D.AdasPlane2 1.0
import Generated.QtQuick3D.PlaneBend3 1.0

Item {
    id: mainScreen
    width: Constants.width
    height: Constants.height
    property alias car_Optimized_2: car_Optimized_2
    property alias planeBend3Transparency: planeBend3.transparency

    property var effectList: []
    property real globalMaxspeed: 240
    property real globalOdometer: 17321
    property real globalDrivespeed: 120
    property bool globalNightMode: checkNightDay.checked
    property real globalCruisespeed: 90
    property bool globalBluetooth: false
    property real globalBattery: (chargeSlider.value * 100).toFixed()
    property real globalMetersPerSecond: globalDrivespeed * 0.28
    property real globalMaxdistance: 164 //(375 / 100) * globalBattery
    property bool globalAssist: checkAssist.checked
    property bool globalAutopilot: checkAutopilot.checked
    property bool globalCruise: checkCruise.checked
    property real globalDistanceremaining: clock.newdistanceremaining.toFixed()
    property bool globalSportmode: false
    property bool globalCitymode: checkCity.checked
    property real globalCurrentlane: 1
    property bool globalLeftturnsignal: false
    property bool globalRightturnsignal: false
    property bool globalLKASmode: false
    property bool globalCardetected: carpositioner.newcarposition === carpositioner.lane2position
                                     && othercarOffset < 30
                                     && othercarOffset > -50
    property bool showUpBar: true
    property bool showNavigator: true
    property bool showPanel: true
    property bool showNavigatorBlur: true
    property alias showHeadLights: lightSpot.visible
    property alias fakeReflections: lanes.fakeReflections
    property alias blockLaneChange: carpositioner.turning
    property alias debugViewEnabled: debugView.visible
    property alias albumArtSource: outsidemask.albumArtSource
    property alias albumSongText: outsidemask.albumSongText
    property alias albumArtistText: outsidemask.albumArtistText
    property alias albumPlaying: outsidemask.albumPlaying
    property alias currentTemperature: upperbar.temperature
    property alias currentWeather: upperbar.weatherIconIdx
    property alias currentTime: upperbar.currentTime
    property alias driverName: upperbar.name
    property alias networkQuality: upperbar.networkQuality
    property bool preventTransitionPause: true
    property bool overtaking: false
    property bool overtakeFinished: true
    property bool rightAnimation: false
    property bool leftAnimation: false
    property bool centerAnimation: false
    property real lanepos: 0
    property real othercarOffset: 20

    property real tempDrivespeed: 120

    Item {
        id: laneChangeAnim
        NumberAnimation {
            id: toright
            target: mainScreen
            onStarted: centerAnimation = true
            running: rightAnimation
            property: "lanepos"
            from: 0
            to: 2
            duration: 1000
            easing.type: Easing.InOutQuad
            onFinished: rightAnimation = false
        }
        NumberAnimation {
            id: toleft
            target: mainScreen
            onStarted: centerAnimation = true
            running: leftAnimation
            property: "lanepos"
            to: -2
            duration: 1000
            easing.type: Easing.InOutQuad
            onFinished: leftAnimation = false
        }
        SequentialAnimation {
            id: tocenter
            running: centerAnimation
            onFinished: centerAnimation = false
            PauseAnimation {
                duration: 3000
            }
            NumberAnimation {
                id: backCenter
                target: mainScreen
                property: "lanepos"
                to: 0
                duration: 2000
                easing.type: Easing.InOutQuad
            }
        }
    }
    Item {
        id: overtakeAnimation

        SequentialAnimation {
            id: speedUp
            running: overtaking

            PauseAnimation {
                duration: 3000
            }
            NumberAnimation {
                id: carBack
                target: mainScreen
                property: "othercarOffset"
                to: 800
                duration: 6000
                easing.type: Easing.InOutQuad
                onFinished: overtaking = false
            }
        }
        SequentialAnimation {
            id: carFront
            running: !overtakeFinished
            NumberAnimation {
                target: mainScreen
                property: "othercarOffset"
                to: -450
                duration: 1
                easing.type: Easing.InOutQuad
            }
            NumberAnimation {
                target: mainScreen
                property: "othercarOffset"
                to: 20
                duration: 6000
                easing.type: Easing.InOutQuad
                onFinished: overtakeFinished = true
            }
        }
    }

    CarPositioner {
        id: carpositioner
        lane1position: -30
        lane2position: 0
        lane3position: 30
        newcarposition: 0
        desiredposition: globalCurrentlane
        turning: false
    }

    property alias carpositionAlias: otherCarpositionSlider.value

    Clock {
        id: clock
        distanceremaining: 90
        meterspersecond: globalMetersPerSecond
        drivespeed: globalDrivespeed
        currentTime: upperbar.currentTime
    }

    NightAndDayData {
        id: nightanddaydata
        skycolor: daycolor
        daycolor: "#E5BAFF"
        nightcolor: "#BE88FC"
        night: globalNightMode
    }
    SequentialAnimation {
        id: laneSequence
        property real timer: 0
        running: carpositioner.turning
        onStarted: state = "lanechange"
        onStopped: state = "drive"

        NumberAnimation {
            target: laneSequence
            onStarted: state = "lanechange"
            property: "timer"
            from: 0
            to: 50
            duration: 8000
            easing.type: Easing.InOutQuad
        }
        NumberAnimation {
            target: laneSequence
            property: "timer"
            from: 50
            to: 0
            duration: 1000
            easing.type: Easing.InOutQuad
        }
    }


    /*
    // TODO: We are getting wrong values after transitions, so replacing this logic now with
    // hard-coded calculated safety distances
    ScreenPositioner {
        id: screenPositioner
        pos: car.position //Qt.vector3d(0, -23.437, otherCarpositionSlider.value + 20)
        scene: view3D1
    }
    */
    View3D {
        id: view3D1
        anchors.fill: parent
        layer.mipmap: true
        layer.smooth: true
        // TODO: We are getting wrong values after transitions, so replacing this logic now with
        // hard-coded calculated safety distances
        //property vector3d screenPos: screenPositioner.output
        // Only enable layering if needed
        layer.enabled: effectList.length > 0
        environment: sceneEnvironment1
        camera: camera1
        SceneEnvironment {
            id: sceneEnvironment1
            lightProbe: environment_day
            backgroundMode: SceneEnvironment.SkyBox
            clearColor: nightanddaydata.skycolor
            probeOrientation.y: 0
            probeOrientation.z: 0
            probeExposure: 0.1
            aoSampleRate: 3
            temporalAAStrength: 2
            probeOrientation.x: 0
            probeHorizon: 0
            aoDither: false
            tonemapMode: SceneEnvironment.TonemapModeHejlDawson
            depthPrePassEnabled: false
            depthTestEnabled: true
            temporalAAEnabled: false
            aoStrength: 0
            antialiasingMode: SceneEnvironment.SSAA
            antialiasingQuality: SceneEnvironment.Medium
            effects: [effectList]

            NumberAnimation {
                id: todinght
                target: sceneEnvironment1
                running: globalNightMode
                property: "probeExposure"
                duration: 1000
                easing.type: Easing.InOutQuad
                from: 1
                to: 0.5
            }
            NumberAnimation {
                id: today
                target: sceneEnvironment1
                running: !globalNightMode
                property: "probeExposure"
                duration: 1000
                easing.type: Easing.InOutQuad
                from: 0.5
                to: 1.3
            }
            GaussianBlur {
                id: gaussianBlur
                amount: 0
                Connections {
                    property int previousAmount: 0
                    target: gaussianBlur
                    onAmountChanged: {
                        if (previousAmount !== 6 && gaussianBlur.amount === 0) {
                            mainScreen.effectList.splice(
                                        mainScreen.effectList.indexOf(
                                            gaussianBlur), 1)
                            sceneEnvironment1.effects = mainScreen.effectList
                        } else if (previousAmount === 0
                                   && gaussianBlur.amount > 0) {
                            if (effectList.indexOf(gaussianBlur) === -1) {
                                effectList.push(gaussianBlur)
                                sceneEnvironment1.effects = mainScreen.effectList
                            }
                        }
                        previousAmount = gaussianBlur.amount
                    }
                }
            }

            Texture {
                id: environment_day
                source: globalNightMode ? "../images/hdri/environment_night.hdr" : "../images/hdri/environment_day.hdr"
                generateMipmaps: true
                mappingMode: Texture.Environment
            }
        }

        Node {
            id: scene1

            // Shared specular reflections texture
            PerspectiveCamera {
                id: camera1
                x: 70.007
                y: 6.737
                clipFar: 7000
                frustumCullingEnabled: true
                eulerRotation.z: 1.55993
                eulerRotation.y: 23.70502
                eulerRotation.x: -5.36566
                fieldOfView: 15
                z: 465.30408
            }

            Warp {
                id: warp
                x: 21.291
                y: -45.301
                opacity: 0
                z: 5.77642
                visible: false
            }

            PlaneBend3 {
                id: planeBend3
                x: car_Optimized_2.x
                y: -22.977
                visible: othercarOffset < 400
                on: carpositioner.turning
                lane: lanepos
                scale.z: 15
                scale.y: 15
                scale.x: 15
                z: 140.21338
                eulerRotation.y: -90
                end: -8 + car.z / 15
            }

            Hyperdrive {
                id: hyperdrive
                opacity: 0
                eulerRotation.y: 180
                visible: false
            }

            AdasPlane {
                id: adasPlane
                y: -23.396
                detected: globalCardetected
                night: globalNightMode
                opacity: 1 - planeBend3Transparency
                visible: mainScreen.state != "chargeUp"
                         && mainScreen.state != "chargeSide"
                         && mainScreen.state != "chargeBehind" && globalLKASmode
                         && globalCardetected

                scale.z: 13 - (otherCarpositionSlider.value / 18)
                scale.y: 1
                scale.x: 0.14
                z: 241.68599
            }

            Lanes {
                id: lanes
                y: -23.599
                lkas: globalLKASmode
                stateTo: globalCurrentlane
                night: globalNightMode
                scale.x: 0.15
                z: 751.72852
                eulerRotation.y: 180
                fakeReflections: mainScreen.fakeReflections
            }

            Car_Optimized_2 {
                id: car_Optimized_fakeReflection
                x: carpositioner.newcarposition
                visible: mainScreen.fakeReflections
                scale.z: 0.1
                scale.y: 0.1
                scale.x: 0.1
                batteryCharge: -0.8 + (1.9 * (globalBattery / 100))
                z: 273.35999
                y: -23.811
                opacity: 1
                eulerRotation.x: 180
                nightmode: globalNightMode
                animationScale: 1
                eulerRotation.y: 0

                LightSpot {
                    id: lightSpot
                    x: 9.062
                    y: -25.793
                    visible: true
                    z: 206.47559
                    brightness: 0
                }

                Reflection_blocker {
                    id: reflection_blocker
                    x: 0
                    y: -4.516
                    opacity: 0
                    z: -281.58521
                }
            }

            LightDirectional {
                id: lightDirectional
                color: "#ffffff"
                ambientColor: "#000000"
                castsShadow: false
                brightness: 10
                night: globalNightMode
            }

            Desert_Enviroment {
                id: desert_Enviroment
                x: 0
                y: -24
                opacity: 1
                currentsky: "#eae7e7"
                citymode: globalCitymode
                moving: 0
                bending: bendSlider.value
                night: globalNightMode
                scale.z: 0.04625
                scale.y: 0.04625
                scale.x: 0.05479
                z: 386.79001
                eulerRotation.y: 180
            }

            Car {
                id: car
                x: -0
                y: -23.437
                charge: true
                tireRotation: 360
                batteryCharge: -0.8 + (1.9 * (globalBattery / 100))
                z: otherCarpositionSlider.value + othercarOffset
                scale.z: 0.16
                scale.y: 0.16
                scale.x: 0.16

                Car {
                    id: car_fakeReflection
                    x: -0
                    y: -1.794
                    visible: mainScreen.fakeReflections
                    eulerRotation.y: 180
                    eulerRotation.z: 0
                    nightmode: globalNightMode
                    eulerRotation.x: 180
                    z: 0.87875
                }
            }
        }
    }

    View3D {
        id: bloom
        anchors.fill: parent
        layer.mipmap: true
        z: 0
        camera: camera1
        SceneEnvironment {
            id: sceneEnvironment2
            effects: [hDRBloomTonemap]
            probeExposure: 1
            tonemapMode: SceneEnvironment.TonemapModeHejlDawson
            antialiasingQuality: SceneEnvironment.Medium
            antialiasingMode: SceneEnvironment.SSAA

            Texture {
                id: car_day_hdr
                source: "../images/hdri/car_day_hdr.hdr"
                mappingMode: Texture.LightProbe
            }

            HDRBloomTonemap {
                id: hDRBloomTonemap
                bloomThreshold: 0.8
            }
        }

        Node {
            id: scene2

            Car_Optimized_2 {
                id: car_Optimized_2
                x: carpositioner.newcarposition
                y: -23.679
                batteryCharge: -0.8 + (1.9 * (globalBattery / 100))
                animationScale: 1
                nightmode: globalNightMode
                z: 273.36118
                scale.z: 0.1
                scale.y: 0.1
                scale.x: 0.1
                eulerRotation.y: 180 + carpositioner.carRotation * 6
            }

            PerspectiveCamera {
                id: cameraPerspective
                opacity: 0
                z: 500
            }

            DirectionalLight {
                id: lightDirectional1
                visible: true
            }
        }
        environment: sceneEnvironment2
    }

    View3D {
        id: view3D
        anchors.fill: parent
        layer.mipmap: true
        environment: sceneEnvironment

        SceneEnvironment {
            id: sceneEnvironment
            lightProbe: car_day_hdr
            probeExposure: 2
            clearColor: "#498ab8"
            backgroundMode: SceneEnvironment.Transparent
            antialiasingMode: SceneEnvironment.SSAA
            antialiasingQuality: SceneEnvironment.Medium
        }

        Node {
            id: scene

            PerspectiveCamera {
                id: camera
                frustumCullingEnabled: true
                clipFar: 100000
                fieldOfView: 9
                z: 3198.06006
            }

            Cluster {
                id: cluster
                y: 82.087
                visible: true
                nightmode: globalNightMode
                speed: globalDrivespeed * 2
                z: -1436.58154
                scale.z: 1
                scale.y: 101.60172
                scale.x: 98.19506
            }

            Gaugelight {
                id: gaugelight
                x: -0
                y: 0
                color: "#caaff3"
                constantFade: 0.5
                linearFade: 0.5
                scope: cluster
                brightness: 2
                z: -850.06567
                anim: globalDrivespeed * 2
            }
        }
    }

    Chargingmenu4 {
        id: chargingmenu4
        opacity: 0
        charge: globalBattery
    }

    Chargingmenuside {
        id: chargingmenuside
        opacity: 0
    }

    Navigation {
        id: navigation
        property string dTime: (globalDrivespeed > 20) ? Math.floor(
                                                             globalDistanceremaining
                                                             / (globalDrivespeed / 60)) : "--"
        x: 0
        y: 112
        layer.mipmap: true
        smooth: false
        show: showNavigator
        night: globalNightMode
        timeofarrival: clock.arrivaltime
        drivingtime: dTime
        distanceremaining: globalDistanceremaining
        roadName: "Grand road avenue"
        distanceToTurn: "1.5"

        // This item creates blur behind the navigation bar
        Item {
            // Size to match the navigator top bar size
            width: blurMask.width
            height: blurMask.height
            x: navigation.bar1X
            z: -1
            visible: showNavigatorBlur
            ShaderEffectSource {
                id: view3DNavibarSource
                anchors.fill: parent
                mipmap: true
                sourceRect: Qt.rect(navigation.x + navigation.bar1X,
                                    navigation.y, blurMask.width,
                                    blurMask.height)
                sourceItem: view3D1
                visible: false
                live: showNavigatorBlur
                // Reduce the texture size for better performance
                textureSize: Qt.size(width / 4, height / 4)
            }
            FastBlurEffect {
                id: blurredNavigatorBackground
                anchors.fill: view3DNavibarSource
                source: view3DNavibarSource
                layer.mipmap: true
                smooth: false
                cached: true
                radius: 64
                visible: false
            }
            Image {
                id: blurMask
                source: "../images/Basis.png"
                mipmap: true
                smooth: false
                visible: false
            }
            OpacityMaskEffect {
                anchors.fill: blurMask
                source: blurredNavigatorBackground
                cached: true
                smooth: false
                maskSource: blurMask
            }
        }
    }

    NavigationSport {
        id: navigationSport
        x: 610
        y: 32
        opacity: 0
        visible: true
        smooth: false
        _0859Text: clock.arrivaltime
        _47minText: navigation.dTime + " min"
        _91kmText: globalDistanceremaining + "km"
        show: showNavigator
        night: globalNightMode
    }

    MySafetyDistance {
        id: safetyDistance
        x: 610 + (y + 100) * 1.67
        y: (287.06 + (dist - 20) * 1.058857)

        // TODO: We are getting wrong values after transitions, so replacing this logic now with
        // hard-coded calculated safety distances
        //y: view3D1.screenPos.y - 100
        opacity: 0
        visible: mainScreen.state != "chargeUp"
                 && mainScreen.state != "chargeSide"
                 && mainScreen.state != "chargeBehind"
                 && mainScreen.state != "base state"
        layer.mipmap: true
        smooth: false
        dist: otherCarpositionSlider.value
    }

    Outsidemask {
        id: outsidemask
        lkasValue: otherCarpositionSlider.value
        show: showPanel
        lask: globalLKASmode
        turnR: globalRightturnsignal
        turnL: globalLeftturnsignal
        z: 10
        speed: globalCruisespeed
        odometer: globalOdometer
        maxdistance: globalMaxdistance
        battery: globalBattery

        DebugView {
            id: debugView
            anchors.top: outsidemask.top
            anchors.left: outsidemask.left
            visible: false
            source: view3D1
        }
    }

    Upperbar {
        id: upperbar
        x: 635
        y: 0
        layer.mipmap: true
        smooth: false
        z: 16
        show: showUpBar
        currentTime: "12:00"
        temperature: 22
        name: "Anthony"
    }

    Item {
        id: controls
        anchors.fill: parent
        visible: controlCheck.checked
        z: 11

        Button {
            id: warpbutton
            x: 846
            y: 662
            visible: false
            text: qsTr("Warp")
        }

        Button {
            id: drivebutton
            x: 928
            y: 662
            visible: false
            text: qsTr("Drive")
        }

        Button {
            id: sportbutton
            x: 17
            y: 98
            text: qsTr("Sport")

            Connections {
                target: sportbutton
                onClicked: {
                    globalSportmode = true
                    mainScreen.state = "Sport"
                }
            }
        }

        Button {
            id: adasbutton
            x: 1074
            y: 662
            visible: false
            text: qsTr("Adas")
        }

        Button {
            id: chargebutton
            x: 763
            y: 662
            visible: false
            text: qsTr("Charge")
        }

        Slider {
            id: bendSlider
            x: 573
            y: 690
            width: 721
            height: 22
            visible: false
            to: 1
            from: -1
            value: 0
        }

        Slider {
            id: heightSlider
            x: -297
            y: 350
            width: 650
            height: 22
            visible: false
            rotation: 90
            value: 0
            to: 1000
            from: -1000
        }

        Slider {
            id: chargeSlider
            x: 15
            y: 134
            visible: true
            value: 0.5
        }

        Slider {
            id: hillSlider
            x: 252
            y: 690
            width: 240
            height: 22
            visible: false
            to: -0.0001
            from: 0.0001
            value: 0
        }

        Slider {
            id: moveSlider
            x: 1561
            y: 356
            width: 650
            height: 22
            visible: false
            value: 0
            rotation: 90
            to: 50000
            from: 0
        }

        Text {
            id: text2
            x: 606
            y: 184
            visible: false
            text: qsTr("Text")
            font.pixelSize: 12
        }

        CheckBox {
            id: checkAutopilot
            x: 50
            y: 700
            width: 20
            height: 20
            visible: false
            text: qsTr(" ")
        }

        CheckBox {
            id: checkAssist
            x: 130
            y: 700
            width: 20
            height: 20
            visible: false
            text: qsTr(" ")
        }

        CheckBox {
            id: checkCruise
            x: 220
            y: 700
            width: 20
            height: 20
            visible: false
            text: qsTr(" ")
        }

        Slider {
            id: otherCarpositionSlider
            x: 1786
            y: 165
            width: 200
            height: 22
            to: 20
            from: 90
            rotation: 90
            value: 0
        }

        Button {
            id: adas2button

            x: 72
            y: 98
            text: qsTr("Adas2")

            Connections {
                target: adas2button
                onClicked: {
                    globalSportmode = false
                    mainScreen.state = "Adas2"
                }
            }
        }

        Button {
            id: adas1button

            x: 120
            y: 98
            text: qsTr("Adas1")

            Connections {
                target: adas1button
                onClicked: {
                    globalSportmode = false
                    mainScreen.state = "Adas1"
                }
            }
        }

        CheckBox {
            id: checkNightDay
            x: 14
            y: 45
            text: qsTr("Night&Day")
        }

        CheckBox {
            id: checkCity
            x: 14
            y: 67
            text: qsTr("City")
            checked: false
        }

        Button {
            id: driveButton
            x: 120
            y: 128
            width: 40
            height: 24
            text: qsTr("drive")
            Connections {
                target: driveButton
                onClicked: {
                    globalSportmode = false
                    mainScreen.state = "drive"
                }
            }
        }

        Slider {
            id: carPositionSlider
            x: 15
            y: 172
            visible: true
            snapMode: RangeSlider.SnapAlways
            stepSize: 1
            to: 2
            from: 0
            value: globalCurrentlane
            onValueChanged: globalCurrentlane = value.toFixed()
        }
    }

    DigitalSpeedComponent {
        id: digitalSpeedComponent
        x: 85
        y: 285
        smooth: false
        sport: globalSportmode
        speed: mainScreen.state == "chargeBehind"
               || mainScreen.state == "chargeUp"
               || mainScreen.state == "chargeSide" ? 0.0 : globalDrivespeed
        night: globalNightMode
    }

    Welcome {
        id: welcome
        x: 0
        y: 0
        opacity: 1
        visible: false
        z: 20
    }

    // Rectangle to hide the bottom parts
    Rectangle {
        id: rectangle1
        x: 0
        y: 717
        width: 1920
        height: 300
        color: "#000000"
        z: 30
    }

    CheckBox {
        id: controlCheck
        x: 15
        y: 15
        width: 20
        height: 20
        opacity: (globalBluetooth == true) ? 1.0 : 0.5
        text: qsTr(" ")
        z: 14
        checked: false
        visible: false
    }

    Item {
        id: __materialLibrary__
    }

    states: [

        State {
            name: "Sport"

            PropertyChanges {
                target: cluster
                x: 0
                y: 82.087
                nightmode: globalNightMode
                z: -1528
                speed: globalDrivespeed * 2
                scale.z: 100
            }

            PropertyChanges {
                target: camera1
                x: 0
                y: 0
                fieldOfView: 45
                eulerRotation.z: 0
                eulerRotation.y: 45
                z: 0
                eulerRotation.x: 0
            }

            PropertyChanges {
                target: gaussianBlur
                amount: 0
            }

            PropertyChanges {
                target: warp
                opacity: 0
            }

            PropertyChanges {
                target: gaugelight
                x: -2057.486
                y: -254.336
                color: "#bed1fd"
                z: -4184.62646
                anim: globalDrivespeed * 2
                linearFade: 0.5
                constantFade: 0.5
                castsShadow: false
                ambientColor: "#000000"
                quadraticFade: 0
                brightness: 4
            }

            PropertyChanges {
                target: camera
                x: 0.001
                y: 0.001
                z: 3198.05518
                fieldOfView: 25
            }

            PropertyChanges {
                target: checkCruise
                visible: false
            }

            PropertyChanges {
                target: checkAssist
                visible: false
            }

            PropertyChanges {
                target: checkAutopilot
                visible: false
            }

            PropertyChanges {
                target: text2
                visible: false
            }

            PropertyChanges {
                target: moveSlider
                visible: false
            }

            PropertyChanges {
                target: hillSlider
                visible: false
            }

            PropertyChanges {
                target: chargeSlider
                visible: true
            }

            PropertyChanges {
                target: heightSlider
                visible: false
            }

            PropertyChanges {
                target: chargebutton
                visible: false
            }

            PropertyChanges {
                target: adasbutton
                visible: false
            }

            PropertyChanges {
                target: drivebutton
                visible: false
            }

            PropertyChanges {
                target: warpbutton
                visible: false
            }

            PropertyChanges {
                target: bendSlider
                visible: false
            }

            PropertyChanges {
                target: navigation
                opacity: 0
                visible: false
            }

            PropertyChanges {
                target: digitalSpeedComponent
                x: 710
                y: 282
                opacity: 1
            }

            PropertyChanges {
                target: lightDirectional
                eulerRotation.z: -86.52389
                eulerRotation.x: -43.5923
                eulerRotation.y: -166.47374
            }

            PropertyChanges {
                target: outsidemask
                selfdrivingText: "Immersive"
            }

            PropertyChanges {
                target: navigationSport
                opacity: 1
                visible: true
            }

            PropertyChanges {
                target: sceneEnvironment
                probeExposure: 2
            }

            PropertyChanges {
                target: lightSpot
                visible: false
            }

            PropertyChanges {
                target: lanes
                y: -23.6
            }

            PropertyChanges {
                target: view3D
                opacity: 1
            }

            PropertyChanges {
                target: bloom
                opacity: 0
            }
        },
        State {
            name: "Adas2"

            PropertyChanges {
                target: camera1
                x: -0
                y: -0.6
                clipFar: 3000
                z: 314.75
                fieldOfView: 17
                eulerRotation.z: -0
                eulerRotation.y: 0
                eulerRotation.x: -3.87773
            }

            PropertyChanges {
                target: gaugelight
                quadraticFade: 8.33
                brightness: 0
            }

            PropertyChanges {
                target: navigation
                opacity: 0
            }

            PropertyChanges {
                target: adasPlane
                visible: true
                detected: globalCardetected
            }

            PropertyChanges {
                target: safetyDistance
                x: 1256
                y: 287
                opacity: 1
                dist: otherCarpositionSlider.value
            }

            PropertyChanges {
                target: desert_Enviroment
                y: -24
                z: 386.79001
            }

            PropertyChanges {
                target: sceneEnvironment1
                backgroundMode: SceneEnvironment.SkyBox
            }

            PropertyChanges {
                target: lightDirectional
                ambientColor: "#000000"
            }

            PropertyChanges {
                target: outsidemask
                lkasValue: otherCarpositionSlider.value
            }
        },
        State {
            name: "Adas1"

            PropertyChanges {
                target: gaugelight
                quadraticFade: 8.33
                brightness: 0
            }

            PropertyChanges {
                target: camera1
                clipFar: 8000
            }

            PropertyChanges {
                target: desert_Enviroment
                y: -24
            }

            PropertyChanges {
                target: speedUp
                running: overtaking
            }

            PropertyChanges {
                target: sceneEnvironment1
                probeOrientation.x: 0
            }

            PropertyChanges {
                target: lanes
                y: -23.6
            }

            PropertyChanges {
                target: lightDirectional
                color: "#ffffff"
                ambientColor: "#000000"
                eulerRotation.x: -35
            }
        },
        State {
            name: "Intro"

            PropertyChanges {
                target: navigation
                opacity: 0
            }

            PropertyChanges {
                target: outsidemask
                opacity: 0
            }

            PropertyChanges {
                target: upperbar
                opacity: 0
            }

            PropertyChanges {
                target: digitalSpeedComponent
                opacity: 0
            }

            PropertyChanges {
                target: welcome
                width: 1920
                height: 720
            }

            PropertyChanges {
                target: desert_Enviroment
                y: -24
            }
        },
        State {
            name: "drive"

            PropertyChanges {
                target: camera1
                x: -156.31
                y: 96.523
                fieldOfView: 25
                eulerRotation.z: 3.28231
                eulerRotation.x: -19.64538
                z: 539.23517
                eulerRotation.y: -18.37359
            }

            PropertyChanges {
                target: outsidemask
                selfdrivingText: "ADAS"
            }

            PropertyChanges {
                target: carpositioner
                lane3position: 30
                lane1position: -30
            }

            PropertyChanges {
                target: car_Optimized_2
                visible: true
            }

            PropertyChanges {
                target: desert_Enviroment
                y: -24
            }

            PropertyChanges {
                target: lanes
                y: -23.6
            }

            PropertyChanges {
                target: lightDirectional
                ambientColor: "#000000"
            }
        },
        State {
            name: "lanechange"
            when: carpositioner.turning
            PropertyChanges {
                target: camera1
                x: 0
                y: 104.678
                eulerRotation.y: 0
                z: 584.06598
                eulerRotation.x: -19.27711
                eulerRotation.z: -0
                fieldOfView: 25
            }

            PropertyChanges {
                target: outsidemask
                selfdrivingText: "ADAS"
            }

            PropertyChanges {
                target: desert_Enviroment
                night: globalNightMode
            }

            PropertyChanges {
                target: lanes
                x: 0
                y: -23.599
                z: 859.76721
            }

            PropertyChanges {
                target: lightDirectional
                ambientColor: "#000000"
            }
        },
        State {
            name: "chargeBehind"
            PropertyChanges {
                target: camera1
                x: 0
                y: -11
                eulerRotation.x: -4.16706
                eulerRotation.z: -0
                z: 353.92001
                eulerRotation.y: 0
                fieldOfView: 25
            }

            PropertyChanges {
                target: navigation
                opacity: 0
            }

            PropertyChanges {
                target: desert_Enviroment
                x: 0
                y: -24
                opacity: 0.005
                visible: true
            }

            PropertyChanges {
                target: car
                opacity: 0
            }

            PropertyChanges {
                target: lanes
                y: -23.6
                opacity: 0
                visible: true
            }

            PropertyChanges {
                target: outsidemask
                autonomousVisible: false
                accVisible: false
                lask: false
                gear: "P"
                selfdrivingText: "Charging"
            }

            PropertyChanges {
                target: sceneEnvironment1
                probeOrientation.x: 0
            }

            PropertyChanges {
                target: lightSpot
                opacity: 0
                visible: false
            }

            PropertyChanges {
                target: lightDirectional
                visible: true
                color: "#ffffff"
                ambientColor: "#000000"
                brightness: 2
                eulerRotation.z: 0
                eulerRotation.y: 0
                eulerRotation.x: -90
            }

            PropertyChanges {
                target: nightanddaydata
                visible: true
                daycolor: "#e8d2f0"
                nightcolor: "#5d1cc2"
            }

            PropertyChanges {
                target: reflection_blocker
                x: 0
                y: -0.684
                opacity: 1
                z: -189.52
                scale.y: 15.01
                scale.x: 4.51438
            }

            PropertyChanges {
                target: car_Optimized_fakeReflection
                opacity: 0
            }
        },
        State {
            name: "chargeUp"
            PropertyChanges {
                target: camera1
                x: 0
                y: 27
                eulerRotation.x: -27.45014
                eulerRotation.z: -0
                z: 366.79544
                eulerRotation.y: 0
                fieldOfView: 25
            }

            PropertyChanges {
                target: navigation
                opacity: 0
            }

            PropertyChanges {
                target: desert_Enviroment
                opacity: 0.005
                visible: true
            }

            PropertyChanges {
                target: car
                opacity: 0
            }

            PropertyChanges {
                target: lanes
                opacity: 0
            }

            PropertyChanges {
                target: chargingmenu4
                opacity: 1
            }

            PropertyChanges {
                target: car_Optimized_2
                charge: true
            }

            PropertyChanges {
                target: digitalSpeedComponent
                opacity: 0
                visible: false
            }

            PropertyChanges {
                target: lightDirectional
                color: "#ffffff"
                ambientColor: "#000000"
                eulerRotation.z: 0
                eulerRotation.y: -0
                eulerRotation.x: -90
                brightness: 2
            }

            PropertyChanges {
                target: outsidemask
                autonomousVisible: false
                accVisible: false
                gear: "P"
                selfdrivingText: "Charging"
            }

            PropertyChanges {
                target: lightSpot
                opacity: 0
                visible: false
            }

            PropertyChanges {
                target: nightanddaydata
                visible: true
                nightcolor: "#5d1cc2"
            }

            PropertyChanges {
                target: lightDirectional1
                visible: true
                brightness: 1
                eulerRotation.z: -0.00008
                eulerRotation.y: 0.00008
                eulerRotation.x: -83.11522
            }

            PropertyChanges {
                target: car_Optimized_fakeReflection
                y: -23.68
                opacity: 0
                charge: false
                eulerRotation.y: 0
            }

            PropertyChanges {
                target: reflection_blocker
                x: 0
                y: -0.68
                opacity: 1
                scale.x: 4.51
                z: -189.51807
            }
        },
        State {
            name: "chargeSide"
            PropertyChanges {
                target: camera1
                x: 65
                y: -16.41
                eulerRotation.x: 0
                eulerRotation.z: 0
                z: 298.48999
                eulerRotation.y: 90
                fieldOfView: 25
            }

            PropertyChanges {
                target: navigation
                opacity: 0
            }

            PropertyChanges {
                target: desert_Enviroment
                opacity: 0.005
                visible: true
            }

            PropertyChanges {
                target: car
                opacity: 0
            }

            PropertyChanges {
                target: lanes
                opacity: 0
                visible: false
            }

            PropertyChanges {
                target: chargingmenuside
                opacity: 1
            }

            PropertyChanges {
                target: outsidemask
                lask: false
                autonomousVisible: false
                accVisible: false
                gear: "P"
                selfdrivingText: "Charging"
            }

            PropertyChanges {
                target: car_Optimized_fakeReflection
                x: -0
                y: -23.68
                opacity: 0
                z: 273.35999
            }

            PropertyChanges {
                target: lightSpot
                opacity: 0
                visible: false
            }

            PropertyChanges {
                target: car_Optimized_2
                opacity: 1
                shadowX: 0
            }

            PropertyChanges {
                target: nightanddaydata
                visible: true
                nightcolor: "#5d1cc2"
            }

            PropertyChanges {
                target: lightDirectional
                color: "#ffffff"
                ambientColor: "#000000"
                brightness: 2
                eulerRotation.z: 0
                eulerRotation.y: 0
                eulerRotation.x: -90
            }

            PropertyChanges {
                target: reflection_blocker
                y: -0.68
                opacity: 1
                scale.x: 4.51
            }
        }
    ]
    transitions: [
        Transition {
            NumberAnimation {
                properties: "brightness,edgeStrength,alphaMultiply,transparency,clearColor,opacity,amount,fieldOfView,x,y,z,eulerRotation.y,eulerRotation.z,eulerRotation.x,scale.x,scale.y,scale.z"
                easing.type: Easing.InOutQuad
                duration: 2000
            }

            ColorAnimation {
                properties: "diffuseColor"
                easing.type: Easing.InOutQuad
                duration: 2000
            }
        }
    ]
}
/*##^##
Designer {
    D{i:0}D{i:27;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}D{i:51;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/

