/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick

Item {
    id: upperbar

    property bool show: true
    property string currentTime: ""
    property int temperature: 23
    property int weatherIconIdx: 1
    property alias name: nameText.text
    property alias networkQuality: iconsRow.networkBars
    // These animate the show/hide
    property real showAnimated: show
    property real showAnimated2: show

    readonly property var weatherImages: ["weather-sunny.png", "weather-partiallycloudy.png", "weather-cloudy.png", "weather-rainy.png", "weather-snow.png", "weather-stormy.png"]

    width: 650
    height: 48
    y: (1 - showAnimated) * -height * 2

    Behavior on showAnimated {
        NumberAnimation {
            duration: 800
            easing.type: Easing.InOutQuad
        }
    }
    Behavior on showAnimated2 {
        SequentialAnimation {
            PauseAnimation {
                duration: 400
            }
            NumberAnimation {
                duration: 400
                easing.type: Easing.InOutQuad
            }
        }
    }

    Image {
        id: background
        anchors.horizontalCenter: parent.horizontalCenter
        width: parent.width * 0.6 + showAnimated2 * parent.width * 0.4
        height: parent.height
        source: "../images/upperbar_background.png"
    }

    Item {
        id: content
        opacity: showAnimated2
        anchors.horizontalCenter: parent.horizontalCenter
        width: parent.width * 0.5 + showAnimated2 * parent.width * 0.5
        height: parent.height

        Text {
            id: timeText
            anchors.left: parent.left
            anchors.leftMargin: 50
            anchors.verticalCenter: parent.verticalCenter
            width: 80
            color: "#ffffff"
            text: currentTime
            font.pixelSize: 16
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.weight: Font.Normal
            font.family: "Open Sans"
        }

        Row {
            anchors.left: timeText.right
            anchors.leftMargin: 10
            anchors.verticalCenter: parent.verticalCenter
            spacing: 10
            Image {
                id: weatherIcon
                anchors.verticalCenter: parent.verticalCenter
                width: 28
                height: 25
                source: "../images/" + weatherImages[weatherIconIdx]
                fillMode: Image.PreserveAspectFit
            }
            Text {
                id: temperatureText
                anchors.verticalCenter: parent.verticalCenter
                color: "#ffffff"
                font.pixelSize: 16
                font.weight: Font.Normal
                font.family: "Open Sans"
                text: temperature + "°"
            }
        }

        Row {
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            spacing: 10
            Image {
                id: user1
                anchors.verticalCenter: parent.verticalCenter
                width: 23
                height: 23
                source: "../images/icon_user.png"
                fillMode: Image.PreserveAspectFit
            }
            Text {
                id: nameText
                anchors.verticalCenter: parent.verticalCenter
                color: "#ffffff"
                elide: Text.ElideRight
                width: 150
                font.pixelSize: 16
                font.weight: Font.Normal
                font.family: "Open Sans"
            }
        }

        Row {
            id: iconsRow
            property int networkBars: 3

            anchors.right: parent.right
            anchors.rightMargin: 50
            anchors.verticalCenter: parent.verticalCenter
            spacing: 20
            Image {
                anchors.verticalCenter: parent.verticalCenter
                source: "../images/icon_bt.png"
            }
            Image {
                anchors.verticalCenter: parent.verticalCenter
                source: "../images/icon_5g.png"
            }
            Image {
                anchors.verticalCenter: parent.verticalCenter
                source: "../images/icon_network_"  + iconsRow.networkBars + ".png"
            }
        }
    }
}
