VARYING vec3 vTexCoord;
VARYING vec3 vTexCoord2;
VARYING vec4 vColor;

VARYING vec3 worldPos;
VARYING vec3 localPos;

VARYING vec3 vTangent;
VARYING vec3 vBinormal;
VARYING mat3 vTBN;

vec2 rotate(vec2 v, float a) {

	float s = sin(a);

	float c = cos(a);

	mat2 m = mat2(c, -s, s, c);

	return m * v;

}

vec3 windN;

	
const float PI = 3.14159265359;

float Get2DNoise(float value1, float value2)
{
    vec2 uv = vec2(value1, value2);

    vec2 p = floor(uv);
    vec2 f = fract(uv);
    f = f * f * (3.0 - 2.0 * f); // Smoothstep interpolation

    float n = p.x + p.y * 57.0;
    return mix(mix(fract(sin(n) * 43758.5453), fract(sin(n + 1.0) * 43758.5453), f.x),
               mix(fract(sin(n + 57.0) * 43758.5453), fract(sin(n + 58.0) * 43758.5453), f.x), f.y);
}


// This wind force calculation follows NaughtyDog's presentation on the tech of Uncharted 4
// https://advances.realtimerendering.com/other/2016/naughty_dog/NaughtyDog_TechArt_Final.pdf

float unchartedWind(vec3 dir, vec3 pivotWS, float timeOffset, float noiseRes, float speed, float gust, float intensity){
	float noise = Get2DNoise(dot(dir,pivotWS)/noiseRes, time);
	float animation = sin(speed * time + timeOffset);
	return intensity * animation * noise + gust;
}

vec3 getTangent(vec3 normal)
{
    vec3 tangent = vec3(1.0, 0.0, 0.0);

    tangent -= normal * dot(normal, tangent);
    tangent = normalize(tangent);

    tangent = normalize(tangent - dot(tangent, normal) * normal);

    return tangent;
}

vec3 getBinormal(vec3 normal)
{
    // Get the tangent vector
    vec3 tangent = getTangent(normal);

    // Calculate the binormal vector
    vec3 binormal = cross(normal, tangent);

    return binormal;
}

void MAIN()
{
	vColor = COLOR;
	localPos = VERTEX;
	worldPos = (MODEL_MATRIX * vec4(VERTEX, 1.0)).xyz;
	
	
	vTexCoord = (worldPos / 100.0);
	vTexCoord.xz += mod(time*0.1,1.0);
	vTexCoord.y /= 4.0;
	vTexCoord.y += mod(time*1.0,1.0);
	vTexCoord2 = (worldPos / 200.0);
	vTexCoord2.xz += mod(time*0.1,1.0);
	vTexCoord2.y /= 4.0;
	vTexCoord2.y += mod(time*2.0,1.0);
	
	
	VAR_WORLD_POSITION  = worldPos;
	
	vec3 vnorm = normalize(NORMAL_MATRIX * NORMAL);
	vTangent = getTangent(vnorm);
	vBinormal = getBinormal(vnorm);
	
	vTBN = mat3(vTangent, vBinormal, vnorm);
	
	
	POSITION  =  VIEWPROJECTION_MATRIX * vec4(worldPos, 1.0);
}