
/*
This is a UI file (.ui.qml) that is intended to be edited in Qt Design Studio only.
It is supposed to be strictly declarative and only uses a subset of QML. If you edit
this file manually, you might introduce QML code that is not supported by Qt Design Studio.
Check out https://doc.qt.io/qtcreator/creator-quick-ui-forms.html for details on .ui.qml files.
*/
import QtQuick
import QtQuick.Controls

Item {
    id: root

    property alias sliderTitle: sliderTitle.text
    property alias sliderValue: control.value
    property alias sliderFrom: control.from
    property alias sliderTo: control.to

    width: 375
    height: 100

    Item {
        id: spacer

        width: parent.width
        height: parent.height / 6
    }

    Text {
        id: sliderTitle

        width: parent.width
        height: parent.height / 3
        anchors.top: spacer.bottom
        leftPadding: 10
        color: "#ffffff"
        text: qsTr("title")
        font.pixelSize: Math.min(parent.width / 4, parent.height / 3)
        verticalAlignment: Text.AlignVCenter
        font.styleName: "Regular"
        font.family: "Titillium Web"
    }

    Slider {
        id: control

        width: parent.width
        height: parent.height / 3
        anchors.top: sliderTitle.bottom
        value: 0
        from: -1
        to: 10
        stepSize: 0.01
        background: Rectangle {
            x: control.leftPadding
            y: control.topPadding + control.availableHeight / 2 - height / 2
            width: control.availableWidth
            height: control.availableHeight / 10
            radius: 2
            color: "#bdbebf"

            Rectangle {
                id: groove

                height: parent.height
                color: "#2cde85"
                radius: 2
                width: control.visualPosition * parent.width
            }
        }

        handle: Rectangle {
            id: handleItem

            x: control.leftPadding + control.visualPosition * (control.availableWidth - width)
            y: control.topPadding + control.availableHeight / 2 - height / 2
            implicitWidth: control.availableHeight
            implicitHeight: control.availableHeight
            radius: handleItem.width / 2
            color: "#f6f6f6"
            border.color: "#bdbebf"
        }
    }

    states: [
        State {
            name: "normal"

            PropertyChanges {
                target: groove
                color: "#2cde85"
            }
        },

        State {
            name: "pressed"
            when: control.pressed

            PropertyChanges {
                target: handleItem
                color: "#2cde85"
                border.color: "#ffffff"
            }

            PropertyChanges {
                target: groove
                color: "#2cde85"
            }
        },

        State {
            name: "hovered"
            when: control.hovered

            PropertyChanges {
                target: handleItem
                color: "#7ce3af"
                border.color: "#2cde85"
            }
        }
    ]
}
