import highendivisystem 1.0
import QtQuick 2.15
import QtQuick3D 1.15
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6
import Quick3DAssets.CarLights 1.0
import QtQuick3D.Materials 1.14
import QtQuick3D.Materials 1.15

Rectangle {
    id: centerarea
    width: 1080
    height: 720
    color: "#1c2630"
    opacity: 1

    property alias rearinterruptionChecked: rearinterruption.checked
    property alias weathericonsRainmoonOpacity: weathericons.rainmoonOpacity
    property alias weathericonsRainsunOpacity: weathericons.rainsunOpacity
    property alias weathericonsClearOpacity: weathericons.clearOpacity
    property alias weathericonsBlizzardOpacity: weathericons.blizzardOpacity
    property alias weathericonsBrokencloudsOpacity: weathericons.brokencloudsOpacity
    property alias weathericonsClearnightOpacity: weathericons.clearnightOpacity
    property alias weathericonsColdOpacity: weathericons.coldOpacity
    property alias weathericonsFogOpacity: weathericons.fogOpacity
    property alias weathericonsHailOpacity: weathericons.hailOpacity
    property alias weathericonsHeavyrainOpacity: weathericons.heavyrainOpacity
    property alias weathericonsHotOpacity: weathericons.hotOpacity
    property alias weathericonsLightrainOpacity: weathericons.lightrainOpacity
    property alias weathericonsLightsnowOpacity: weathericons.lightsnowOpacity
    property alias weathericonsNightscatteredfogOpacity: weathericons.nightscatteredfogOpacity
    property alias weathericonsOvercastOpacity: weathericons.overcastOpacity
    property alias weathericonsRainOpacity: weathericons.rainOpacity
    property alias weathericonsScatteredfogOpacity: weathericons.scatteredfogOpacity
    property alias weathericonsSnowOpacity: weathericons.snowOpacity
    property alias weathericonsThunderOpacity: weathericons.thunderOpacity
    property alias weathericonsTornadoOpacity: weathericons.tornadoOpacity
    property alias weathericonsWindyOpacity: weathericons.windyOpacity
    property alias weathericonsWintermixOpacity: weathericons.wintermixOpacity
    property alias trunkIsOpen: trunk.isOpen
    property alias hoodIsOpen: hood.isOpen
    property alias doorfrontrightIsOpen: doorfrontright.isOpen
    property alias doorbackrightIsOpen: doorbackright.isOpen
    property alias doorbackleftIsOpen: doorbackleft.isOpen
    property alias doorfrontleftIsOpen: doorfrontleft.isOpen
    property real turnsignal: 0

    PropertyAnimation {
        id: turnsignalanimation
        target: centerarea
        running: true
        loops: Animation.Infinite
        property: "turnsignal"
        from: 1.0
        to: 0.0
        duration: 800
    }
    Image {
        id: landscape
        x: 0
        y: 0
        source: "img/horizon.png"
        fillMode: Image.PreserveAspectFit
    }

    SwipeView {
        id: swipeview

        currentIndex: 1
        anchors.fill: parent

        Item {
            id: weatherpage

            OpacityMaskItem {
                id: opacityMask
                x: 0
                y: 0

                width: 1080
                height: 720
                layer.enabled: true
                invert: false
                enabled: true
                focus: false
                visible: true

                Rectangle {
                    id: mainWeather
                    x: 0
                    y: 0
                    width: 1080
                    height: 720
                    visible: true
                    color: "#003c4661"

                    Weathericons {
                        id: weathericons
                        x: 342
                        y: 237
                        visible: true
                        color: "#00303553"
                    }

                    Heatcolor {
                        id: heatcolor
                        x: 0
                        y: 0
                        opacity: 0.349
                        visible: true
                    }

                    View3D {
                        id: view3Dweather
                        x: 0
                        y: 0
                        width: 1080
                        height: 720
                        anchors.verticalCenter: parent.verticalCenter
                        anchors.left: parent.left
                        anchors.right: parent.right
                        anchors.top: parent.top
                        anchors.bottom: parent.bottom
                        anchors.horizontalCenter: parent.horizontalCenter
                        environment: sceneEnvironment3
                        SceneEnvironment {
                            id: sceneEnvironment3
                            antialiasingQuality: SceneEnvironment.High
                            antialiasingMode: SceneEnvironment.MSAA
                        }

                        Node {
                            id: scene3
                            DirectionalLight {
                                id: directionalLight5
                            }

                            PerspectiveCamera {
                                id: camera3
                                z: 350
                            }

                            Group2 {
                                id: rain3D
                            }
                        }
                    }

                    Text {
                        id: temptext
                        x: 558
                        y: 291
                        width: 180
                        height: 103
                        color: "#ffffff"
                        text: tempslider.value.toString()
                        font.pixelSize: 80
                    }
                }

                Image {
                    id: roundmask
                    x: 8
                    y: 8
                    width: 1186
                    height: 888
                    visible: false
                    source: "img/roundmask.png"
                    fillMode: Image.Stretch
                }
            }
        }

        Item {
            id: carpage
            View3D {
                id: view3Dcar
                x: 0
                y: 0
                width: 1080
                height: 720
                SceneEnvironment {
                    id: sceneEnvironmentcar
                    effects: [hDRBloomTonemap]
                    antialiasingMode: SceneEnvironment.SSAA
                    antialiasingQuality: SceneEnvironment.High

                    HDRBloomTonemap {
                        id: hDRBloomTonemap
                        exposure: 0.045
                        blurFalloff: 0
                        tonemappingLerp: 1
                        channelThreshold: 0.6005
                        bloomThreshold: 0.6
                        gamma: 1.1365
                    }
                }

                Node {
                    id: carscene
                    DirectionalLight {
                        id: directionalLight1
                        x: 0
                        y: 2021.321
                        color: "#b5bcd7"
                        z: 47.38122
                        brightness: 100
                        eulerRotation.z: 120.98213
                        eulerRotation.y: -111.1543
                        eulerRotation.x: -40.12516
                    }

                    PerspectiveCamera {
                        id: camera1
                        x: 7.063
                        y: 832.621
                        eulerRotation.z: -0
                        eulerRotation.y: 0
                        eulerRotation.x: -17.55022
                        z: 1911.21899
                    }

                    Node {
                        id: cargroup
                        x: 0
                        y: 289.582
                        z: -0
                        eulerRotation.z: 0
                        eulerRotation.y: 0
                        eulerRotation.x: 0.00001

                        Node {
                            id: group
                            x: -0
                            y: -0
                            z: -774.74847
                            eulerRotation.z: -0
                            eulerRotation.y: 0
                            eulerRotation.x: 0.00001

                            Model {
                                id: carshadow

                                x: -0
                                y: -290.697
                                source: "#Rectangle"
                                scale.x: 32.82426
                                materials: rectMaterial1
                                z: 522.9198
                                DefaultMaterial {
                                    id: rectMaterial1
                                    diffuseMap: element18
                                    Texture {
                                        id: element18
                                        source: "img/redglow.png"
                                    }
                                    diffuseColor: "#000000"
                                }
                                eulerRotation.x: -90
                                scale.y: 54.83427
                                scale.z: 50
                            }

                            Model {
                                id: body
                                source: "asset_imports/Quick3DAssets/BakedCar2/meshes/body.mesh"
                                eulerRotation.x: -90
                                DefaultMaterial {
                                    id: cubeMaterial1
                                    emissiveFactor: 0
                                    emissiveColor: "#ffffff"
                                    specularTint: "#000000"
                                    specularAmount: 0.4
                                    diffuseMap: element4
                                    diffuseColor: "#7b8f91"

                                    Texture {
                                        id: element4
                                        source: "body.png"
                                    }
                                }

                                DefaultMaterial {
                                    id: defaultMaterial
                                    opacity: 0
                                    diffuseColor: "#919191"
                                }

                                DefaultMaterial {
                                    id: defaultMaterial1
                                    opacity: 0.5
                                    diffuseColor: "#060606"
                                }

                                Model {
                                    id: rearlightleft
                                    source: "asset_imports/Quick3DAssets/CarLights/meshes/rearlightleft.mesh"
                                    materials: rearLightMat

                                    RearLightMat {
                                        id: rearLightMat
                                        lightOn: (drivelight.checked) ? 1.0 : 0.0
                                        turnOn: (turnleftlight.checked
                                                 || emergency.checked) ? turnsignal : 0.0
                                        brakeOn: (brakelight.checked) ? 1.0 : 0.0
                                    }
                                }

                                Model {
                                    id: rearlightright
                                    source: "asset_imports/Quick3DAssets/CarLights/meshes/rearlightright.mesh"
                                    materials: rearLightMat1

                                    RearLightMat {
                                        id: rearLightMat1
                                        lightOn: (drivelight.checked) ? 1.0 : 0.0
                                        turnOn: (turnrightlight.checked
                                                 || emergency.checked) ? turnsignal : 0.0
                                        brakeOn: (brakelight.checked) ? 1.0 : 0.0
                                    }
                                }
                                materials: [cubeMaterial1, defaultMaterial, defaultMaterial1]
                            }

                            Doorfrontleft {
                                id: doorfrontleft
                                x: -355.012
                                y: 17.032
                                isOpen: doorfl.checked
                            }

                            Doorbackleft {
                                id: doorbackleft
                                x: -355.379
                                y: 66.667
                                isOpen: doorrl.checked
                            }

                            Doorbackright {
                                id: doorbackright
                                x: 356.492
                                y: 23.843
                                isOpen: doorrr.checked
                            }

                            Doorfrontright {
                                id: doorfrontright
                                x: 354.127
                                y: 34.856
                                isOpen: doorfr.checked
                            }

                            Hood {
                                id: hood
                                x: -6.272
                                y: 134.534
                                isOpen: hoodf.checked
                            }

                            Trunk {
                                id: trunk
                                x: -11.621
                                y: 292.956
                                isOpen: trunkr.checked
                            }

                            Frontlefttire {
                                id: frontlefttire
                                x: -346.44
                                y: -161.248
                            }

                            Model {
                                id: rearlefttire
                                x: -346.44
                                y: -161.248
                                source: "asset_imports/Quick3DAssets/BakedCar2/meshes/tire_front_left.mesh"
                                DefaultMaterial {
                                    id: cubeMaterial9
                                    Texture {
                                        id: element13
                                        source: "tire.png"
                                    }
                                    diffuseMap: element13
                                    diffuseColor: "#f7f7f7"
                                }
                                z: 1376.79565
                                materials: cubeMaterial9
                            }

                            Model {
                                id: rearrighttire
                                x: 345.57
                                y: -161.248
                                source: "asset_imports/Quick3DAssets/BakedCar2/meshes/tire_front_left.mesh"
                                DefaultMaterial {
                                    id: cubeMaterial11
                                    specularAmount: 0
                                    Texture {
                                        id: element15
                                        source: "tire.png"
                                    }
                                    diffuseMap: element15
                                    diffuseColor: "#d2d2d2"
                                }
                                eulerRotation.y: 180
                                z: 1369.98657
                                materials: cubeMaterial11
                            }

                            Frontrighttire {
                                id: frontrighttire
                                x: 345.57
                                y: -161.248
                            }

                            Model {
                                id: foglights
                                source: "asset_imports/Quick3DAssets/Foglights/meshes/foglights.mesh"
                                eulerRotation.x: -90
                                DefaultMaterial {
                                    id: cubeMaterial2
                                    diffuseMap: texture1
                                    diffuseColor: "#fdfdfd"

                                    Texture {
                                        id: texture1
                                        source: "Map3.jpg"
                                    }
                                }
                                materials: cubeMaterial2
                            }

                            Model {
                                id: frontlighRight
                                source: "asset_imports/Quick3DAssets/FrontLights/meshes/frontLightRight.mesh"
                                eulerRotation.x: -90

                                RearLightMat {
                                    id: rearLightMat2
                                    lightOn: (drivelight.checked) ? 1.0 : 0.0
                                    turnOn: (turnrightlight.checked
                                             || emergency.checked) ? turnsignal : 0.0
                                    brakeOn: (brakelight.checked) ? 1.0 : 0.0
                                }
                                materials: [rearLightMat2]
                            }

                            Model {
                                id: frontlightLeft
                                source: "asset_imports/Quick3DAssets/FrontLights/meshes/frontlightLeft.mesh"
                                eulerRotation.x: -90

                                RearLightMat {
                                    id: rearLightMat3
                                    lightOn: (drivelight.checked) ? 1.0 : 0.0
                                    turnOn: (turnleftlight.checked
                                             || emergency.checked) ? turnsignal : 0.0
                                    brakeOn: (brakelight.checked) ? 1.0 : 0.0
                                }
                                materials: [rearLightMat3]
                            }

                            HighBeam {
                                id: highBeam
                                x: 0
                                y: 0
                            }
                        }

                        Node {
                            id: lights

                            PointLight {
                                id: leftbrakelight
                                x: -304.523
                                y: 159.55
                                visible: brakelight.checked
                                color: "#b20000"
                                linearFade: 0
                                shadowMapQuality: Light.ShadowMapQualityVeryHigh
                                shadowBias: 0
                                shadowMapFar: 1000
                                castsShadow: true
                                quadraticFade: 1
                                brightness: 700
                                z: 795.98657
                            }

                            PointLight {
                                id: rightbrakelight
                                x: 301.41
                                y: 145.352
                                visible: brakelight.checked
                                color: "#b20000"
                                linearFade: 0
                                constantFade: 1
                                shadowFactor: 5
                                shadowMapQuality: Light.ShadowMapQualityVeryHigh
                                shadowBias: 0
                                shadowMapFar: 1000
                                castsShadow: true
                                quadraticFade: 1
                                brightness: 700
                                z: 795.98657
                            }

                            PointLight {
                                id: foglightLeft
                                x: -372.453
                                y: -92.081
                                visible: foglight.checked
                                scale.z: 1
                                scale.y: 1
                                scale.x: 1
                                z: -884.44604
                                brightness: 685
                            }

                            PointLight {
                                id: foglightRight
                                x: 383.952
                                y: -92.081
                                visible: foglight.checked
                                brightness: 685
                                z: -884.44598
                            }

                            PointLight {
                                id: highbeamleft
                                x: -320.897
                                y: 100.956
                                visible: highbeam.checked
                                brightness: 685
                                scale.y: 1
                                z: -749.06531
                                scale.x: 1
                                scale.z: 1
                            }

                            PointLight {
                                id: highbeamright
                                x: 322.874
                                y: 100.956
                                visible: highbeam.checked
                                brightness: 685
                                scale.y: 1
                                z: -749.06525
                                scale.x: 1
                                scale.z: 1
                            }
                        }
                    }

                    DirectionalLight {
                        id: directionalLight2
                        x: -4
                        y: 2017
                        visible: true
                        color: "#b6c1ec"
                        shadowMapQuality: Light.ShadowMapQualityVeryHigh
                        castsShadow: false
                        brightness: 100
                        eulerRotation.y: 42.75191
                        eulerRotation.x: -23.29087
                        z: 47.38122
                        eulerRotation.z: -115.37463
                    }
                }

                environment: sceneEnvironmentcar
            }
        }

        Item {
            id: settings
            Rectangle {
                id: settingsbg
                x: 0
                y: 0
                width: 1080
                height: 720
                visible: true
                color: "#003c4661"

                Text {
                    id: element23
                    x: 118
                    y: 249
                    width: 691
                    height: 91
                    color: "#fbfbfb"
                    text: qsTr("Rear camera interruption")
                    font.pixelSize: 60
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                }

                CheckBox {
                    id: rearinterruption
                    x: 896
                    y: 265
                    width: 48
                    height: 58
                    text: qsTr("Check Box")
                    scale: 2.337
                }
            }
        }

        Item {
            id: navigation

            Rectangle {
                id: rectangle3
                width: 1080
                height: 720
                visible: false
                color: "#535353"
            }

            View3D {
                id: view3D
                x: 0
                y: 0
                width: 1080
                height: 720
                visible: true
                SceneEnvironment {
                    id: sceneEnvironment
                    antialiasingMode: SceneEnvironment.MSAA
                    antialiasingQuality: SceneEnvironment.High
                }

                Node {
                    id: scene
                    DirectionalLight {
                        id: directionalLight
                    }

                    PerspectiveCamera {
                        id: camera
                        x: 0
                        y: 1025.398
                        clipFar: 20000
                        eulerRotation.z: -0
                        eulerRotation.y: 0
                        eulerRotation.x: -26.47537
                        z: 2767.60889
                    }

                    Model {
                        id: cubeModel
                        x: -0
                        y: -91.027
                        source: "asset_imports/Quick3DAssets/Plane/meshes/plane.mesh"
                        z: -82.89752
                        eulerRotation.z: 0
                        scale.z: 1955.14209
                        scale.y: 296.53036
                        scale.x: 3673.01807
                        DefaultMaterial {
                            id: cubeMaterial
                            lighting: DefaultMaterial.NoLighting
                            diffuseMap: element1
                            diffuseColor: "#a4b2db"

                            Texture {
                                id: element1
                                source: "img/mapholder.png"
                            }
                        }
                        materials: cubeMaterial
                        eulerRotation.y: 0
                        eulerRotation.x: 0
                    }
                }
                environment: sceneEnvironment
            }

            Image {
                id: image2
                x: 906
                y: 470
                width: 154
                height: 156
                source: "img/Speedsign.png"
                fillMode: Image.PreserveAspectFit

                Text {
                    id: element2
                    x: 0
                    y: 0
                    width: 154
                    height: 156
                    text: qsTr("100")
                    font.pixelSize: 60
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                    font.bold: true
                }
            }

            TextField {
                id: textField
                x: 317
                y: 56
                width: 447
                height: 70
                background: RectangleItem {
                    id: rectangle5
                    width: 447
                    height: 70
                    radius: 30
                    fillColor: "#a7ffffff"
                    topLeftRadius: 30
                    bottomRightRadius: 30
                    strokeColor: "#00ff0000"
                }

                placeholderText: qsTr("Where to?")
            }
        }
    }

    Image {
        id: bottomgradient
        x: 0
        y: 539
        width: 1080
        height: 181
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        fillMode: Image.Stretch
        source: "img/darkgradient.png"
    }

    View3D {
        id: view3Doverlay
        x: 0
        y: 0
        width: 1080
        height: 720
        SceneEnvironment {
            id: sceneEnvironment2
            antialiasingMode: SceneEnvironment.MSAA
            antialiasingQuality: SceneEnvironment.High
        }

        Node {
            id: scene2
            DirectionalLight {
                id: directionalLight3
                x: 0
                y: 2021.321
                color: "#b5bcd7"
                eulerRotation.y: -111.1543
                brightness: 128
                eulerRotation.z: 120.98213
                eulerRotation.x: -40.12516
                z: 47.38122
            }

            PerspectiveCamera {
                id: camera2
                x: 7.063
                y: 832.621
                eulerRotation.y: 0
                eulerRotation.z: 0
                eulerRotation.x: -17.55022
                z: 1911.21899
            }
            Model {
                id: carshadow8
                x: -5
                y: 1466
                source: "#Rectangle"
                DefaultMaterial {
                    id: rectMaterial14
                    opacity: 0.35
                    Texture {
                        id: element32
                        source: "Flare2.png"
                    }
                    diffuseMap: element32
                    blendMode: DefaultMaterial.SourceOver
                    diffuseColor: "#fbfbfb"
                    lighting: DefaultMaterial.NoLighting
                }
                eulerRotation.y: 0
                scale.x: 265.3132
                eulerRotation.z: 360
                scale.z: 150
                eulerRotation.x: 41.33691
                z: 337.19775
                scale.y: 150
                materials: rectMaterial14
            }

            Node {
                id: sky
                x: 0
                y: 289.582
                Node {
                    id: group3
                    x: 0
                    y: 0

                    Model {
                        id: flare
                        x: 3
                        y: 727.833
                        source: "#Rectangle"
                        DefaultMaterial {
                            id: rectMaterial11
                            opacity: 0.35
                            Texture {
                                id: element29
                                source: "Flare2.png"
                            }
                            diffuseMap: element29
                            blendMode: DefaultMaterial.SourceOver
                            diffuseColor: "#68df8f"
                            lighting: DefaultMaterial.NoLighting
                        }
                        eulerRotation.y: 0
                        scale.x: 150
                        eulerRotation.z: 0
                        scale.z: 150
                        eulerRotation.x: 87
                        z: 915.8623
                        scale.y: 150
                        materials: rectMaterial11
                    }

                    Model {
                        id: carshadow7
                        x: 3
                        y: 784.113
                        source: "#Rectangle"
                        DefaultMaterial {
                            id: rectMaterial12
                            opacity: 0.35
                            Texture {
                                id: element30
                                source: "Flare2.png"
                            }
                            diffuseMap: element30
                            blendMode: DefaultMaterial.SourceOver
                            diffuseColor: "#f9f9f9"
                            lighting: DefaultMaterial.NoLighting
                        }
                        eulerRotation.y: 0
                        scale.x: 400
                        eulerRotation.z: 23.93504
                        scale.z: 400
                        eulerRotation.x: 86.9999
                        z: 912.91278
                        scale.y: 400
                        materials: rectMaterial12
                    }

                    eulerRotation.y: 0
                    eulerRotation.z: 0
                    eulerRotation.x: 0.00001
                    z: -774.74847
                }
                eulerRotation.y: 360
                eulerRotation.z: 0
                eulerRotation.x: 0.00001
                z: 0
            }

            DirectionalLight {
                id: directionalLight4
                x: -4
                y: 2017
                color: "#b6c1ec"
                eulerRotation.y: 42.75191
                brightness: 128
                eulerRotation.z: -115.37463
                eulerRotation.x: -23.29087
                z: 47.38122
            }

            Model {
                id: plane1
                x: 0
                y: 0
                source: "#Rectangle"
                DefaultMaterial {
                    id: rectMaterial13
                    Texture {
                        id: element31
                        source: "img/darkgradient.png"
                    }
                    diffuseMap: element31
                    diffuseColor: "#fdfdfd"
                }
                scale.x: 128.92119
                scale.z: 50
                eulerRotation.x: -90
                z: -268.99194
                scale.y: 47.03248
                materials: rectMaterial13
            }
        }
        environment: sceneEnvironment2
    }

    Image {
        id: topgradient
        x: 0
        y: 0
        width: 1080
        height: 256
        rotation: 180
        anchors.bottom: parent.bottom
        source: "img/darkgradient.png"
        fillMode: Image.Stretch
        anchors.bottomMargin: 464
    }

    PageIndicator {
        id: pageindicator
        y: 682
        scale: 2

        count: swipeview.count
        currentIndex: swipeview.currentIndex

        anchors.bottom: swipeview.bottom
        anchors.horizontalCenterOffset: 0
        anchors.bottomMargin: 18
        anchors.horizontalCenter: parent.horizontalCenter
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 20000
                running: true
                loops: -1
                to: 20000
                from: 0
            }
        ]
        endFrame: 20000
        startFrame: 0
        enabled: true

        KeyframeGroup {
            target: cargroup
            property: "eulerRotation.y"
            Keyframe {
                frame: 0
                value: 360
            }

            Keyframe {
                frame: 20000
                value: 0
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:0.6600000262260437;height:720;width:1080}D{i:109}
}
##^##*/

