import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6


Model {
    id: doorfrontright
    source: "asset_imports/Quick3DAssets/BakedCar2/meshes/door_front_right.mesh"
    property bool isOpen: true
    eulerRotation.z: 0
    eulerRotation.y: 0
    eulerRotation.x: -90
    DefaultMaterial {
        id: defaultMaterial5
        opacity: 0
        diffuseColor: "#040404"
    }
    
    DefaultMaterial {
        id: cubeMaterial5

        Texture {
            id: element8
            source: "doorFR.png"
        }
        diffuseMap: element8
        emissiveFactor: 0
        emissiveColor: "#ffffff"
        specularTint: "#000000"
        specularAmount: 0.4
        diffuseColor: "#7b8f91"

    }

    Model {
        id: cube
        source: "asset_imports/Quick3DAssets/CarWindows/meshes/door_front_right_window.mesh"
        materials: cubeMaterial
        DefaultMaterial {
            id: cubeMaterial
            specularAmount: 0
            diffuseMap: texture1
            diffuseColor: "#ffffff"

            Texture {
                id: texture1
                source: "img/frwindow.png"
                positionV: frwindowslider.value
            }
        }
    }
    states: [
        State {
            name: "closed"
            when: !doorfrontright.isOpen

            PropertyChanges {
                target: doorfrontright
                eulerRotation.y: 0
            }
        },
        State {
            name: "open"
            when: doorfrontright.isOpen
            PropertyChanges {
                target: doorfrontright
                eulerRotation.y: 35
            }
        }
    ]
    transitions: Transition {
        NumberAnimation
        {
            properties: "eulerRotation.y"
            easing.type: Easing.InOutQuad
            duration: 500
        }

    }
    z: 486.31555
    materials: [cubeMaterial5, defaultMaterial5]
}


