/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import uk.me.parabola.imgfmt.app.Coord;

public class Utils {
    public static final int NOT_STRAIGHT = 0;
    public static final int STRAIGHT_SPIKE = 1;
    public static final int STRICTLY_STRAIGHT = 2;
    private static final double PI_BY_2 = 1.5707963267948966;

    public static byte[] toBytes(String s, int len, byte pad) {
        if (s == null) {
            throw new IllegalArgumentException("null string provided");
        }
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = i > s.length() ? pad : (byte)s.charAt(i);
        }
        return out;
    }

    public static byte[] toBytes(String s) {
        return Utils.toBytes(s, s.length(), (byte)0);
    }

    public static String bytesToString(ByteBuffer buf, int off, int len) {
        if (buf == null) {
            throw new IllegalArgumentException("null byte buffer provided");
        }
        byte[] bbuf = new byte[len];
        buf.position(off);
        buf.get(bbuf);
        char[] cbuf = new char[len];
        for (int i = 0; i < bbuf.length; ++i) {
            cbuf[i] = (char)bbuf[i];
        }
        return new String(cbuf);
    }

    public static void setCreationTime(ByteBuffer buf, Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        Utils.fillBufFromTime(buf, cal);
    }

    public static int toMapUnit(double l) {
        double DELTA = 1.0728836059570312E-5;
        if (l > 0.0) {
            return (int)((l + DELTA) * 1.6777216E7 / 360.0);
        }
        return (int)((l - DELTA) * 1.6777216E7 / 360.0);
    }

    public static byte[] makeCreationTime(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        byte[] ret = new byte[7];
        ByteBuffer buf = ByteBuffer.wrap(ret);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        Utils.fillBufFromTime(buf, cal);
        return ret;
    }

    private static void fillBufFromTime(ByteBuffer buf, Calendar cal) {
        buf.putChar((char)cal.get(1));
        buf.put((byte)(cal.get(2) + 1));
        buf.put((byte)cal.get(5));
        buf.put((byte)cal.get(11));
        buf.put((byte)cal.get(12));
        buf.put((byte)cal.get(13));
    }

    public static Date makeCreationTime(byte[] date) {
        Calendar cal = Calendar.getInstance();
        int y = ((date[1] & 0xFF) << 8) + (date[0] & 0xFF);
        cal.set(y, date[2] - 1, date[3], date[4], date[5], date[6]);
        return cal.getTime();
    }

    public static double toDegrees(int val) {
        return (double)val * 2.1457672119140625E-5;
    }

    public static double toRadians(int mapunits) {
        return Utils.toDegrees(mapunits) * (Math.PI / 180);
    }

    public static void closeFile(Closeable f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static InputStream openFile(String name) throws FileNotFoundException {
        InputStream is = new FileInputStream(name);
        if (name.endsWith(".gz")) {
            try {
                is = new GZIPInputStream(is);
            }
            catch (IOException e) {
                throw new FileNotFoundException("Could not read as compressed file");
            }
        }
        return is;
    }

    public static String joinPath(String dir, String basename, String ext) {
        return Utils.joinPath(dir, basename + "." + ext);
    }

    public static String joinPath(String dir, String basename) {
        File file = new File(dir, basename);
        return file.getAbsolutePath();
    }

    public static int roundUp(int val, int shift) {
        return val + (1 << shift) - 1 >>> shift << shift;
    }

    public static double getAngle(Coord c1, Coord c2, Coord c3) {
        double angle;
        double a = c2.bearingTo(c1);
        double b = c2.bearingTo(c3);
        for (angle = b - (a - 180.0); angle > 180.0; angle -= 360.0) {
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double getDisplayedAngle(Coord c1, Coord c2, Coord c3) {
        return Utils.getAngle(c1.getDisplayedCoord(), c2.getDisplayedCoord(), c3.getDisplayedCoord());
    }

    public static int isStraight(Coord c1, Coord c2, Coord c3) {
        if (c1.equals(c3)) {
            return 1;
        }
        long area = (long)c1.getLongitude() * (long)c2.getLatitude() - (long)c2.getLongitude() * (long)c1.getLatitude();
        area += (long)c2.getLongitude() * (long)c3.getLatitude() - (long)c3.getLongitude() * (long)c2.getLatitude();
        if ((area += (long)c3.getLongitude() * (long)c1.getLatitude() - (long)c1.getLongitude() * (long)c3.getLatitude()) == 0L) {
            int delta1 = c1.getLatitude() - c2.getLatitude();
            int delta2 = c2.getLatitude() - c3.getLatitude();
            if (delta1 < 0 && delta2 > 0 || delta1 > 0 && delta2 < 0) {
                return 1;
            }
            delta1 = c1.getLongitude() - c2.getLongitude();
            delta2 = c2.getLongitude() - c3.getLongitude();
            if (delta1 < 0 && delta2 > 0 || delta1 > 0 && delta2 < 0) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static int isHighPrecStraight(Coord c1, Coord c2, Coord c3) {
        if (c1.highPrecEquals(c3)) {
            return 1;
        }
        long c1Lat = c1.getHighPrecLat();
        long c2Lat = c2.getHighPrecLat();
        long c3Lat = c3.getHighPrecLat();
        long c1Lon = c1.getHighPrecLon();
        long c2Lon = c2.getHighPrecLon();
        long c3Lon = c3.getHighPrecLon();
        long area = c1Lon * c2Lat - c2Lon * c1Lat;
        area += c2Lon * c3Lat - c3Lon * c2Lat;
        if ((area += c3Lon * c1Lat - c1Lon * c3Lat) == 0L) {
            long delta1 = c1Lat - c2Lat;
            long delta2 = c2Lat - c3Lat;
            if (delta1 < 0L && delta2 > 0L || delta1 > 0L && delta2 < 0L) {
                return 1;
            }
            delta1 = c1Lon - c2Lon;
            delta2 = c2Lon - c3Lon;
            if (delta1 < 0L && delta2 > 0L || delta1 > 0L && delta2 < 0L) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static double atan2_approximation(double y, double x) {
        double atan;
        if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y == 0.0) {
                return 0.0;
            }
            return -1.5707963267948966;
        }
        double z = y / x;
        if (Math.abs(z) < 1.0) {
            atan = z / (1.0 + (double)0.28f * z * z);
            if (x < 0.0) {
                if (y < 0.0) {
                    return atan - Math.PI;
                }
                return atan + Math.PI;
            }
        } else {
            atan = 1.5707963267948966 - z / (z * z + (double)0.28f);
            if (y < 0.0) {
                return atan - Math.PI;
            }
        }
        return atan;
    }

    public static long coord2Long(Coord co) {
        int lat30 = co.getHighPrecLat();
        int lon30 = co.getHighPrecLon();
        return ((long)lat30 & 0xFFFFFFFFL) << 32 | (long)lon30 & 0xFFFFFFFFL;
    }
}

