/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class FileBackedImgFileWriter
implements ImgFileWriter {
    private final ImgChannel outputChan;
    private final File tmpFile;
    private final BufferedOutputStream file;
    private final FileChannel tmpChannel;

    public FileBackedImgFileWriter(ImgChannel chan, File outputDir) {
        this.outputChan = chan;
        try {
            this.tmpFile = File.createTempFile("img", null, outputDir);
            this.tmpFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(this.tmpFile);
            this.tmpChannel = out.getChannel();
            this.file = new BufferedOutputStream(out, 16384);
        }
        catch (IOException e) {
            throw new MapFailedException("Could not create mdr temporary file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws IOException {
        this.file.close();
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.tmpFile);
            FileChannel channel = is.getChannel();
            channel.transferTo(0L, channel.size(), this.outputChan);
            channel.close();
        }
        catch (Throwable throwable) {
            Utils.closeFile(is);
            if (!this.tmpFile.delete()) {
                System.err.println("Could not delete mdr img temporary file");
            }
            throw throwable;
        }
        Utils.closeFile(is);
        if (!this.tmpFile.delete()) {
            System.err.println("Could not delete mdr img temporary file");
        }
    }

    @Override
    public int position() {
        try {
            this.file.flush();
            return (int)this.tmpChannel.position();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void position(long pos) {
        try {
            this.file.flush();
            this.tmpChannel.position(pos);
        }
        catch (IOException e) {
            throw new MapFailedException("Could not set position in mdr tmp file");
        }
    }

    @Override
    public void put(byte b) {
        try {
            this.file.write(b);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write byte to mdr tmp file");
        }
    }

    @Override
    public void putChar(char c) {
        try {
            this.file.write(c);
            this.file.write(c >> 8);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write char to mdr tmp file");
        }
    }

    @Override
    public void put3(int val) {
        try {
            this.file.write(val);
            this.file.write(val >> 8);
            this.file.write(val >> 16);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write3 to mdr tmp file");
        }
    }

    @Override
    public void putInt(int val) {
        try {
            this.file.write(val);
            this.file.write(val >> 8);
            this.file.write(val >> 16);
            this.file.write(val >> 24);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write int to mdr tmp file");
        }
    }

    @Override
    public void put(byte[] val) {
        try {
            this.file.write(val);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write bytes to mdr tmp file");
        }
    }

    @Override
    public void put(byte[] src, int start, int length) {
        try {
            this.file.write(src, start, length);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write bytes to mdr tmp file");
        }
    }

    @Override
    public void put(ByteBuffer src) {
        try {
            this.file.flush();
            this.tmpChannel.write(src);
        }
        catch (IOException e) {
            throw new MapFailedException("could not write buffer to mdr tmp file");
        }
    }

    @Override
    public long getSize() {
        try {
            this.file.flush();
            return this.tmpChannel.size();
        }
        catch (IOException e) {
            throw new MapFailedException("could not get size of mdr tmp file");
        }
    }

    @Override
    public void close() throws IOException {
        this.outputChan.close();
    }
}

