/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.IOException;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.SectionWriter;

public class Section {
    private char itemSize;
    private int size;
    private int position;
    private Section link;
    private int extraValue;

    public Section() {
    }

    public Section(char itemSize) {
        this.itemSize = itemSize;
    }

    public Section(Section link, char itemSize) {
        this.itemSize = itemSize;
        this.link = link;
    }

    public Section(Section link) {
        this.link = link;
    }

    public void inc() {
        this.size += this.itemSize;
    }

    public char getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(char itemSize) {
        this.itemSize = itemSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPosition() {
        if (this.link != null) {
            return this.link.getEndPos();
        }
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        this.link = null;
    }

    public int getEndPos() {
        return this.getPosition() + this.size;
    }

    public String toString() {
        return "pos=" + this.getPosition() + ", size=" + this.size + ", itemSize=" + this.itemSize;
    }

    public int getNumItems() {
        if (this.itemSize == '\u0000') {
            return 0;
        }
        return this.size / this.itemSize;
    }

    protected int getExtraValue() {
        return this.extraValue;
    }

    public void setExtraValue(int extraValue) {
        this.extraValue = extraValue;
    }

    public void readSectionInfo(ImgFileReader reader, boolean withItemSize) {
        this.setPosition(reader.getInt());
        this.setSize(reader.getInt());
        if (withItemSize) {
            this.setItemSize(reader.getChar());
        }
    }

    public SectionWriter makeSectionWriter(ImgFileWriter writer) {
        this.setPosition(writer.position());
        return new SectionWriter(writer, this);
    }

    public void writeSectionInfo(ImgFileWriter writer) {
        this.writeSectionInfo(writer, false);
    }

    public void writeSectionInfo(ImgFileWriter writer, boolean withItemSize) {
        this.writeSectionInfo(writer, withItemSize, false);
    }

    public void writeSectionInfo(ImgFileWriter writer, boolean withItemSize, boolean withExtraValue) {
        writer.putInt(this.getPosition());
        writer.putInt(this.getSize());
        if (withItemSize || this.getItemSize() > '\u0000') {
            writer.putChar(this.getItemSize());
        }
        if (withExtraValue) {
            writer.putInt(this.getExtraValue());
        }
    }

    public static void close(ImgFileWriter writer) {
        assert (writer instanceof SectionWriter);
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

