/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.util.Locale;
import uk.me.parabola.imgfmt.app.labelenc.Transliterator;
import uk.me.parabola.log.Logger;

public class SparseTransliterator
implements Transliterator {
    private static final Logger log = Logger.getLogger(SparseTransliterator.class);
    private final boolean useNoMacron;
    private boolean forceUppercase;

    public SparseTransliterator(String targetCharset) {
        this.useNoMacron = targetCharset.equals("nomacron");
    }

    @Override
    public String transliterate(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length() + 5);
        for (int n : s.toCharArray()) {
            if (this.useNoMacron) {
                if (n == 257) {
                    n = 97;
                }
                if (n == 275) {
                    n = 101;
                }
                if (n == 299) {
                    n = 105;
                }
                if (n == 333) {
                    n = 111;
                }
                if (n == 363) {
                    n = 117;
                }
            }
            sb.append((char)n);
        }
        String text = sb.toString();
        if (this.forceUppercase) {
            text = text.toUpperCase(Locale.ENGLISH);
        }
        return text;
    }

    @Override
    public void forceUppercase(boolean uc) {
        this.forceUppercase = uc;
    }
}

