/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.util.List;
import uk.me.parabola.imgfmt.app.Exit;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.ExitFacility;
import uk.me.parabola.imgfmt.app.lbl.Zip;

public class POIRecord {
    static final byte HAS_STREET_NUM = 1;
    static final byte HAS_STREET = 2;
    static final byte HAS_CITY = 4;
    static final byte HAS_ZIP = 8;
    static final byte HAS_PHONE = 16;
    static final byte HAS_EXIT = 32;
    static final byte HAS_TIDE_PREDICTION = 64;
    private int offset = -1;
    private Label poiName;
    private final SimpleStreetPhoneNumber simpleStreetNumber = new SimpleStreetPhoneNumber();
    private final SimpleStreetPhoneNumber simplePhoneNumber = new SimpleStreetPhoneNumber();
    private Label streetName;
    private Label streetNumberName;
    private Label complexPhoneNumber;
    private City city;
    private Zip zip;
    private Exit exit;

    public void setLabel(Label label) {
        this.poiName = label;
    }

    public void setStreetName(Label label) {
        this.streetName = label;
    }

    public boolean setSimpleStreetNumber(String streetNumber) {
        return this.simpleStreetNumber.set(streetNumber);
    }

    public void setComplexStreetNumber(Label label) {
        this.streetNumberName = label;
    }

    public boolean setSimplePhoneNumber(String phone) {
        return this.simplePhoneNumber.set(phone);
    }

    public void setComplexPhoneNumber(Label label) {
        this.complexPhoneNumber = label;
    }

    public void setZip(Zip zip) {
        this.zip = zip;
    }

    public void setCity(City city) {
        this.city = city;
    }

    public void setExit(Exit exit) {
        this.exit = exit;
    }

    void write(ImgFileWriter writer, byte POIGlobalFlags, int realofs, long numCities, long numZips, long numHighways, long numExitFacilities) {
        int labOff;
        assert (this.offset == realofs) : "offset = " + this.offset + " realofs = " + realofs;
        int ptr = this.poiName.getOffset();
        if (POIGlobalFlags != this.getPOIFlags()) {
            ptr |= 0x800000;
        }
        writer.put3(ptr);
        if (POIGlobalFlags != this.getPOIFlags()) {
            writer.put(this.getWrittenPOIFlags(POIGlobalFlags));
        }
        if (this.streetNumberName != null) {
            labOff = this.streetNumberName.getOffset();
            writer.put((byte)((labOff & 0x7F0000) >> 16));
            writer.putChar((char)(labOff & 0xFFFF));
        } else if (this.simpleStreetNumber.isUsed()) {
            this.simpleStreetNumber.write(writer);
        }
        if (this.streetName != null) {
            writer.put3(this.streetName.getOffset());
        }
        if (this.city != null) {
            char cityIndex = (char)this.city.getIndex();
            if (numCities > 255L) {
                writer.putChar(cityIndex);
            } else {
                writer.put((byte)cityIndex);
            }
        }
        if (this.zip != null) {
            char zipIndex = (char)this.zip.getIndex();
            if (numZips > 255L) {
                writer.putChar(zipIndex);
            } else {
                writer.put((byte)zipIndex);
            }
        }
        if (this.complexPhoneNumber != null) {
            labOff = this.complexPhoneNumber.getOffset();
            writer.put((byte)((labOff & 0x7F0000) >> 16));
            writer.putChar((char)(labOff & 0xFFFF));
        } else if (this.simplePhoneNumber.isUsed()) {
            this.simplePhoneNumber.write(writer);
        }
        if (this.exit != null) {
            Label description = this.exit.getDescription();
            int val = 0;
            if (description != null) {
                val = description.getOffset();
                assert (val < 0x400000) : "Exit description label offset too large";
            }
            if (this.exit.getOvernightParking()) {
                val |= 0x400000;
            }
            List<ExitFacility> facilites = this.exit.getFacilities();
            ExitFacility ef = null;
            if (!facilites.isEmpty()) {
                ef = facilites.get(0);
            }
            if (ef != null) {
                val |= 0x800000;
            }
            writer.put3(val);
            char highwayIndex = (char)this.exit.getHighway().getIndex();
            if (numHighways > 255L) {
                writer.putChar(highwayIndex);
            } else {
                writer.put((byte)highwayIndex);
            }
            if (ef != null) {
                char exitFacilityIndex = (char)ef.getIndex();
                if (numExitFacilities > 255L) {
                    writer.putChar(exitFacilityIndex);
                } else {
                    writer.put((byte)exitFacilityIndex);
                }
            }
        }
    }

    byte getPOIFlags() {
        byte b = 0;
        if (this.streetName != null) {
            b = (byte)(b | 2);
        }
        if (this.simpleStreetNumber.isUsed() || this.streetNumberName != null) {
            b = (byte)(b | 1);
        }
        if (this.city != null) {
            b = (byte)(b | 4);
        }
        if (this.zip != null) {
            b = (byte)(b | 8);
        }
        if (this.simplePhoneNumber.isUsed() || this.complexPhoneNumber != null) {
            b = (byte)(b | 0x10);
        }
        if (this.exit != null) {
            b = (byte)(b | 0x20);
        }
        return b;
    }

    byte getWrittenPOIFlags(byte POIGlobalFlags) {
        int flag = 0;
        int j = 0;
        byte usedFields = this.getPOIFlags();
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            int mask = 1 << i;
            if ((mask & POIGlobalFlags) != mask) continue;
            if ((mask & usedFields) == mask) {
                flag |= 1 << j;
            }
            ++j;
        }
        return (byte)(flag |= 0x80);
    }

    int calcOffset(int ofs, byte POIGlobalFlags, long numCities, long numZips, long numHighways, long numExitFacilities) {
        this.offset = ofs;
        int size = 3;
        if (this.exit != null) {
            size += 3;
            size += numHighways > 255L ? 2 : 1;
            if (!this.exit.getFacilities().isEmpty()) {
                size += numExitFacilities > 255L ? 2 : 1;
            }
        }
        if (POIGlobalFlags != this.getPOIFlags()) {
            ++size;
        }
        if (this.simpleStreetNumber.isUsed()) {
            size += this.simpleStreetNumber.getSize();
        }
        if (this.streetNumberName != null) {
            size += 3;
        }
        if (this.simplePhoneNumber.isUsed()) {
            size += this.simplePhoneNumber.getSize();
        }
        if (this.complexPhoneNumber != null) {
            size += 3;
        }
        if (this.streetName != null) {
            size += 3;
        }
        if (this.city != null) {
            size = numCities > 255L ? (size += 2) : ++size;
        }
        if (this.zip != null) {
            size = numZips > 255L ? (size += 2) : ++size;
        }
        return size;
    }

    public int getOffset() {
        if (this.offset == -1) {
            throw new IllegalStateException("Offset not known yet.");
        }
        return this.offset;
    }

    public Label getNameLabel() {
        return this.poiName;
    }

    public City getCity() {
        return this.city;
    }

    class SimpleStreetPhoneNumber {
        private byte[] encodedNumber;
        private int encodedSize;

        SimpleStreetPhoneNumber() {
        }

        public boolean set(String str) {
            String number = str.trim();
            this.encodedNumber = new byte[number.length() / 2 + 2];
            int i = 0;
            int j = 0;
            while (i < number.length()) {
                int c1 = this.decodeChar(number.charAt(i++));
                int c2 = i < number.length() ? this.decodeChar(number.charAt(i++)) : 10;
                if (c1 < 0 || c1 > 10 || c2 < 0 || c2 > 10) {
                    return false;
                }
                int val = c1 * 11 + c2;
                if (j == 0) {
                    val |= 0x80;
                }
                this.encodedNumber[j++] = (byte)val;
            }
            if (j == 0) {
                return false;
            }
            if (j == 1) {
                this.encodedNumber[j++] = -8;
            } else {
                int n = j - 1;
                this.encodedNumber[n] = (byte)(this.encodedNumber[n] | 0x80);
            }
            this.encodedSize = j;
            return true;
        }

        public void write(ImgFileWriter writer) {
            for (int i = 0; i < this.encodedSize; ++i) {
                writer.put(this.encodedNumber[i]);
            }
        }

        public boolean isUsed() {
            return this.encodedSize > 0;
        }

        public int getSize() {
            return this.encodedSize;
        }

        private int decodeChar(char ch) {
            if (ch == '-') {
                return 10;
            }
            if (ch >= '0' && ch <= '9') {
                return ch - 48;
            }
            return -1;
        }
    }
}

