/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr11Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.PrefixIndex;

public class Mdr17
extends MdrSection {
    private PrefixIndex streets;
    private PrefixIndex streetsByCountry;
    private PrefixIndex cities;
    private PrefixIndex pois;

    public Mdr17(MdrConfig config) {
        this.setConfig(config);
        this.streets = new PrefixIndex(this.getConfig(), 4);
        this.streetsByCountry = new PrefixIndex(this.getConfig(), 4);
        this.cities = new PrefixIndex(this.getConfig(), 2);
        this.pois = new PrefixIndex(this.getConfig(), 4);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        this.writeSubSect(writer, this.streets);
        this.writeSubSect(writer, this.cities);
        this.writeSubSect(writer, this.streetsByCountry);
        this.writeSubSect(writer, this.pois);
    }

    private void writeSubSect(ImgFileWriter writer, PrefixIndex index) {
        index.preWrite();
        int len = index.getItemSize() * index.getNumberOfItems() + 2;
        if (len == 2) {
            return;
        }
        len = (len << 1) + 1;
        int mask = -256;
        int count = 1;
        while ((len & mask) != 0) {
            mask <<= 8;
            len <<= 1;
            ++count;
        }
        this.putN(writer, count, len);
        int prefixLength = index.getPrefixLength();
        int header = prefixLength - 1 << 8;
        header += (prefixLength + 1) * (prefixLength + 1);
        writer.putChar((char)(header += (index.getItemSize() - prefixLength - 1) * 10));
        index.writeSectData(writer);
    }

    @Override
    protected void releaseMemory() {
        this.streets = null;
        this.cities = null;
        this.streetsByCountry = null;
        this.pois = null;
    }

    public void addStreets(List<Mdr7Record> streetList) {
        this.streets.createFromList(streetList);
    }

    public void addCities(List<Mdr5Record> cityList) {
        this.cities.createFromList(cityList);
    }

    public void addStreetsByCountry(List<Mdr7Record> streets) {
        this.streetsByCountry.createFromList(streets, true);
    }

    public void addPois(List<Mdr11Record> poiList) {
        this.pois.createFromList(poiList);
    }

    @Override
    public int getItemSize() {
        return 0;
    }

    @Override
    protected int numberOfItems() {
        return 0;
    }
}

