/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.Mdr2x;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.srt.MultiSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr20
extends Mdr2x {
    public Mdr20(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromStreets(List<Mdr7Record> inStreets) {
        Sort sort = this.getConfig().getSort();
        HashMap<String, byte[]> cache = new HashMap<String, byte[]>();
        ArrayList<MultiSortKey<Object>> keys = new ArrayList<MultiSortKey<Object>>();
        for (Mdr7Record s : inStreets) {
            Mdr5Record city = s.getCity();
            if (city == null) continue;
            String name = city.getName();
            if (name == null || name.isEmpty()) assert (false);
            SortKey<Mdr7Record> cityKey = sort.createSortKey(s, city.getName(), 0, cache);
            SortKey<Object> regionKey = sort.createSortKey(null, city.getRegionName(), 0, cache);
            SortKey<Object> countryStreetKey = sort.createSortKey(null, city.getCountryName(), s.getIndex(), cache);
            MultiSortKey<Object> key = new MultiSortKey<Object>(cityKey, regionKey, countryStreetKey);
            keys.add(key);
        }
        Collections.sort(keys);
        Collator collator = this.getConfig().getSort().getCollator();
        String lastName = null;
        String lastPartialName = null;
        Mdr5Record lastCity = null;
        int record = 0;
        int cityRecord = 1;
        int lastMapNumber = 0;
        for (SortKey sortKey : keys) {
            Mdr7Record street = (Mdr7Record)sortKey.getObject();
            String name = street.getName();
            String partialName = street.getPartialName();
            Mdr5Record city = street.getCity();
            boolean citySameByName = city.isSameByName(collator, lastCity);
            int mapNumber = city.getMapIndex();
            if (!(citySameByName && mapNumber == lastMapNumber && lastName != null && lastPartialName != null && name.equals(lastName) && partialName.equals(lastPartialName))) {
                ++record;
                this.streets.add(street);
                lastName = name;
                lastPartialName = partialName;
            }
            if (citySameByName) {
                assert (cityRecord != 0);
                city.setMdr20(cityRecord);
            } else {
                assert (cityRecord != 0);
                cityRecord = record;
                city.setMdr20(cityRecord);
                lastCity = city;
            }
            lastMapNumber = mapNumber;
        }
    }

    @Override
    protected boolean sameGroup(Mdr7Record street1, Mdr7Record street2) {
        return street2 != null && street1.getCity().getMdr20() == street2.getCity().getMdr20();
    }

    @Override
    public int getExtraValue() {
        return this.isForDevice() ? 14 : 34816;
    }
}

