/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr24
extends MdrSection {
    private final List<Mdr14Record> countries = new ArrayList<Mdr14Record>();

    public Mdr24(MdrConfig config) {
        this.setConfig(config);
    }

    public void sortCountries(List<Mdr14Record> list) {
        Sort sort = this.getConfig().getSort();
        List<SortKey<Mdr14Record>> keys = MdrUtils.sortList(sort, list);
        Collections.sort(keys);
        String lastName = null;
        int lastMapIndex = 0;
        int record = 0;
        for (SortKey<Mdr14Record> key : keys) {
            Mdr14Record c = key.getObject();
            String name = c.getName();
            if (lastMapIndex == c.getMapIndex() && name.equals(lastName)) continue;
            c.getMdr29().setMdr24(++record);
            this.countries.add(c);
            lastName = name;
            lastMapIndex = c.getMapIndex();
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        String lastName = null;
        for (Mdr14Record c : this.countries) {
            this.putMapIndex(writer, c.getMapIndex());
            int flag = 0;
            String name = c.getName();
            if (!name.equals(lastName)) {
                flag = 0x800000;
                lastName = name;
            }
            writer.putChar((char)c.getCountryIndex());
            writer.put3(c.getLblOffset() | flag);
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        return sizes.getMapSize() + 2 + 3;
    }

    @Override
    protected int numberOfItems() {
        return this.countries.size();
    }
}

