/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr8Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr8
extends MdrSection
implements HasHeaderFlags {
    private static final int STRING_WIDTH = 4;
    private List<Mdr8Record> index = new ArrayList<Mdr8Record>();

    public Mdr8(MdrConfig config) {
        this.setConfig(config);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int size = this.associatedSize();
        Charset charset = this.getConfig().getSort().getCharset();
        for (Mdr8Record s : this.index) {
            writer.put(s.getPrefix().getBytes(charset), 0, 4);
            this.putN(writer, size, s.getRecordNumber());
        }
    }

    protected int associatedSize() {
        return this.getSizes().getStreetSize();
    }

    @Override
    protected int numberOfItems() {
        return this.index.size();
    }

    @Override
    public int getItemSize() {
        return 4 + this.associatedSize();
    }

    public void setIndex(List<Mdr8Record> index) {
        this.index = index;
    }

    @Override
    public int getExtraValue() {
        return 1034;
    }
}

