/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.imgfmt.app.trergn.PointOverview;
import uk.me.parabola.imgfmt.app.trergn.PolygonOverview;
import uk.me.parabola.imgfmt.app.trergn.PolylineOverview;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREHeader;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.Configurable;
import uk.me.parabola.util.EnhancedProperties;

public class TREFile
extends ImgFile
implements Configurable {
    private static final Logger log = Logger.getLogger(TREFile.class);
    private final Zoom[] mapLevels = new Zoom[16];
    private final List<Label> copyrights = new ArrayList<Label>();
    private final List<PolylineOverview> polylineOverviews = new ArrayList<PolylineOverview>();
    private final List<PolygonOverview> polygonOverviews = new ArrayList<PolygonOverview>();
    private final List<PointOverview> pointOverviews = new ArrayList<PointOverview>();
    private int lastRgnPos;
    private final TREHeader header = new TREHeader();

    public TREFile(ImgChannel chan) {
        this.setHeader(this.header);
        this.setWriter(new BufferedImgFileWriter(chan));
        this.position(this.header.getHeaderLength());
    }

    public Zoom createZoom(int zoom, int bits) {
        Zoom z;
        this.mapLevels[zoom] = z = new Zoom(zoom, bits);
        return z;
    }

    public void addInfo(String msg) {
        byte[] val = Utils.toBytes(msg);
        if (this.position() != this.header.getHeaderLength() + this.header.getMapInfoSize()) {
            throw new IllegalStateException("All info must be added before anything else");
        }
        this.header.setMapInfoSize(this.header.getMapInfoSize() + (val.length + 1));
        this.getWriter().put(val);
        this.getWriter().put((byte)0);
    }

    public void addCopyright(Label cr) {
        this.copyrights.add(cr);
    }

    public void addPointOverview(PointOverview ov) {
        this.pointOverviews.add(ov);
    }

    public void addPolylineOverview(PolylineOverview ov) {
        this.polylineOverviews.add(ov);
    }

    public void addPolygonOverview(PolygonOverview ov) {
        this.polygonOverviews.add(ov);
    }

    @Override
    public void config(EnhancedProperties props) {
        this.header.config(props);
    }

    private void writeBody(boolean includeExtendedTypeData) {
        this.writeMapLevels();
        this.writeSubdivs();
        this.writeCopyrights();
        this.writeOverviews();
        if (includeExtendedTypeData) {
            this.writeExtTypeOffsetsRecords();
            this.writeExtTypeOverviews();
        }
    }

    private void writeSubdivs() {
        Subdivision sd;
        Iterator<Subdivision> it;
        Zoom z;
        int i;
        this.header.setSubdivPos(this.position());
        int subdivnum = 1;
        for (i = 15; i >= 0; --i) {
            z = this.mapLevels[i];
            if (z == null) continue;
            it = z.subdivIterator();
            while (it.hasNext()) {
                sd = it.next();
                log.debug("setting number to", subdivnum);
                sd.setNumber(subdivnum++);
            }
        }
        for (i = 15; i >= 0; --i) {
            z = this.mapLevels[i];
            if (z == null) continue;
            it = z.subdivIterator();
            while (it.hasNext()) {
                sd = it.next();
                sd.write(this.getWriter());
                if (sd.hasNextLevel()) {
                    this.header.setSubdivSize(this.header.getSubdivSize() + 16);
                    continue;
                }
                this.header.setSubdivSize(this.header.getSubdivSize() + 14);
            }
        }
        this.getWriter().putInt(this.lastRgnPos);
        this.header.setSubdivSize(this.header.getSubdivSize() + 4);
    }

    private void writeExtTypeOffsetsRecords() {
        this.header.setExtTypeOffsetsPos(this.position());
        Subdivision sd = null;
        for (int i = 15; i >= 0; --i) {
            Zoom z = this.mapLevels[i];
            if (z == null) continue;
            Iterator<Subdivision> it = z.subdivIterator();
            while (it.hasNext()) {
                sd = it.next();
                sd.writeExtTypeOffsetsRecord(this.getWriter());
                this.header.incExtTypeOffsetsSize();
            }
        }
        if (sd != null) {
            sd.writeLastExtTypeOffsetsRecord(this.getWriter());
            this.header.incExtTypeOffsetsSize();
        }
    }

    private void writeMapLevels() {
        this.header.setMapLevelPos(this.position());
        for (int i = 15; i >= 0; --i) {
            Zoom z = this.mapLevels[i];
            if (z == null) continue;
            this.header.setMapLevelsSize(this.header.getMapLevelsSize() + 4);
            z.write(this.getWriter());
        }
    }

    private void writeOverviews() {
        this.header.setPointPos(this.position());
        Collections.sort(this.pointOverviews);
        for (Overview overview : this.pointOverviews) {
            if (overview.hasExtType()) continue;
            overview.setMaxLevel(this.decodeLevel(overview.getMinResolution()));
            overview.write(this.getWriter());
            this.header.incPointSize();
        }
        this.header.setPolylinePos(this.position());
        Collections.sort(this.polylineOverviews);
        for (Overview overview : this.polylineOverviews) {
            if (overview.hasExtType()) continue;
            overview.setMaxLevel(this.decodeLevel(overview.getMinResolution()));
            overview.write(this.getWriter());
            this.header.incPolylineSize();
        }
        this.header.setPolygonPos(this.position());
        Collections.sort(this.polygonOverviews);
        for (Overview overview : this.polygonOverviews) {
            if (overview.hasExtType()) continue;
            overview.setMaxLevel(this.decodeLevel(overview.getMinResolution()));
            overview.write(this.getWriter());
            this.header.incPolygonSize();
        }
    }

    private void writeExtTypeOverviews() {
        this.header.setExtTypeOverviewsPos(this.position());
        for (Overview overview : this.polylineOverviews) {
            if (!overview.hasExtType()) continue;
            overview.setMaxLevel(this.decodeLevel(overview.getMinResolution()));
            overview.write(this.getWriter());
            this.header.incExtTypeOverviewsSize();
            this.header.incNumExtTypeLineTypes();
        }
        for (Overview overview : this.polygonOverviews) {
            if (!overview.hasExtType()) continue;
            overview.setMaxLevel(this.decodeLevel(overview.getMinResolution()));
            overview.write(this.getWriter());
            this.header.incExtTypeOverviewsSize();
            this.header.incNumExtTypeAreaTypes();
        }
        for (Overview overview : this.pointOverviews) {
            if (!overview.hasExtType()) continue;
            overview.setMaxLevel(this.decodeLevel(overview.getMinResolution()));
            overview.write(this.getWriter());
            this.header.incExtTypeOverviewsSize();
            this.header.incNumExtTypePointTypes();
        }
    }

    private int decodeLevel(int minResolution) {
        Zoom top = null;
        for (int i = 15; i >= 0; --i) {
            Zoom z = this.mapLevels[i];
            if (z == null) continue;
            if (top == null) {
                top = z;
            }
            if (z.getResolution() < minResolution) continue;
            return z.getLevel();
        }
        if (top != null) {
            return top.getLevel();
        }
        return 0;
    }

    private void writeCopyrights() {
        this.header.setCopyrightPos(this.position());
        ImgFileWriter writer = this.getWriter();
        for (Label l : this.copyrights) {
            this.header.incCopyrightSize();
            writer.put3(l.getOffset());
        }
    }

    public void setLastRgnPos(int lastRgnPos) {
        this.lastRgnPos = lastRgnPos;
    }

    public void write(boolean includeExtendedTypeData) {
        this.writeBody(includeExtendedTypeData);
    }

    public void writePost() {
        this.position(0L);
        this.getHeader().writeHeader(this.getWriter());
    }

    public void setMapId(int mapid) {
        this.header.setMapId(mapid);
    }

    public void setBounds(Area area) {
        this.header.setBounds(area);
    }

    public void addPoiDisplayFlags(byte b) {
        this.header.addPoiDisplayFlags(b);
    }

    public void setDriveOnLeft(boolean b) {
        this.header.setDriveOnLeft(b);
    }
}

