/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.ArrayList;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgReader;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.lbl.LBLFileReader;
import uk.me.parabola.imgfmt.app.trergn.SubdivData;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREHeader;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.util.EnhancedProperties;

public class TREFileReader
extends ImgReader {
    private Zoom[] mapLevels;
    private Subdivision[][] levelDivs;
    private static final Subdivision[] EMPTY_SUBDIVISIONS = new Subdivision[0];
    private final TREHeader header = new TREHeader();

    public TREFileReader(ImgChannel chan) {
        this.setHeader(this.header);
        this.setReader(new BufferedImgFileReader(chan));
        this.header.readHeader(this.getReader());
        this.readMapLevels();
        this.readSubdivs();
        this.readExtTypeOffsetsRecords();
    }

    public Area getBounds() {
        return this.header.getBounds();
    }

    public Zoom[] getMapLevels() {
        return this.mapLevels;
    }

    public Subdivision[] subdivForLevel(int level) {
        for (int i = 0; i < this.mapLevels.length; ++i) {
            if (this.mapLevels[i].getLevel() != level) continue;
            return this.levelDivs[i];
        }
        return EMPTY_SUBDIVISIONS;
    }

    private void readSubdivs() {
        ImgFileReader reader = this.getReader();
        int start = this.header.getSubdivPos();
        int end = start + this.header.getSubdivSize();
        reader.position(start);
        int subdivNum = 1;
        int lastRgnOffset = reader.getu3();
        for (int count = 0; count < this.levelDivs.length && reader.position() < (long)end; ++count) {
            Subdivision[] divs = this.levelDivs[count];
            Zoom zoom = this.mapLevels[count];
            if (divs == null) break;
            for (int i = 0; i < divs.length; ++i) {
                byte flags = reader.get();
                int lon = reader.get3();
                int lat = reader.get3();
                int width = reader.getChar() & Short.MAX_VALUE;
                int height = reader.getChar() & 0xFFFF;
                if (count < this.levelDivs.length - 1) {
                    reader.getChar();
                }
                int endRgnOffset = reader.getu3();
                SubdivData subdivData = new SubdivData(flags, lat, lon, 2 * width, 2 * height, lastRgnOffset, endRgnOffset);
                Subdivision subdiv = Subdivision.readSubdivision(this.mapLevels[count], subdivData);
                subdiv.setNumber(subdivNum++);
                divs[i] = subdiv;
                zoom.addSubdivision(subdiv);
                lastRgnOffset = endRgnOffset;
            }
        }
    }

    private void readExtTypeOffsetsRecords() {
        Subdivision[] divs;
        ImgFileReader reader = this.getReader();
        int start = this.header.getExtTypeOffsetsPos();
        int end = start + this.header.getExtTypeOffsetsSize();
        int skipBytes = this.header.getExtTypeSectionSize() - 13;
        reader.position(start);
        Subdivision sd = null;
        Subdivision sdPrev = null;
        for (int count = 0; count < this.levelDivs.length && reader.position() < (long)end && (divs = this.levelDivs[count]) != null; ++count) {
            for (int i = 0; i < divs.length; ++i) {
                sdPrev = sd;
                sd = divs[i];
                sd.readExtTypeOffsetsRecord(reader, sdPrev);
                if (skipBytes <= 0) continue;
                reader.get(skipBytes);
            }
        }
        if (sd != null) {
            sd.readLastExtTypeOffsetsRecord(reader);
            if (skipBytes > 0) {
                reader.get(skipBytes);
            }
        }
    }

    private void readMapLevels() {
        ImgFileReader reader = this.getReader();
        int levelsPos = this.header.getMapLevelsPos();
        int levelsSize = this.header.getMapLevelsSize();
        reader.position(levelsPos);
        ArrayList<Subdivision[]> levelDivs = new ArrayList<Subdivision[]>();
        ArrayList<Zoom> mapLevels = new ArrayList<Zoom>();
        int end = levelsPos + levelsSize;
        while (reader.position() < (long)end) {
            int level = reader.get();
            byte nbits = reader.get();
            char ndivs = reader.getChar();
            Subdivision[] divs = new Subdivision[ndivs];
            levelDivs.add(divs);
            Zoom z = new Zoom(level &= 0x7F, nbits);
            mapLevels.add(z);
        }
        this.levelDivs = (Subdivision[][])levelDivs.toArray((T[])new Subdivision[levelDivs.size()][]);
        this.mapLevels = mapLevels.toArray(new Zoom[mapLevels.size()]);
    }

    @Override
    public void config(EnhancedProperties props) {
        this.header.config(props);
    }

    public String[] getMapInfo() {
        ArrayList<String> msgs = new ArrayList<String>();
        ImgFileReader reader = this.getReader();
        reader.position(this.header.getHeaderLength());
        while (reader.position() < (long)(this.header.getHeaderLength() + this.header.getMapInfoSize())) {
            String m = reader.getZString();
            msgs.add(m);
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    public String[] getCopyrights(LBLFileReader lblReader) {
        Section sect = this.header.getCopyrightSection();
        ImgFileReader reader = this.getReader();
        ArrayList<String> msgs = new ArrayList<String>();
        for (long pos = (long)sect.getPosition(); pos < (long)sect.getEndPos(); pos += (long)sect.getItemSize()) {
            reader.position(pos);
            int offset = reader.get3();
            Label label = lblReader.fetchLabel(offset);
            if (label == null) continue;
            msgs.add(label.getText());
        }
        return msgs.toArray(new String[msgs.size()]);
    }
}

