/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.SectionWriter;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.app.typ.TYPHeader;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.imgfmt.app.typ.TypElement;
import uk.me.parabola.imgfmt.app.typ.TypIconSet;
import uk.me.parabola.imgfmt.app.typ.TypLabelException;
import uk.me.parabola.imgfmt.app.typ.TypParam;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class TYPFile
extends ImgFile {
    private static final Logger log = Logger.getLogger(TYPFile.class);
    private final TYPHeader header = new TYPHeader();
    private TypData data;
    private final Map<Integer, Integer> strToType = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> typeToStr = new TreeMap<Integer, Integer>();

    public TYPFile(ImgChannel chan) {
        this.setHeader(this.header);
        this.setWriter(new BufferedImgFileWriter(chan));
        this.position(156L);
    }

    public void write() {
        ImgFileWriter writer = this.getWriter();
        writer.position(156L);
        this.writeSection(writer, this.header.getPolygonData(), this.header.getPolygonIndex(), this.data.getPolygons());
        this.writeSection(writer, this.header.getLineData(), this.header.getLineIndex(), this.data.getLines());
        this.writeSection(writer, this.header.getPointData(), this.header.getPointIndex(), this.data.getPoints());
        SectionWriter subWriter = this.header.getShapeStacking().makeSectionWriter(writer);
        this.data.getStacking().write(subWriter);
        Utils.closeFile(subWriter);
        this.writeSection(writer, this.header.getIconData(), this.header.getIconIndex(), this.data.getIcons());
        this.writeLabels(writer);
        this.writeStrIndex(writer);
        this.writerTypeIndex(writer);
        this.zapZero(this.header.getShapeStacking(), this.header.getLabels(), this.header.getStringIndex(), this.header.getTypeIndex());
        log.debug((Object)"syncing TYP file");
        this.position(0L);
        this.getHeader().writeHeader(this.getWriter());
    }

    private void writeLabels(ImgFileWriter in) {
        if (this.data.getIcons().isEmpty()) {
            return;
        }
        SectionWriter writer = this.header.getLabels().makeSectionWriter(in);
        ArrayList<SortKey<TypIconSet>> keys = new ArrayList<SortKey<TypIconSet>>();
        Sort sort = this.data.getSort();
        for (TypIconSet typIconSet : this.data.getIcons()) {
            String label = typIconSet.getLabel();
            if (label == null) continue;
            SortKey<TypIconSet> key = sort.createSortKey(typIconSet, label);
            keys.add(key);
        }
        Collections.sort(keys);
        writer.put((byte)0);
        for (SortKey sortKey : keys) {
            int off = writer.position();
            TypIconSet icon = (TypIconSet)sortKey.getObject();
            int type = icon.getTypeForFile();
            String label = icon.getLabel();
            if (label == null) continue;
            CharBuffer cb = CharBuffer.wrap(label);
            CharsetEncoder encoder = this.data.getEncoder();
            try {
                ByteBuffer buffer = encoder.encode(cb);
                writer.put(buffer);
                this.strToType.put(off, type);
                this.typeToStr.put(type, off);
            }
            catch (CharacterCodingException ignore) {
                String name = encoder.charset().name();
                throw new TypLabelException(name);
            }
            writer.put((byte)0);
        }
        Utils.closeFile(writer);
    }

    private void writeStrIndex(ImgFileWriter in) {
        SectionWriter writer = this.header.getStringIndex().makeSectionWriter(in);
        int psize = this.ptrSize(this.header.getLabels().getSize());
        this.header.getStringIndex().setItemSize((char)(3 + psize));
        for (Map.Entry<Integer, Integer> ent : this.strToType.entrySet()) {
            this.putN(writer, psize, ent.getKey());
            this.putN(writer, 3, ent.getValue());
        }
        Utils.closeFile(writer);
    }

    private void writerTypeIndex(ImgFileWriter in) {
        SectionWriter writer = this.header.getTypeIndex().makeSectionWriter(in);
        int psize = this.ptrSize(this.header.getLabels().getSize());
        this.header.getTypeIndex().setItemSize((char)(3 + psize));
        for (Map.Entry<Integer, Integer> ent : this.typeToStr.entrySet()) {
            this.putN(writer, 3, ent.getKey());
            this.putN(writer, psize, ent.getValue());
        }
        Utils.closeFile(writer);
    }

    private void writeSection(ImgFileWriter writer, Section dataSection, Section indexSection, List<? extends TypElement> elementData) {
        Collections.sort(elementData);
        SectionWriter subWriter = dataSection.makeSectionWriter(writer);
        CharsetEncoder encoder = this.data.getEncoder();
        for (TypElement typElement : elementData) {
            typElement.write(subWriter, encoder);
        }
        Utils.closeFile(subWriter);
        int size = dataSection.getSize();
        char c = indexSection.getItemSize();
        int psize = this.ptrSize(size);
        indexSection.setItemSize((char)(c + psize));
        subWriter = indexSection.makeSectionWriter(writer);
        for (TypElement typElement : elementData) {
            int offset = typElement.getOffset();
            int type = typElement.getTypeForFile();
            this.putN(subWriter, c, type);
            this.putN(subWriter, psize, offset);
        }
        Utils.closeFile(subWriter);
        this.zapZero(dataSection, indexSection);
    }

    private void zapZero(Section ... sect) {
        for (Section s : sect) {
            if (s.getSize() != 0) continue;
            s.setPosition(0);
            s.setItemSize('\u0000');
        }
    }

    private int ptrSize(int size) {
        int psize = 1;
        if (size > 0xFFFFFF) {
            psize = 4;
        } else if (size > 65535) {
            psize = 3;
        } else if (size > 255) {
            psize = 2;
        }
        return psize;
    }

    protected void putN(ImgFileWriter writer, int n, int value) {
        switch (n) {
            case 1: {
                writer.put((byte)value);
                break;
            }
            case 2: {
                writer.putChar((char)value);
                break;
            }
            case 3: {
                writer.put3(value);
                break;
            }
            case 4: {
                writer.putInt(value);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void setData(TypData data) {
        this.data = data;
        TypParam param = data.getParam();
        this.header.setCodePage((char)param.getCodePage());
        this.header.setFamilyId((char)param.getFamilyId());
        this.header.setProductId((char)param.getProductId());
    }
}

