/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.mdxfmt;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import uk.me.parabola.imgfmt.mdxfmt.MapInfo;

public class MdxFile {
    private final char familyId;
    private final char productId;
    private final List<MapInfo> maps = new ArrayList<MapInfo>();

    public MdxFile(int familyId, int productId) {
        this.familyId = (char)familyId;
        this.productId = (char)productId;
    }

    public void addMap(int name, int hexname, String filename) {
        MapInfo info = new MapInfo();
        info.setHexMapname(hexname);
        info.setMapname(name);
        info.setFamilyId(this.familyId);
        info.setProductId(this.productId);
        info.setFilename(filename);
        this.maps.add(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String filename) throws IOException {
        FileOutputStream stream = new FileOutputStream(filename);
        FileChannel chan = stream.getChannel();
        ByteBuffer buf = ByteBuffer.allocate(1024);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.writeHeader(chan, buf);
            this.writeBody(chan, buf);
        }
        finally {
            chan.close();
        }
    }

    private void writeHeader(WritableByteChannel chan, ByteBuffer buf) throws IOException {
        try {
            buf.put("Midx".getBytes("ascii"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Could not write header");
        }
        buf.putChar('d');
        buf.putInt(12);
        buf.putInt(this.maps.size());
        buf.flip();
        chan.write(buf);
    }

    private void writeBody(WritableByteChannel chan, ByteBuffer buf) throws IOException {
        Collections.sort(this.maps, new Comparator<MapInfo>(){

            @Override
            public int compare(MapInfo o1, MapInfo o2) {
                if (o1.getHexMapname() == o2.getHexMapname()) {
                    return 0;
                }
                if (o1.getHexMapname() < o2.getHexMapname()) {
                    return -1;
                }
                return 1;
            }
        });
        for (MapInfo info : this.maps) {
            if (info.getHexMapname() == 0 || info.getMapname() == 0) {
                System.err.println("Invalid mapname for " + info.getFilename() + ", perhaps it is not a .img file");
            }
            buf.compact();
            info.write(buf);
            buf.flip();
            chan.write(buf);
        }
    }
}

