/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.List;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.BlockManager;
import uk.me.parabola.imgfmt.sys.Directory;
import uk.me.parabola.imgfmt.sys.Dirent;
import uk.me.parabola.imgfmt.sys.FileNode;
import uk.me.parabola.imgfmt.sys.ImgHeader;
import uk.me.parabola.log.Logger;

public class ImgFS
implements FileSystem {
    private static final Logger log = Logger.getLogger(ImgFS.class);
    static final String DIRECTORY_FILE_NAME = "        .   ";
    private final FileChannel file;
    private boolean readOnly = true;
    private ImgHeader header;
    private Directory directory;
    private BlockManager fileBlockManager;
    private static final long ENTRY_BLOCK_SIZE = 512L;
    private BlockManager headerBlockManager;
    private byte xorByte;

    private ImgFS(FileChannel chan) {
        this.file = chan;
    }

    public static FileSystem createFs(String filename, FileSystemParam params) throws FileNotWritableException {
        params.setFilename(filename);
        try {
            RandomAccessFile rafile = new RandomAccessFile(filename, "rw");
            return ImgFS.createFs(rafile.getChannel(), params);
        }
        catch (FileNotFoundException e) {
            throw new FileNotWritableException("Could not create file: " + params.getFilename(), e);
        }
    }

    private static FileSystem createFs(FileChannel chan, FileSystemParam params) throws FileNotWritableException {
        assert (params != null);
        try {
            chan.truncate(0L);
        }
        catch (IOException e) {
            throw new FileNotWritableException("Failed to truncate file", e);
        }
        ImgFS fs = new ImgFS(chan);
        fs.createInitFS(chan, params);
        return fs;
    }

    public static FileSystem openFs(String name) throws FileNotFoundException {
        RandomAccessFile rafile = new RandomAccessFile(name, "r");
        return ImgFS.openFs(name, rafile.getChannel());
    }

    private static FileSystem openFs(String name, FileChannel chan) throws FileNotFoundException {
        ImgFS fs = new ImgFS(chan);
        try {
            fs.readInitFS(chan);
        }
        catch (IOException e) {
            throw new FileNotFoundException(name + ": " + e.getMessage());
        }
        return fs;
    }

    @Override
    public ImgChannel create(String name) throws FileExistsException {
        Dirent dir = this.directory.create(name, this.fileBlockManager);
        return new FileNode(this.file, dir, "w");
    }

    @Override
    public ImgChannel open(String name, String mode) throws FileNotFoundException {
        if (name == null || mode == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (mode.indexOf(114) >= 0) {
            Dirent ent = this.internalLookup(name);
            FileNode fn = new FileNode(this.file, ent, "r");
            if (this.xorByte != 0) {
                fn.setXorByte(this.xorByte);
            }
            return fn;
        }
        if (mode.indexOf(119) >= 0) {
            Dirent ent;
            try {
                ent = this.internalLookup(name);
            }
            catch (FileNotFoundException e) {
                try {
                    ent = this.directory.create(name, this.fileBlockManager);
                }
                catch (FileExistsException e1) {
                    throw new FileNotFoundException("Attempt to duplicate a file name");
                }
            }
            return new FileNode(this.file, ent, "w");
        }
        throw new IllegalArgumentException("Invalid mode given");
    }

    @Override
    public DirectoryEntry lookup(String name) throws FileNotFoundException {
        return this.internalLookup(name);
    }

    @Override
    public List<DirectoryEntry> list() {
        return this.directory.getEntries();
    }

    @Override
    public FileSystemParam fsparam() {
        return this.header.getParams();
    }

    @Override
    public void fsparam(FileSystemParam param) {
        int reserved = param.getReservedDirectoryBlocks() + 2;
        this.fileBlockManager.setCurrentBlock(reserved);
        this.headerBlockManager.setMaxBlock(reserved);
    }

    @Override
    public void sync() throws IOException {
        if (this.readOnly) {
            return;
        }
        this.header.setNumBlocks(this.fileBlockManager.getMaxBlockAllocated());
        this.header.sync();
        this.directory.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.sync();
        }
        catch (IOException e) {
            log.debug((Object)"could not sync filesystem");
        }
        finally {
            try {
                this.file.close();
            }
            catch (IOException e) {
                log.warn((Object)"Could not close file");
            }
        }
    }

    private void createInitFS(FileChannel chan, FileSystemParam params) throws FileNotWritableException {
        this.readOnly = false;
        this.headerBlockManager = new BlockManager(params.getBlockSize(), 0);
        this.headerBlockManager.setMaxBlock(params.getReservedDirectoryBlocks());
        try {
            this.directory = new Directory(this.headerBlockManager, params.getDirectoryStartEntry());
            Dirent ent = this.directory.create(DIRECTORY_FILE_NAME, this.headerBlockManager);
            ent.setSpecial(true);
            ent.setInitialized(true);
            FileNode f = new FileNode(chan, ent, "w");
            this.directory.setFile(f);
            this.header = new ImgHeader(f);
            this.header.createHeader(params);
        }
        catch (FileExistsException e) {
            throw new FileNotWritableException("Could not create img file directory", e);
        }
        this.fileBlockManager = new BlockManager(params.getBlockSize(), params.getReservedDirectoryBlocks());
        assert (this.header != null);
    }

    private void readInitFS(FileChannel chan) throws IOException {
        ByteBuffer headerBuf = ByteBuffer.allocate(512);
        headerBuf.order(ByteOrder.LITTLE_ENDIAN);
        chan.read(headerBuf);
        this.xorByte = headerBuf.get(0);
        if (this.xorByte != 0) {
            byte[] headerBytes = headerBuf.array();
            int i = 0;
            while (i < headerBytes.length) {
                int n = i++;
                headerBytes[n] = (byte)(headerBytes[n] ^ this.xorByte);
            }
        }
        if (headerBuf.position() < 512) {
            throw new IOException("File too short or corrupted");
        }
        this.header = new ImgHeader(null);
        this.header.setHeader(headerBuf);
        FileSystemParam params = this.header.getParams();
        BlockManager headerBlockManager = new BlockManager(params.getBlockSize(), 0);
        headerBlockManager.setMaxBlock(params.getReservedDirectoryBlocks());
        this.directory = new Directory(headerBlockManager, params.getDirectoryStartEntry());
        this.directory.setStartPos((long)params.getDirectoryStartEntry() * 512L);
        Dirent ent = this.directory.create(DIRECTORY_FILE_NAME, headerBlockManager);
        FileNode f = new FileNode(chan, ent, "r");
        this.header.setFile(f);
        this.directory.setFile(f);
        this.directory.readInit(this.xorByte);
    }

    private Dirent internalLookup(String name) throws FileNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("null name argument");
        }
        Dirent ent = (Dirent)this.directory.lookup(name);
        if (ent == null) {
            throw new FileNotFoundException(name + " not found");
        }
        return ent;
    }
}

