/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.IOException;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.mdxfmt.MdxFile;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;

public class MdxBuilder
implements Combiner {
    private MdxFile mdx;
    private String mdxFilename;
    private String outputDir;

    @Override
    public void init(CommandArgs args) {
        int familyId = args.get("family-id", 6324);
        int productId = args.get("product-id", 1);
        this.mdxFilename = args.get("overview-mapname", "osm") + ".mdx";
        this.mdx = new MdxFile(familyId, productId);
        this.outputDir = args.getOutputDir();
    }

    @Override
    public void onMapEnd(FileInfo info) {
        if (!info.isImg()) {
            return;
        }
        this.mdx.addMap(info.getMapnameAsInt(), info.getHexname(), info.getFilename());
    }

    @Override
    public void onFinish() {
        try {
            this.mdx.write(Utils.joinPath(this.outputDir, this.mdxFilename));
        }
        catch (IOException e) {
            throw new ExitException("Could not create MDX file", e);
        }
    }
}

