/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.trergn.LinePreparer;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapShape;

public class LinePreparerFilter
implements MapFilter {
    private int shift;
    private final Subdivision subdiv;

    public LinePreparerFilter(Subdivision subdiv) {
        this.subdiv = subdiv;
    }

    @Override
    public void init(FilterConfig config) {
        this.shift = config.getShift();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        int minPointsRequired;
        MapLine line = (MapLine)element;
        int numPoints = line.getPoints().size();
        boolean first = true;
        int n = minPointsRequired = element instanceof MapShape ? 3 : 2;
        if (minPointsRequired == 3 && line.getPoints().get(0).equals(line.getPoints().get(numPoints - 1))) {
            ++minPointsRequired;
        }
        int lastLat = 0;
        int lastLong = 0;
        int numPointsEncoded = 1;
        int[] maxBits = new int[]{0, 0};
        int[] maxBits2nd = new int[]{0, 0};
        int[] maxBitsPos = new int[]{0, 0};
        for (int i = 0; i < numPoints; ++i) {
            Coord co = line.getPoints().get(i);
            int lat = this.subdiv.roundLatToLocalShifted(co.getLatitude());
            int lon = this.subdiv.roundLonToLocalShifted(co.getLongitude());
            if (first) {
                lastLat = lat;
                lastLong = lon;
                first = false;
                continue;
            }
            int offset = 8 + this.shift;
            int dx = lon - lastLong << offset >> offset;
            int dy = lat - lastLat << offset >> offset;
            lastLong = lon;
            lastLat = lat;
            if (dx == 0 && dy == 0 && (!line.isRoad() || co.getId() == 0)) continue;
            if (++numPointsEncoded >= minPointsRequired && !(element instanceof MapShape)) break;
            for (int k = 0; k < 2; ++k) {
                int nBits = LinePreparer.bitsNeeded(k == 0 ? dx : dy);
                if (nBits <= maxBits2nd[k]) continue;
                if (nBits > maxBits[k]) {
                    maxBits2nd[k] = maxBits[k];
                    maxBits[k] = nBits;
                    maxBitsPos[k] = i;
                    continue;
                }
                maxBits2nd[k] = nBits;
            }
        }
        if (numPointsEncoded < minPointsRequired) {
            return;
        }
        if (minPointsRequired >= 3) {
            int maxReduction = 0;
            int rotation = 0;
            for (int k = 0; k < 2; ++k) {
                int delta = maxBits[k] - maxBits2nd[k];
                if (delta <= maxReduction && (delta != maxReduction || rotation <= maxBitsPos[k])) continue;
                maxReduction = delta;
                rotation = maxBitsPos[k];
            }
            if (rotation != 0) {
                List<Coord> points = line.getPoints();
                if (minPointsRequired == 4) {
                    points.remove(numPoints - 1);
                }
                Collections.rotate(points, -rotation);
                if (minPointsRequired == 4) {
                    points.add(points.get(0));
                }
            }
        }
        next.doFilter(element);
    }
}

