/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;

public class LineSplitterFilter
implements MapFilter {
    private static final Logger log = Logger.getLogger(LineSplitterFilter.class);
    public static final int MAX_POINTS_IN_LINE = 250;
    public static final int MIN_POINTS_IN_LINE = 50;
    private int level;
    private boolean isRoutable;

    @Override
    public void init(FilterConfig config) {
        this.level = config.getLevel();
        this.isRoutable = config.isRoutable();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        assert (!(element instanceof MapShape) && element instanceof MapLine);
        MapLine line = (MapLine)element;
        List<Coord> points = line.getPoints();
        int npoints = points.size();
        if (npoints <= 250) {
            next.doFilter(element);
            return;
        }
        log.debug((Object)"line has too many points, splitting");
        if (line.isRoad() && this.level == 0 && this.isRoutable) {
            MapRoad road = (MapRoad)line;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Way " + road.getRoadDef() + " has more than " + 250 + " points and is about to be split"));
            }
        }
        MapLine l = line.copy();
        ArrayList<Coord> coords = new ArrayList<Coord>();
        int count = 0;
        boolean first = true;
        int remaining = points.size();
        int wantedSize = remaining < 300 ? remaining / 2 + 10 : 250;
        for (Coord co : points) {
            coords.add(co);
            --remaining;
            if (++count < wantedSize) continue;
            if (first) {
                log.debug((Object)"saving first part");
            } else {
                log.debug((Object)"saving next part");
            }
            l.setPoints(coords);
            if (l instanceof MapRoad) {
                ((MapRoad)l).setSegmentsFollowing(true);
            }
            next.doFilter(l);
            l = line.copy();
            count = 0;
            first = false;
            coords = new ArrayList();
            coords.add(co);
            if (remaining <= 250 || remaining >= 300) continue;
            wantedSize = remaining / 2 + 10;
        }
        if (count != 0) {
            log.debug((Object)"saving a final part");
            l.setPoints(coords);
            next.doFilter(l);
        }
    }
}

