/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.filters.PolygonSplitterBase;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapShape;

public class PolygonSubdivSizeSplitterFilter
extends PolygonSplitterBase
implements MapFilter {
    private static final Logger log = Logger.getLogger(PolygonSubdivSizeSplitterFilter.class);
    private int maxSize;

    @Override
    public void init(FilterConfig config) {
        int shift = config.getShift();
        if (shift > 15) {
            shift = 16;
        }
        this.maxSize = Math.min(0xFFFFFF, Math.max(Short.MAX_VALUE << shift, 32768));
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        assert (element instanceof MapShape);
        MapShape shape = (MapShape)element;
        if (this.isSizeOk(shape)) {
            next.doFilter(element);
            return;
        }
        ArrayList<MapShape> outputs = new ArrayList<MapShape>();
        this.split(shape, outputs);
        for (int i = 0; i < outputs.size(); ++i) {
            MapShape s = (MapShape)outputs.get(i);
            if (this.isSizeOk(s)) continue;
            outputs.set(i, null);
            this.split(s, outputs);
        }
        for (MapShape s : outputs) {
            if (s == null) continue;
            next.doFilter(s);
        }
    }

    private boolean isSizeOk(MapShape shape) {
        int maxDim;
        int numPoints = shape.getPoints().size();
        int numElements = 1 + (numPoints - 1) / 250;
        int size = numElements * 11 + numPoints * 4;
        if (shape.hasExtendedType()) {
            if (size > 65280) {
                log.debug("XTSize larger than", 65280);
                return false;
            }
        } else if (size > 65528) {
            log.debug("RGN Size larger than", 65528);
            return false;
        }
        if ((maxDim = shape.getBounds().getMaxDimension()) > this.maxSize) {
            log.debug("Size ", maxDim, " larger than ", this.maxSize);
            return false;
        }
        return true;
    }
}

