/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.osmstyle.WrongAngleFixer;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.util.MultiHashMap;

public class ShapeMergeFilter {
    private static final Logger log = Logger.getLogger(ShapeMergeFilter.class);
    private final int resolution;
    private final ShapeHelper dupShape = new ShapeHelper(new ArrayList<Coord>(0));
    private static final long smallArea = 4096L;

    public ShapeMergeFilter(int resolution) {
        this.resolution = resolution;
    }

    public List<MapShape> merge(List<MapShape> shapes) {
        if (shapes.size() <= 1) {
            return shapes;
        }
        int count = 0;
        MultiHashMap topMap = new MultiHashMap();
        ArrayList<MapShape> mergedShapes = new ArrayList<MapShape>();
        for (MapShape shape : shapes) {
            if (shape.getMinResolution() > this.resolution || shape.getMaxResolution() < this.resolution) continue;
            ++count;
            if (shape.getPoints().get(0) != shape.getPoints().get(shape.getPoints().size() - 1)) {
                log.error("shape is not closed with identical points", shape.getOsmid());
                mergedShapes.add(shape);
                continue;
            }
            Object sameTypeList = topMap.get(shape.getType());
            ShapeHelper sh = new ShapeHelper(shape.getPoints());
            sh.id = shape.getOsmid();
            if (sh.areaTestVal == 0L) {
                log.error("ignoring shape with id", sh.id, "and type", GType.formatType(shape.getType()), "at resolution", this.resolution + ", it", shape.wasClipped() ? "was clipped to" : "has", shape.getPoints().size(), "points and has an empty area ");
                continue;
            }
            if (sameTypeList.isEmpty()) {
                LinkedHashMap lowMap = new LinkedHashMap();
                ArrayList<ShapeHelper> list = new ArrayList<ShapeHelper>();
                list.add(sh);
                lowMap.put(shape, list);
                topMap.add(shape.getType(), lowMap);
                continue;
            }
            Iterator i$ = sameTypeList.iterator();
            while (i$.hasNext()) {
                Map lowMap = (Map)i$.next();
                boolean added = false;
                for (MapShape ms : lowMap.keySet()) {
                    String s2;
                    String s1 = ms.getName();
                    if (s1 != (s2 = shape.getName()) && (s1 == null || !s1.equals(s2))) continue;
                    List<ShapeHelper> list = (List<ShapeHelper>)lowMap.get(ms);
                    int oldSize = list.size();
                    list = this.addWithConnectedHoles(list, sh, ms.getType());
                    lowMap.put(ms, list);
                    if (list.size() < oldSize + 1) {
                        log.debug("shape with id", sh.id, "was merged", oldSize + 1 - list.size(), " time(s) at resolution", this.resolution);
                    }
                    added = true;
                    break;
                }
                if (added) continue;
                ArrayList<ShapeHelper> list = new ArrayList<ShapeHelper>();
                list.add(sh);
                lowMap.put(shape, list);
            }
        }
        for (List sameTypeList : topMap.values()) {
            for (Map lowMap : sameTypeList) {
                for (Map.Entry item : lowMap.entrySet()) {
                    MapShape ms = (MapShape)item.getKey();
                    List shapeHelpers = (List)item.getValue();
                    for (ShapeHelper sh : shapeHelpers) {
                        MapShape newShape = ms.copy();
                        assert (sh.getPoints().get(0) == sh.getPoints().get(sh.getPoints().size() - 1));
                        if (sh.id == 0L) {
                            List<Coord> optimizedPoints = WrongAngleFixer.fixAnglesInShape(sh.getPoints());
                            if (optimizedPoints.isEmpty()) continue;
                            newShape.setPoints(optimizedPoints);
                            newShape.setOsmid(FakeIdGenerator.makeFakeId());
                        } else {
                            newShape.setPoints(sh.getPoints());
                            newShape.setOsmid(sh.id);
                        }
                        mergedShapes.add(newShape);
                    }
                }
            }
        }
        log.info("merged shapes", count, "->", mergedShapes.size(), "at resolution", this.resolution);
        return mergedShapes;
    }

    private List<ShapeHelper> addWithConnectedHoles(List<ShapeHelper> list, ShapeHelper toAdd, int type) {
        assert (toAdd.getPoints().size() > 3);
        ArrayList<ShapeHelper> result = new ArrayList<ShapeHelper>(list.size() + 1);
        ShapeHelper shNew = new ShapeHelper(toAdd);
        for (ShapeHelper shOld : list) {
            if (!shOld.getBounds().intersects(shNew.getBounds())) {
                result.add(shOld);
                continue;
            }
            ShapeHelper mergeRes = this.tryMerge(shOld, shNew, type);
            if (mergeRes == shOld) {
                result.add(shOld);
                continue;
            }
            if (mergeRes != null) {
                shNew = mergeRes;
            }
            if (shNew != this.dupShape) continue;
            log.warn("ignoring duplicate shape with id", toAdd.id, "at", toAdd.getPoints().get(0).toOSMURL(), "with type", GType.formatType(type), "for resolution", this.resolution);
            return list;
        }
        if (shNew != null && shNew != this.dupShape) {
            result.add(shNew);
        }
        if (result.size() > list.size() + 1) {
            log.error("result list size is wrong", list.size(), "->", result.size());
        }
        return result;
    }

    private ShapeHelper tryMerge(ShapeHelper sh1, ShapeHelper sh2, int type) {
        List<Coord> points2;
        List<Coord> points1;
        boolean sameDir;
        boolean bl = sameDir = sh1.areaTestVal > 0L && sh2.areaTestVal > 0L || sh1.areaTestVal < 0L && sh2.areaTestVal < 0L;
        if (sh2.getPoints().size() > sh1.getPoints().size()) {
            points1 = sh2.getPoints();
            points2 = sh1.getPoints();
        } else {
            points1 = sh1.getPoints();
            points2 = sh2.getPoints();
        }
        IntArrayList sh1PositionsToCheck = new IntArrayList();
        IntArrayList sh2PositionsToCheck = new IntArrayList();
        this.findCommonCoords(points1, points2, sh1PositionsToCheck, sh2PositionsToCheck);
        if (sh1PositionsToCheck.isEmpty()) {
            return sh1;
        }
        if (sh2PositionsToCheck.size() + 1 >= points2.size() && points1.size() == points2.size() && Math.abs(sh1.areaTestVal) == Math.abs(sh2.areaTestVal)) {
            return this.dupShape;
        }
        List<Coord> merged = null;
        if (points1.size() + points2.size() - 2 * sh1PositionsToCheck.size() < 250) {
            merged = this.mergeLongestSequence(points1, points2, sh1PositionsToCheck, sh2PositionsToCheck, sameDir);
            if (merged.get(0) != merged.get(merged.size() - 1)) {
                merged = null;
            } else if (merged.size() > 250) {
                log.info((Object)("merge rejected: merged shape has too many points " + merged.size()));
                merged = null;
            }
        }
        ShapeHelper shm = null;
        if (merged != null) {
            shm = new ShapeHelper(merged);
            if (Math.abs(shm.areaTestVal) != Math.abs(sh1.areaTestVal) + Math.abs(sh2.areaTestVal)) {
                log.warn("merging shapes skipped for shapes near", points1.get(sh1PositionsToCheck.getInt(0)).toOSMURL(), "(maybe overlapping shapes?)");
                merged = null;
                shm = null;
            } else if (log.isInfoEnabled()) {
                log.info("merge of shapes near", points1.get(sh1PositionsToCheck.getInt(0)).toOSMURL(), "reduces number of points from", points1.size() + points2.size(), "to", merged.size());
            }
        }
        if (shm != null) {
            return shm;
        }
        if (merged == null) {
            return sh1;
        }
        return null;
    }

    private void findCommonCoords(List<Coord> s1, List<Coord> s2, IntArrayList s1PositionsToCheck, IntArrayList s2PositionsToCheck) {
        int start;
        Coord co;
        IdentityHashMap<Coord, Integer> s2PosMap = new IdentityHashMap<Coord, Integer>(s2.size() - 1);
        int i = 0;
        while (i + 1 < s1.size()) {
            co = s1.get(i);
            co.setPartOfShape2(false);
            ++i;
        }
        i = 0;
        while (i + 1 < s2.size()) {
            co = s2.get(i);
            co.setPartOfShape2(true);
            s2PosMap.put(co, i);
            ++i;
        }
        for (start = 0; start < s1.size() && (co = s1.get(start)).isPartOfShape2(); ++start) {
        }
        int pos = start + 1;
        int tested = 0;
        while (true) {
            if (pos + 1 >= s1.size()) {
                pos = 0;
            }
            Coord co2 = s1.get(pos);
            if (++tested >= s1.size()) break;
            if (co2.isPartOfShape2()) {
                s1PositionsToCheck.add(pos);
                Integer posInSh2 = (Integer)s2PosMap.get(co2);
                assert (posInSh2 != null);
                s2PositionsToCheck.add(posInSh2);
            }
            ++pos;
        }
    }

    private List<Coord> mergeLongestSequence(List<Coord> points1, List<Coord> points2, IntArrayList sh1PositionsToCheck, IntArrayList sh2PositionsToCheck, boolean sameDir) {
        if (sh1PositionsToCheck.isEmpty()) {
            return null;
        }
        int s1Size = points1.size();
        int s2Size = points2.size();
        int longestSequence = 0;
        int startOfLongestSequence = 0;
        int length = 0;
        int start = -1;
        int n1 = sh1PositionsToCheck.size();
        assert (sh2PositionsToCheck.size() == n1);
        boolean inSequence = false;
        int i = 0;
        while (i + 1 < n1) {
            int pred1 = sh1PositionsToCheck.getInt(i);
            int succ1 = sh1PositionsToCheck.getInt(i + 1);
            if (Math.abs(succ1 - pred1) == 1 || pred1 + 2 == s1Size && succ1 == 0 || succ1 + 2 == s1Size && pred1 == 0) {
                int pred2 = sh2PositionsToCheck.getInt(i);
                int succ2 = sh2PositionsToCheck.getInt(i + 1);
                if (Math.abs(succ2 - pred2) == 1 || pred2 + 2 == s2Size && succ2 == 0 || succ2 + 2 == s2Size && pred2 == 0) {
                    if (start < 0) {
                        start = i;
                    }
                    inSequence = true;
                    ++length;
                } else {
                    inSequence = false;
                }
            } else {
                inSequence = false;
            }
            if (!inSequence) {
                if (length > longestSequence) {
                    longestSequence = length;
                    startOfLongestSequence = start;
                }
                length = 0;
                start = -1;
            }
            ++i;
        }
        if (length > longestSequence) {
            longestSequence = length;
            startOfLongestSequence = start;
        }
        ArrayList<Coord> merged = new ArrayList<Coord>(s1Size + s2Size - 2 * longestSequence - 1);
        int s1Pos = sh1PositionsToCheck.getInt(startOfLongestSequence + longestSequence);
        for (int i2 = 0; i2 < s1Size - longestSequence - 1; ++i2) {
            merged.add(points1.get(s1Pos));
            if (++s1Pos + 1 < s1Size) continue;
            s1Pos = 0;
        }
        int s2Pos = sh2PositionsToCheck.getInt(startOfLongestSequence);
        int s2Step = sameDir ? 1 : -1;
        for (int i3 = 0; i3 < s2Size - longestSequence; ++i3) {
            merged.add(points2.get(s2Pos));
            if ((s2Pos += s2Step) < 0) {
                s2Pos = s2Size - 2;
                continue;
            }
            if (s2Pos + 1 < s2Size) continue;
            s2Pos = 0;
        }
        return merged;
    }

    public static long calcAreaSizeTestVal(List<Coord> points) {
        if (points.size() < 4) {
            return 0L;
        }
        if (!points.get(0).highPrecEquals(points.get(points.size() - 1))) {
            log.error((Object)"shape is not closed");
            return 0L;
        }
        Iterator<Coord> polyIter = points.iterator();
        Coord c2 = polyIter.next();
        long signedAreaSize = 0L;
        while (polyIter.hasNext()) {
            Coord c1 = c2;
            c2 = polyIter.next();
            signedAreaSize += (long)(c2.getHighPrecLon() + c1.getHighPrecLon()) * (long)(c1.getHighPrecLat() - c2.getHighPrecLat());
        }
        if (Math.abs(signedAreaSize) < 4096L) {
            log.debug("very small shape near", points.get(0).toOSMURL(), "signed area in high prec map units:", signedAreaSize);
        }
        return signedAreaSize;
    }

    private class ShapeHelper {
        private final List<Coord> points;
        long id;
        long areaTestVal;
        private final Area bounds;

        public ShapeHelper(List<Coord> merged) {
            this.points = merged;
            this.areaTestVal = ShapeMergeFilter.calcAreaSizeTestVal(this.points);
            this.bounds = this.prep();
        }

        public ShapeHelper(ShapeHelper other) {
            this.points = new ArrayList<Coord>(other.getPoints());
            this.areaTestVal = other.areaTestVal;
            this.id = other.id;
            this.bounds = new Area(other.getBounds().getMinLat(), other.getBounds().getMinLong(), other.getBounds().getMaxLat(), other.getBounds().getMaxLong());
        }

        public List<Coord> getPoints() {
            return this.points;
        }

        public Area getBounds() {
            return this.bounds;
        }

        Area prep() {
            int minLat = Integer.MAX_VALUE;
            int maxLat = Integer.MIN_VALUE;
            int minLon = Integer.MAX_VALUE;
            int maxLon = Integer.MIN_VALUE;
            for (Coord co : this.points) {
                if (co.getLatitude() > maxLat) {
                    maxLat = co.getLatitude();
                }
                if (co.getLatitude() < minLat) {
                    minLat = co.getLatitude();
                }
                if (co.getLongitude() > maxLon) {
                    maxLon = co.getLongitude();
                }
                if (co.getLongitude() >= minLon) continue;
                minLon = co.getLongitude();
            }
            return new Area(minLat, minLon, maxLat, maxLon);
        }
    }
}

