/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.Clipper;
import uk.me.parabola.mkgmap.general.LineAdder;
import uk.me.parabola.mkgmap.general.LineClipper;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.general.PolygonClipper;

public class AreaClipper
implements Clipper {
    private final Area bbox;

    public AreaClipper(Area bbox) {
        this.bbox = bbox;
    }

    @Override
    public void clipLine(MapLine line, LineAdder collector) {
        if (this.bbox == null || this.bbox.insideBoundary(line.getBounds())) {
            collector.add(line);
            return;
        }
        List<List<Coord>> list = LineClipper.clip(this.bbox, line.getPoints());
        if (list == null) {
            collector.add(line);
        } else {
            for (List<Coord> lco : list) {
                MapLine nline = line.copy();
                nline.setPoints(lco);
                collector.add(nline);
            }
        }
    }

    @Override
    public void clipShape(MapShape shape, MapCollector collector) {
        if (this.bbox == null || this.bbox.contains(shape.getBounds())) {
            collector.addShape(shape);
            return;
        }
        List<List<Coord>> list = PolygonClipper.clip(this.bbox, shape.getPoints());
        if (list == null) {
            collector.addShape(shape);
        } else {
            for (List<Coord> lco : list) {
                MapShape nshape = new MapShape(shape);
                nshape.setPoints(lco);
                nshape.setClipped(true);
                collector.addShape(nshape);
            }
        }
    }

    @Override
    public boolean contains(Coord location) {
        return this.bbox == null || this.bbox.contains(location);
    }
}

