/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.Arrays;
import uk.me.parabola.imgfmt.ExitException;

public class LevelInfo
implements Comparable<LevelInfo> {
    public static final String DEFAULT_LEVELS = "0:24, 1:22, 2:20, 3:18, 4:16";
    private final int level;
    private final int bits;
    private boolean top;

    public LevelInfo(int level, int bits) {
        this.level = level;
        this.bits = bits;
    }

    public static LevelInfo[] createFromString(String levelSpec) {
        String[] desc = levelSpec.split("[, \\t\\n]+");
        Object[] levels = new LevelInfo[desc.length];
        int count = 0;
        for (String s : desc) {
            String[] keyVal = s.split("[=:]");
            if (keyVal == null || keyVal.length < 2) {
                throw new ExitException("Error: incorrect level specification " + levelSpec);
            }
            try {
                int key = Integer.parseInt(keyVal[0]);
                if (key < 0 || key > 16) {
                    throw new ExitException("Error: Level value out of range 0-16: " + s);
                }
                int value = Integer.parseInt(keyVal[1]);
                if (value <= 0 || value > 24) {
                    throw new ExitException("Error: Resolution value out of range 0-24: " + s);
                }
                levels[count] = new LevelInfo(key, value);
            }
            catch (NumberFormatException e) {
                throw new ExitException("Error: Levels specification not all numbers: " + levelSpec + " check " + s);
            }
            ++count;
        }
        Arrays.sort(levels);
        if (levels.length > 8) {
            throw new ExitException("Too many levels, the maximum is 8");
        }
        return levels;
    }

    public String toString() {
        return "L" + this.level + " B" + this.bits;
    }

    public int getLevel() {
        return this.level;
    }

    public int getBits() {
        return this.bits;
    }

    public boolean isTop() {
        return this.top;
    }

    public void setTop(boolean top) {
        this.top = top;
    }

    @Override
    public int compareTo(LevelInfo other) {
        if (other.getLevel() == this.getLevel()) {
            return 0;
        }
        if (other.getLevel() > this.getLevel()) {
            return 1;
        }
        return -1;
    }
}

