/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.awt.Rectangle;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapElement;

public class MapLine
extends MapElement {
    private static final Logger log = Logger.getLogger(MapLine.class);
    private List<Coord> points;
    private boolean direction;
    private boolean skipSizeFilter;
    private boolean wasClipped;
    private int minLat = Integer.MAX_VALUE;
    private int minLong = Integer.MAX_VALUE;
    private int maxLat = Integer.MIN_VALUE;
    private int maxLong = Integer.MIN_VALUE;

    public MapLine() {
    }

    public MapLine(MapLine orig) {
        super(orig);
        this.direction = orig.direction;
        this.skipSizeFilter = orig.skipSizeFilter;
    }

    @Override
    public MapLine copy() {
        return new MapLine(this);
    }

    public List<Coord> getPoints() {
        return this.points;
    }

    public void setPoints(List<Coord> points) {
        if (this.points != null) {
            log.warn((Object)"overwriting points");
        }
        assert (points != null) : "trying to set null points";
        assert (!points.isEmpty()) : "trying to set points with zero length";
        this.points = points;
        this.testForConsecutivePoints(points);
    }

    public void testForConsecutivePoints(List<Coord> points) {
        Coord last = null;
        for (Coord co : points) {
            if (last != null && last.equals(co)) {
                log.info((Object)("Line " + this.getName() + " has consecutive equal points at " + co.toDegreeString()));
                continue;
            }
            this.addToBounds(co);
            last = co;
        }
    }

    public void insertPointsAtStart(List<Coord> additionalPoints) {
        assert (this.points.get(0).equals(additionalPoints.get(additionalPoints.size() - 1)));
        this.testForConsecutivePoints(additionalPoints);
        this.points.get(0).preserved(true);
        this.points.addAll(0, additionalPoints.subList(0, additionalPoints.size() - 1));
    }

    public void insertPointsAtEnd(List<Coord> additionalPoints) {
        this.testForConsecutivePoints(additionalPoints);
        additionalPoints.get(0).preserved(true);
        this.points.remove(this.points.size() - 1);
        this.points.addAll(additionalPoints);
    }

    public boolean isDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public boolean isRoad() {
        return false;
    }

    public boolean isSkipSizeFilter() {
        return this.skipSizeFilter;
    }

    public void setSkipSizeFilter(boolean skipSizeFilter) {
        this.skipSizeFilter = skipSizeFilter;
    }

    public boolean wasClipped() {
        return this.wasClipped;
    }

    public void setClipped(boolean wasClipped) {
        this.wasClipped = wasClipped;
    }

    @Override
    public Coord getLocation() {
        return new Coord((this.minLat + this.maxLat) / 2, (this.minLong + this.maxLong) / 2);
    }

    private void addToBounds(Coord co) {
        int lon;
        int lat = co.getLatitude();
        if (lat < this.minLat) {
            this.minLat = lat;
        }
        if (lat > this.maxLat) {
            this.maxLat = lat;
        }
        if ((lon = co.getLongitude()) < this.minLong) {
            this.minLong = lon;
        }
        if (lon > this.maxLong) {
            this.maxLong = lon;
        }
    }

    public Area getBounds() {
        return new Area(this.minLat, this.minLong, this.maxLat, this.maxLong);
    }

    public Rectangle getRect() {
        return new Rectangle(this.minLong, this.minLat, this.maxLong - this.minLong, this.maxLat - this.minLat);
    }
}

